/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzfd;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlt;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public final class zzeu {
    public static final zzev zzbmb = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
        }
    };
    public static final zzev zzbmc = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzkn.zzdf((String)"URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzlt2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzlt2.zza("openableURLs", hashMap);
        }
    };
    public static final zzev zzbmd = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzlt2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzlt2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzlt2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzkn.zzb((String)"Error parsing the intent data.", (Throwable)jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzkn.zzb((String)"Error constructing openable urls response.", (Throwable)jSONException);
                }
            }
            zzlt2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzev zzbme = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzkn.zzdf((String)"URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzlt2.zzvt();
                if (object != null && ((zzau)object).zzc(uri)) {
                    uri = ((zzau)object).zza(uri, zzlt2.getContext(), zzlt2.getView());
                }
            }
            catch (zzav zzav2) {
                String string3 = String.valueOf(string2);
                zzkn.zzdf((String)(string3.length() != 0 ? "Unable to append parameter to URL: ".concat(string3) : new String("Unable to append parameter to URL: ")));
            }
            string2 = uri.toString();
            object = new zzlb(zzlt2.getContext(), zzlt2.zzvu().zzcs, string2);
            Future cfr_ignored_0 = (Future)((zzkm)object).zzqw();
        }
    };
    public static final zzev zzbmf = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzlt2.zzvp();
            if (zzd2 != null) {
                zzd2.close();
            } else {
                com.google.android.gms.ads.internal.overlay.zzd zzd3 = zzlt2.zzvq();
                if (zzd3 != null) {
                    zzd3.close();
                } else {
                    zzkn.zzdf((String)"A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzev zzbmg = new zzev(){

        private void zzd(zzlt zzlt2) {
            zzm zzm2;
            zzkn.zzde((String)"Received support message, responding.");
            boolean bl = false;
            zzd zzd2 = zzlt2.zzdp();
            if (zzd2 != null && (zzm2 = zzd2.zzame) != null) {
                bl = zzm2.zzr(zzlt2.getContext());
            }
            zzm2 = new JSONObject();
            try {
                zzm2.put("event", "checkSupport");
                zzm2.put("supports", bl);
                zzlt2.zzb("appStreaming", (JSONObject)zzm2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            if ("checkSupport".equals(map.get("action"))) {
                this.zzd(zzlt2);
                return;
            }
            com.google.android.gms.ads.internal.overlay.zzd zzd2 = zzlt2.zzvp();
            if (zzd2 != null) {
                zzd2.zzf(zzlt2, map);
            }
        }
    };
    public static final zzev zzbmh = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            zzlt2.zzak("1".equals(map.get("custom_close")));
        }
    };
    public static final zzev zzbmi = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzkn.zzdf((String)"URL missing from httpTrack GMSG.");
                return;
            }
            zzlb zzlb2 = new zzlb(zzlt2.getContext(), zzlt2.zzvu().zzcs, string2);
            Future cfr_ignored_0 = (Future)zzlb2.zzqw();
        }
    };
    public static final zzev zzbmj = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            String string2 = String.valueOf(map.get("string"));
            zzkn.zzde((String)(string2.length() != 0 ? "Received log message: ".concat(string2) : new String("Received log message: ")));
        }
    };
    public static final zzev zzbmk = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            zzg zzg2 = zzlt2.zzwg();
            if (zzg2 != null) {
                zzg2.zzlu();
            }
        }
    };
    public static final zzev zzbml = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzau zzau2 = zzlt2.zzvt();
                if (zzau2 != null) {
                    zzap zzap2 = zzau2.zzaw();
                    zzap2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzkn.zzdf((String)"Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzev zzbmm = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            if (!zzdi.zzbee.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zzlt2.zzal(!bl);
        }
    };
    public static final zzev zzbmn = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            String string2 = map.get("action");
            if ("pause".equals(string2)) {
                zzlt2.zzel();
            } else if ("resume".equals(string2)) {
                zzlt2.zzem();
            }
        }
    };
    public static final zzev zzbmo = new zzff();
    public static final zzev zzbmp = new zzfg();
    public static final zzev zzbmq = new zzfk();
    public static final zzev zzbmr = new zzet();
    public static final zzfd zzbms = new zzfd();
    public static final zzev zzbmt = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzlt2.zzvr().zzwp();
                return;
            }
            if (map.keySet().contains("stop")) {
                zzlt2.zzvr().zzwq();
                return;
            }
            if (map.keySet().contains("cancel")) {
                zzlt2.zzvr().zzwr();
                return;
            }
        }
    };
    public static final zzev zzbmu = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzlt2.zzam(true);
            }
            if (map.keySet().contains("stop")) {
                zzlt2.zzam(false);
            }
        }
    };
    public static final zzev zzbmv = new zzev(){

        @Override
        public void zza(zzlt zzlt2, Map<String, String> map) {
            WindowManager windowManager = (WindowManager)zzlt2.getContext().getSystemService("window");
            Map<String, Integer> map2 = zzu.zzfz().zza((View)zzlt2, windowManager);
            zzlt2.zza("locationReady", map2);
            zzkn.zzdf((String)"GET LOCATION COMPILED");
        }
    };
}

