/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.request.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zziy
public final class LargeParcelTeleporter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<LargeParcelTeleporter> CREATOR = new zzm();
    final int mVersionCode;
    ParcelFileDescriptor zzcie;
    private Parcelable zzcif;
    private boolean zzcig;

    LargeParcelTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor) {
        this.mVersionCode = n;
        this.zzcie = parcelFileDescriptor;
        this.zzcif = null;
        this.zzcig = true;
    }

    public LargeParcelTeleporter(SafeParcelable safeParcelable) {
        this.mVersionCode = 1;
        this.zzcie = null;
        this.zzcif = safeParcelable;
        this.zzcig = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcig) {
            byte[] byArray;
            if (this.zzcie == null) {
                zzkn.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcie));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzo.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcif = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcig = false;
        }
        return (T)((SafeParcelable)this.zzcif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzcie == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzcif.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzcie = this.zzi(byArray);
        }
        zzm.zza(this, parcel, n);
    }

    protected <T> ParcelFileDescriptor zzi(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable((OutputStream)autoCloseOutputStream2, byArray){
                final /* synthetic */ OutputStream zzcih;
                final /* synthetic */ byte[] zzcii;
                {
                    this.zzcih = outputStream;
                    this.zzcii = byArray;
                }

                @Override
                public void run() {
                    block7: {
                        DataOutputStream dataOutputStream = null;
                        try {
                            dataOutputStream = new DataOutputStream(this.zzcih);
                            dataOutputStream.writeInt(this.zzcii.length);
                            dataOutputStream.write(this.zzcii);
                        }
                        catch (IOException iOException) {
                            zzkn.zzb((String)"Error transporting the ad response", (Throwable)iOException);
                            zzu.zzgd().zza(iOException, "LargeParcelTeleporter.pipeData.1");
                            break block7;
                        }
                        finally {
                            if (dataOutputStream == null) {
                                zzo.zzb((Closeable)this.zzcih);
                            } else {
                                zzo.zzb((Closeable)dataOutputStream);
                            }
                        }
                        zzo.zzb((Closeable)dataOutputStream);
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzkn.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzu.zzgd().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzo.zzb(autoCloseOutputStream);
            return null;
        }
    }
}

