/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzlt;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzew
implements zzev {
    private final Context mContext;
    private final VersionInfoParcel zzanh;

    public zzew(Context context, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzanh = versionInfoParcel;
    }

    protected zzb zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzkn.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzmc());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzmh()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzkn.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    protected zzc zza(zzb zzb2) {
        try {
            Object object;
            HttpURLConnection httpURLConnection = (HttpURLConnection)zzb2.zzmd().openConnection();
            zzu.zzfz().zza(this.mContext, this.zzanh.zzcs, false, httpURLConnection);
            for (zza object22 : zzb2.zzme()) {
                httpURLConnection.addRequestProperty(object22.getKey(), object22.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzmf())) {
                httpURLConnection.setDoOutput(true);
                object = zzb2.zzmf().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object).length);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                bufferedOutputStream.write((byte[])object);
                bufferedOutputStream.close();
            }
            object = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : entry.getValue()) {
                        ((ArrayList)object).add(new zza(entry.getKey(), string2));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zzmc(), httpURLConnection.getResponseCode(), (List<zza>)object, zzu.zzfz().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            return new zzc(true, zzd2, null);
        }
        catch (Exception exception) {
            return new zzc(false, null, exception.toString());
        }
    }

    public JSONObject zzay(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzkn.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzc(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzmg());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzlt zzlt2, final Map<String, String> map) {
        zzkq.zza(new Runnable(){

            @Override
            public void run() {
                zzkn.zzdd((String)"Received Http request.");
                String string2 = (String)map.get("http_request");
                final JSONObject jSONObject = zzew.this.zzay(string2);
                if (jSONObject == null) {
                    zzkn.e((String)"Response should not be null.");
                    return;
                }
                zzkr.zzcrf.post(new Runnable(){

                    @Override
                    public void run() {
                        zzlt2.zzb("fetchHttpRequestCompleted", jSONObject);
                        zzkn.zzdd((String)"Dispatched http response.");
                    }
                });
            }
        });
    }

    @zziy
    class zzc {
        private final zzd zzbne;
        private final boolean zzbnf;
        private final String zzbng;

        public zzc(boolean bl, zzd zzd2, String string2) {
            this.zzbnf = bl;
            this.zzbne = zzd2;
            this.zzbng = string2;
        }

        public String getReason() {
            return this.zzbng;
        }

        public zzd zzmg() {
            return this.zzbne;
        }

        public boolean isSuccess() {
            return this.zzbnf;
        }
    }

    @zziy
    static class zzd {
        private final String zzbna;
        private final int zzbnh;
        private final List<zza> zzbni;
        private final String zzbjs;

        public zzd(String string2, int n, List<zza> list, String string3) {
            this.zzbna = string2;
            this.zzbnh = n;
            this.zzbni = list == null ? new ArrayList<zza>() : list;
            this.zzbjs = string3;
        }

        public String zzmc() {
            return this.zzbna;
        }

        public int getResponseCode() {
            return this.zzbnh;
        }

        public Iterable<zza> zzmh() {
            return this.zzbni;
        }

        public String getBody() {
            return this.zzbjs;
        }
    }

    @zziy
    static class zzb {
        private final String zzbna;
        private final URL zzbnb;
        private final ArrayList<zza> zzbnc;
        private final String zzbnd;

        public zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzbna = string2;
            this.zzbnb = uRL;
            this.zzbnc = arrayList == null ? new ArrayList() : arrayList;
            this.zzbnd = string3;
        }

        public String zzmc() {
            return this.zzbna;
        }

        public URL zzmd() {
            return this.zzbnb;
        }

        public ArrayList<zza> zzme() {
            return this.zzbnc;
        }

        public String zzmf() {
            return this.zzbnd;
        }
    }

    @zziy
    static class zza {
        private final String zzbaf;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzbaf = string2;
            this.mValue = string3;
        }

        public String getKey() {
            return this.zzbaf;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

