/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.cache;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.cache.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import java.util.List;

@zzji
public class CacheOffering
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CacheOffering> CREATOR = new zzd();
    public final int version;
    @Nullable
    public final String url;
    public final long zzayd;
    public final String zzaye;
    public final String zzayf;
    public final String zzayg;
    public final Bundle zzayh;
    public final boolean zzayi;

    @Nullable
    public static CacheOffering zzak(String string2) {
        return CacheOffering.zze(Uri.parse((String)string2));
    }

    @Nullable
    public static CacheOffering zze(Uri uri) {
        try {
            if (!"gcache".equals(uri.getScheme())) {
                return null;
            }
            List list = uri.getPathSegments();
            if (list.size() != 2) {
                int n = list.size();
                zzkx.zzdi((String)new StringBuilder(62).append("Expected 2 path parts for namespace and id, found :").append(n).toString());
                return null;
            }
            String string2 = (String)list.get(0);
            String string3 = (String)list.get(1);
            String string4 = uri.getHost();
            String string5 = uri.getQueryParameter("url");
            boolean bl = "1".equals(uri.getQueryParameter("read_only"));
            String string6 = uri.getQueryParameter("expiration");
            long l = string6 == null ? 0L : Long.parseLong(string6);
            Bundle bundle = new Bundle();
            for (String string7 : zzu.zzgo().zzh(uri)) {
                if (!string7.startsWith("tag.")) continue;
                String string8 = string7.substring("tag.".length());
                String string9 = uri.getQueryParameter(string7);
                bundle.putString(string8, string9);
            }
            return new CacheOffering(1, string5, l, string4, string2, string3, bundle, bl);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            zzkx.zzc((String)"Unable to parse Uri into cache offering.", (Throwable)runtimeException);
            return null;
        }
    }

    CacheOffering(int n, @Nullable String string2, long l, String string3, String string4, String string5, Bundle bundle, boolean bl) {
        this.version = n;
        this.url = string2;
        this.zzayd = l;
        this.zzaye = string3 != null ? string3 : "";
        this.zzayf = string4 != null ? string4 : "";
        this.zzayg = string5 != null ? string5 : "";
        this.zzayh = bundle != null ? bundle : new Bundle();
        this.zzayi = bl;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzd.zza(this, parcel, n);
    }
}

