/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;

@zzji
public class zzd
extends zzhy.zza
implements com.google.android.gms.ads.internal.overlay.zzu {
    static final int zzcak = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzcal;
    zzmd zzbnz;
    zzc zzcam;
    zzo zzcan;
    boolean zzcao = false;
    FrameLayout zzcap;
    WebChromeClient.CustomViewCallback zzcaq;
    boolean zzcar = false;
    boolean zzcas = false;
    zzb zzcat;
    boolean zzcau = false;
    int zzcav = 0;
    zzl zzcaw;
    private final Object zzcax = new Object();
    private Runnable zzcay;
    private boolean zzcaz;
    private boolean zzcba;
    private boolean zzcbb = false;
    private boolean zzcbc = false;
    private boolean zzcbd = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
        this.zzcaw = new zzs();
    }

    public void close() {
        this.zzcav = 2;
        this.mActivity.finish();
    }

    public void zzpl() {
        if (this.zzcal != null && this.zzcao) {
            this.setRequestedOrientation(this.zzcal.orientation);
        }
        if (this.zzcap != null) {
            this.mActivity.setContentView((View)this.zzcat);
            this.zzds();
            this.zzcap.removeAllViews();
            this.zzcap = null;
        }
        if (this.zzcaq != null) {
            this.zzcaq.onCustomViewHidden();
            this.zzcaq = null;
        }
        this.zzcao = false;
    }

    @Override
    public void zzpm() {
        this.zzcav = 1;
        this.mActivity.finish();
    }

    public void onBackPressed() {
        this.zzcav = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean zzpn() {
        this.zzcav = 0;
        if (this.zzbnz == null) {
            return true;
        }
        if (this.zzbnz.zzxi()) {
            if (true) {
                return true;
            }
        }
        boolean bl = false;
        boolean bl2 = bl;
        if (bl2) return bl2;
        this.zzbnz.zza("onbackblocked", Collections.emptyMap());
        return bl2;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzcar = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzcal = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzcal == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzcal.zzari.zzcyb > 7500000) {
                this.zzcav = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzcbd = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzcas = this.zzcal.zzcbv != null ? this.zzcal.zzcbv.zzaok : false;
            if (zzdr.zzbip.get().booleanValue() && this.zzcas && this.zzcal.zzcbv.zzaop != -1) {
                Future cfr_ignored_0 = (Future)new zzd().zzrz();
            }
            if (bundle == null) {
                if (this.zzcal.zzcbl != null && this.zzcbd) {
                    this.zzcal.zzcbl.zzer();
                }
                if (this.zzcal.zzcbs != 1 && this.zzcal.zzcbk != null) {
                    this.zzcal.zzcbk.onAdClicked();
                }
            }
            this.zzcat = new zzb((Context)this.mActivity, this.zzcal.zzcbu);
            this.zzcat.setId(1000);
            switch (this.zzcal.zzcbs) {
                case 1: {
                    this.zzab(false);
                    break;
                }
                case 2: {
                    this.zzcam = new zzc(this.zzcal.zzcbm);
                    this.zzab(false);
                    break;
                }
                case 3: {
                    this.zzab(true);
                    break;
                }
                case 4: {
                    if (this.zzcar) {
                        this.zzcav = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzu.zzgj().zza((Context)this.mActivity, this.zzcal.zzcbj, this.zzcal.zzcbr)) {
                        this.zzcav = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzkx.zzdi((String)zza2.getMessage());
            this.zzcav = 3;
            this.mActivity.finish();
        }
    }

    public void onRestart() {
    }

    public void onStart() {
        boolean bl = zzdr.zzblf.get();
        if (bl) {
            if (this.zzbnz != null && !this.zzbnz.isDestroyed()) {
                zzu.zzgo().zzm(this.zzbnz);
            } else {
                zzkx.zzdi((String)"The webview does not exist. Ignoring action.");
            }
        }
    }

    public void onResume() {
        boolean bl;
        if (this.zzcal != null && this.zzcal.zzcbs == 4) {
            if (this.zzcar) {
                this.zzcav = 3;
                this.mActivity.finish();
            } else {
                this.zzcar = true;
            }
        }
        if (this.zzcal.zzcbl != null) {
            this.zzcal.zzcbl.onResume();
        }
        if (!(bl = zzdr.zzblf.get().booleanValue())) {
            if (this.zzbnz != null && !this.zzbnz.isDestroyed()) {
                zzu.zzgo().zzm(this.zzbnz);
            } else {
                zzkx.zzdi((String)"The webview does not exist. Ignoring action.");
            }
        }
        this.zzcaw.resume();
    }

    public void onPause() {
        boolean bl;
        this.zzcaw.pause();
        this.zzpl();
        if (this.zzcal.zzcbl != null) {
            this.zzcal.zzcbl.onPause();
        }
        if (!((bl = zzdr.zzblf.get().booleanValue()) || this.zzbnz == null || this.mActivity.isFinishing() && this.zzcam != null)) {
            zzu.zzgo().zzl(this.zzbnz);
        }
        this.zzpp();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
    }

    public void zzn(com.google.android.gms.dynamic.zzd zzd2) {
        if (zzdr.zzble.get().booleanValue() && com.google.android.gms.common.util.zzs.isAtLeastN()) {
            Configuration configuration = (Configuration)zze.zzae((com.google.android.gms.dynamic.zzd)zzd2);
            if (zzu.zzgm().zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
            } else {
                this.mActivity.getWindow().addFlags(2048);
                this.mActivity.getWindow().clearFlags(1024);
            }
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzcar);
    }

    public void onStop() {
        boolean bl = zzdr.zzblf.get();
        if (bl && this.zzbnz != null && (!this.mActivity.isFinishing() || this.zzcam == null)) {
            zzu.zzgo().zzl(this.zzbnz);
        }
        this.zzpp();
    }

    public void onDestroy() {
        if (this.zzbnz != null) {
            this.zzcat.removeView(this.zzbnz.getView());
        }
        this.zzpp();
    }

    public void zzaa(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzcan = new zzo((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzcan.zza(bl, this.zzcal.zzcbp);
        this.zzcat.addView((View)this.zzcan, (ViewGroup.LayoutParams)layoutParams);
    }

    public void zzds() {
        this.zzcba = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzcan != null) {
            this.zzcan.zza(bl, bl2);
        }
    }

    public void zzpo() {
        this.zzcat.removeView((View)this.zzcan);
        this.zzaa(true);
    }

    public void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzcap = new FrameLayout((Context)this.mActivity);
        this.zzcap.setBackgroundColor(-16777216);
        this.zzcap.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzcap);
        this.zzds();
        this.zzcaq = customViewCallback;
        this.zzcao = true;
    }

    protected void zzab(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zzd zzd2;
        zzm zzm2;
        zzme zzme2;
        boolean bl2;
        Window window;
        if (!this.zzcba) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (com.google.android.gms.common.util.zzs.isAtLeastN() && zzdr.zzble.get().booleanValue()) {
            bl3 = zzu.zzgm().zza(this.mActivity, this.mActivity.getResources().getConfiguration());
        }
        boolean bl4 = bl2 = this.zzcal.zzcbv != null && this.zzcal.zzcbv.zzaol;
        if ((!this.zzcas || bl2) && bl3) {
            window.setFlags(1024, 1024);
        }
        boolean bl5 = (zzme2 = this.zzcal.zzcbm.zzxc()) != null ? zzme2.zzic() : false;
        this.zzcau = false;
        if (bl5) {
            if (this.zzcal.orientation == zzu.zzgo().zzvw()) {
                this.zzcau = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzcal.orientation == zzu.zzgo().zzvx()) {
                this.zzcau = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzcau;
        zzkx.zzdg((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzcal.orientation);
        if (zzu.zzgo().zza(window)) {
            zzkx.zzdg((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzcas) {
            this.zzcat.setBackgroundColor(-16777216);
        } else {
            this.zzcat.setBackgroundColor(zzcak);
        }
        this.mActivity.setContentView((View)this.zzcat);
        this.zzds();
        if (bl) {
            this.zzbnz = zzu.zzgn().zza((Context)this.mActivity, this.zzcal.zzcbm.zzeg(), true, bl5, null, this.zzcal.zzari, null, null, this.zzcal.zzcbm.zzec());
            this.zzbnz.zzxc().zza(null, null, this.zzcal.zzcbn, this.zzcal.zzcbr, true, this.zzcal.zzcbt, null, this.zzcal.zzcbm.zzxc().zzxu(), null, null);
            this.zzbnz.zzxc().zza(new zzme.zza(){

                @Override
                public void zza(zzmd zzmd2, boolean bl) {
                    zzmd2.zzps();
                }
            });
            if (this.zzcal.url != null) {
                this.zzbnz.loadUrl(this.zzcal.url);
            } else if (this.zzcal.zzcbq != null) {
                this.zzbnz.loadDataWithBaseURL(this.zzcal.zzcbo, this.zzcal.zzcbq, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzcal.zzcbm != null) {
                this.zzcal.zzcbm.zzc(this);
            }
        } else {
            this.zzbnz = this.zzcal.zzcbm;
            this.zzbnz.setContext((Context)this.mActivity);
        }
        this.zzbnz.zzb(this);
        ViewParent viewParent = this.zzbnz.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzbnz.getView());
        }
        if (this.zzcas) {
            this.zzbnz.zzxt();
        }
        this.zzcat.addView(this.zzbnz.getView(), -1, -1);
        if (!bl && !this.zzcau) {
            this.zzps();
        }
        this.zzaa(bl5);
        if (this.zzbnz.zzxd()) {
            this.zza(bl5, true);
        }
        zzm zzm3 = zzm2 = (zzd2 = this.zzbnz.zzec()) != null ? zzd2.zzamr : null;
        if (zzm2 != null) {
            this.zzcaw = zzm2.zza(this.mActivity, this.zzbnz, this.zzcat);
        } else {
            zzkx.zzdi((String)"Appstreaming controller is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzpp() {
        if (!this.mActivity.isFinishing() || this.zzcbb) {
            return;
        }
        this.zzcbb = true;
        if (this.zzbnz != null) {
            this.zzak(this.zzcav);
            Object object = this.zzcax;
            synchronized (object) {
                if (!this.zzcaz && this.zzbnz.zzxo()) {
                    this.zzcay = new Runnable(){

                        @Override
                        public void run() {
                            zzd.this.zzpq();
                        }
                    };
                    zzlb.zzcvl.postDelayed(this.zzcay, zzdr.zzbgf.get().longValue());
                    return;
                }
            }
        }
        this.zzpq();
    }

    void zzpq() {
        if (this.zzcbc) {
            return;
        }
        this.zzcbc = true;
        if (this.zzbnz != null) {
            this.zzcat.removeView(this.zzbnz.getView());
            if (this.zzcam != null) {
                this.zzbnz.setContext(this.zzcam.zzahs);
                this.zzbnz.zzak(false);
                this.zzcam.parent.addView(this.zzbnz.getView(), this.zzcam.index, this.zzcam.zzcbg);
                this.zzcam = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbnz.setContext(this.mActivity.getApplicationContext());
            }
            this.zzbnz = null;
        }
        if (this.zzcal != null && this.zzcal.zzcbl != null) {
            this.zzcal.zzcbl.zzeq();
        }
        this.zzcaw.destroy();
    }

    public void zzpr() {
        if (this.zzcau) {
            this.zzcau = false;
            this.zzps();
        }
    }

    protected void zzps() {
        this.zzbnz.zzps();
    }

    protected void zzak(int n) {
        this.zzbnz.zzak(n);
    }

    public void zzg(zzmd zzmd2, Map<String, String> map) {
        this.zzcaw.zzg(zzmd2, map);
    }

    public void zzpt() {
        this.zzcat.disable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzpu() {
        Object object = this.zzcax;
        synchronized (object) {
            this.zzcaz = true;
            if (this.zzcay != null) {
                zzlb.zzcvl.removeCallbacks(this.zzcay);
                zzlb.zzcvl.post(this.zzcay);
            }
        }
    }

    @zzji
    private class zzd
    extends zzkw {
        private zzd() {
        }

        @Override
        public void zzfp() {
            Bitmap bitmap = zzu.zzhh().zza(zzd.this.zzcal.zzcbv.zzaop);
            if (bitmap != null) {
                final Drawable drawable = zzu.zzgo().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzcal.zzcbv.zzaon, zzd.this.zzcal.zzcbv.zzaoo);
                zzlb.zzcvl.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzji
    static class zzb
    extends RelativeLayout {
        zzle zzasr;
        boolean zzcbf;

        public zzb(Context context, String string2) {
            super(context);
            this.zzasr = new zzle(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (!this.zzcbf) {
                this.zzasr.zzg(motionEvent);
            }
            return false;
        }

        void disable() {
            this.zzcbf = true;
        }
    }

    @zzji
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzcbg;
        public final ViewGroup parent;
        public final Context zzahs;

        public zzc(zzmd zzmd2) throws zza {
            this.zzcbg = zzmd2.getLayoutParams();
            ViewParent viewParent = zzmd2.getParent();
            this.zzahs = zzmd2.zzwz();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.parent = (ViewGroup)viewParent;
            this.index = this.parent.indexOfChild(zzmd2.getView());
            this.parent.removeView(zzmd2.getView());
            zzmd2.zzak(true);
        }
    }

    @zzji
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

