/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzz;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzmd;
import java.util.HashMap;

@zzji
public class zzk
extends FrameLayout
implements zzh {
    private final zzmd zzbnz;
    private final FrameLayout zzcby;
    private final zzdz zzcbz;
    private final zzz zzcca;
    private final long zzccb;
    @Nullable
    private zzi zzccc;
    private boolean zzccd;
    private boolean zzcce;
    private boolean zzccf;
    private boolean zzccg;
    private long zzcch;
    private long zzcci;
    private String zzbrb;
    private Bitmap zzccj;
    private ImageView zzcck;
    private boolean zzccl;

    public static void zzi(zzmd zzmd2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzmd2.zza("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzmd zzmd2, int n, boolean bl, zzdz zzdz2) {
        super(context);
        this.zzbnz = zzmd2;
        this.zzcbz = zzdz2;
        this.zzcby = new FrameLayout(context);
        this.addView((View)this.zzcby, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzu((Object)zzmd2.zzec());
        this.zzccc = zzmd2.zzec().zzamq.zza(context, zzmd2, n, bl, zzdz2);
        if (this.zzccc != null) {
            this.zzcby.addView((View)this.zzccc, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            if (zzdr.zzbdx.get().booleanValue()) {
                this.zzqj();
            }
        }
        this.zzcck = new ImageView(context);
        this.zzccb = zzdr.zzbeb.get();
        this.zzccg = zzdr.zzbdz.get();
        if (this.zzcbz != null) {
            this.zzcbz.zzg("spinner_used", this.zzccg ? "1" : "0");
        }
        this.zzcca = new zzz(this);
        this.zzcca.zzrg();
        if (this.zzccc != null) {
            this.zzccc.zza(this);
        }
        if (this.zzccc == null) {
            this.zzk("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    private void zzg(int n, int n2) {
        if (!this.zzccg) {
            return;
        }
        n = Math.max(n / zzdr.zzbea.get(), 1);
        n2 = Math.max(n2 / zzdr.zzbea.get(), 1);
        if (this.zzccj != null && this.zzccj.getWidth() == n && this.zzccj.getHeight() == n2) {
            return;
        }
        this.zzccj = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.zzccl = false;
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzcby.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void zzce(String string2) {
        this.zzbrb = string2;
    }

    public void zza(float f, float f2) {
        if (this.zzccc != null) {
            this.zzccc.zza(f, f2);
        }
    }

    public void zznt() {
        if (this.zzccc == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzbrb)) {
            this.zzccc.setVideoPath(this.zzbrb);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzccc == null) {
            return;
        }
        this.zzccc.pause();
    }

    public void play() {
        if (this.zzccc == null) {
            return;
        }
        this.zzccc.play();
    }

    public void seekTo(int n) {
        if (this.zzccc == null) {
            return;
        }
        this.zzccc.seekTo(n);
    }

    public void zzqh() {
        if (this.zzccc == null) {
            return;
        }
        this.zzccc.zzqh();
    }

    public void zzqi() {
        if (this.zzccc == null) {
            return;
        }
        this.zzccc.zzqi();
    }

    public void zzb(float f) {
        if (this.zzccc == null) {
            return;
        }
        this.zzccc.zzb(f);
    }

    @TargetApi(value=14)
    public void zzf(MotionEvent motionEvent) {
        if (this.zzccc == null) {
            return;
        }
        this.zzccc.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public void zzqj() {
        if (this.zzccc == null) {
            return;
        }
        Context context = this.zzccc.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzccc.zzpg());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzcby.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzcby.bringChildToFront((View)textView);
    }

    @Override
    public void zzqb() {
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceCreated", new String[0]);
            }
        });
    }

    @Override
    public void zzqc() {
        if (this.zzccc == null) {
            return;
        }
        if (this.zzcci == 0L) {
            float f = (float)this.zzccc.getDuration() / 1000.0f;
            int n = this.zzccc.getVideoWidth();
            int n2 = this.zzccc.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzqd() {
        this.zzqp();
        this.zzccd = true;
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzqq();
        this.zzccd = false;
    }

    @Override
    public void zzqe() {
        this.zza("ended", new String[0]);
        this.zzqq();
    }

    @Override
    public void zzk(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public void zzqf() {
        this.zzqm();
        this.zzcci = this.zzcch;
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceDestroyed", new String[0]);
            }
        });
    }

    public void destroy() {
        this.zzcca.cancel();
        if (this.zzccc != null) {
            this.zzccc.stop();
        }
        this.zzqq();
    }

    void zzqk() {
        if (this.zzccc == null) {
            return;
        }
        long l = this.zzccc.getCurrentPosition();
        if (this.zzcch != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzcch = l;
        }
    }

    @Override
    public void zzqg() {
        if (this.zzccd) {
            this.zzqn();
        }
        this.zzql();
    }

    @Override
    public void zzf(int n, int n2) {
        this.zzg(n, n2);
    }

    @TargetApi(value=14)
    private void zzql() {
        if (this.zzccj == null) {
            return;
        }
        long l = zzu.zzgs().elapsedRealtime();
        if (this.zzccc.getBitmap(this.zzccj) != null) {
            this.zzccl = true;
        }
        long l2 = zzu.zzgs().elapsedRealtime() - l;
        if (zzkx.zzvo()) {
            zzkx.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
        }
        if (l2 > this.zzccb) {
            zzkx.zzdi((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
            this.zzccg = false;
            this.zzccj = null;
            if (this.zzcbz != null) {
                this.zzcbz.zzg("spinner_jank", Long.toString(l2));
            }
        }
    }

    private void zzqm() {
        if (this.zzccl && this.zzccj != null && !this.zzqo()) {
            this.zzcck.setImageBitmap(this.zzccj);
            this.zzcck.invalidate();
            this.zzcby.addView((View)this.zzcck, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzcby.bringChildToFront((View)this.zzcck);
        }
    }

    private void zzqn() {
        if (this.zzqo()) {
            this.zzcby.removeView((View)this.zzcck);
        }
    }

    private boolean zzqo() {
        return this.zzcck.getParent() != null;
    }

    private void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        for (String string4 : stringArray) {
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzbnz.zza("onVideoEvent", hashMap);
    }

    private void zzqp() {
        if (this.zzbnz.zzwy() == null) {
            return;
        }
        if (this.zzcce) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzbnz.zzwy().getWindow().getAttributes();
        boolean bl = this.zzccf = (layoutParams.flags & 0x80) != 0;
        if (!this.zzccf) {
            this.zzbnz.zzwy().getWindow().addFlags(128);
            this.zzcce = true;
        }
    }

    private void zzqq() {
        if (this.zzbnz.zzwy() == null) {
            return;
        }
        if (this.zzcce && !this.zzccf) {
            this.zzbnz.zzwy().getWindow().clearFlags(128);
            this.zzcce = false;
        }
    }
}

