/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.TextureView;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdv;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlh;
import java.util.concurrent.TimeUnit;

@zzji
public class zzy {
    private final Context mContext;
    private final String zzcec;
    private final VersionInfoParcel zzapc;
    @Nullable
    private final zzdx zzced;
    @Nullable
    private final zzdz zzcbz;
    private final zzlh zzcee = new zzlh.zzb().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzwi();
    private final long[] zzcef;
    private final String[] zzceg;
    private boolean zzceh = false;
    private boolean zzcei = false;
    private boolean zzcej = false;
    private boolean zzcek = false;
    private boolean zzccd;
    private zzi zzcel;
    private boolean zzcem;
    private boolean zzcen;
    private long zzceo = -1L;

    public zzy(Context context, VersionInfoParcel versionInfoParcel, String string2, @Nullable zzdz zzdz2, @Nullable zzdx zzdx2) {
        this.mContext = context;
        this.zzapc = versionInfoParcel;
        this.zzcec = string2;
        this.zzcbz = zzdz2;
        this.zzced = zzdx2;
        String string3 = zzdr.zzbdv.get();
        if (string3 == null) {
            this.zzceg = new String[0];
            this.zzcef = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string3, (String)",");
        this.zzceg = new String[stringArray.length];
        this.zzcef = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzcef[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzkx.zzc((String)"Unable to parse frame hash target time number.", (Throwable)numberFormatException);
                this.zzcef[i] = -1L;
            }
        }
    }

    public void zza(zzi zzi2) {
        zzdv.zza(this.zzcbz, this.zzced, "vpc2");
        this.zzceh = true;
        if (this.zzcbz != null) {
            this.zzcbz.zzg("vpn", zzi2.zzpg());
        }
        this.zzcel = zzi2;
    }

    public void zzqc() {
        if (!this.zzceh || this.zzcei) {
            return;
        }
        zzdv.zza(this.zzcbz, this.zzced, "vfr2");
        this.zzcei = true;
    }

    public void onStop() {
        if (zzdr.zzbdu.get().booleanValue() && !this.zzcem) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzcec);
            bundle.putString("player", this.zzcel.zzpg());
            for (zzlh.zza object : this.zzcee.getBuckets()) {
                String string2 = String.valueOf("fps_c_");
                String string3 = String.valueOf(object.name);
                bundle.putString(string3.length() != 0 ? string2.concat(string3) : new String(string2), Integer.toString(object.count));
                String string4 = String.valueOf("fps_p_");
                String string5 = String.valueOf(object.name);
                bundle.putString(string5.length() != 0 ? string4.concat(string5) : new String(string4), Double.toString(object.zzcwo));
            }
            for (int i = 0; i < this.zzcef.length; ++i) {
                String string6 = this.zzceg[i];
                if (string6 == null) continue;
                String string7 = String.valueOf("fh_");
                String string8 = String.valueOf((Object)this.zzcef[i]);
                bundle.putString(new StringBuilder(0 + String.valueOf(string7).length() + String.valueOf(string8).length()).append(string7).append(string8).toString(), string6);
            }
            zzu.zzgm().zza(this.mContext, this.zzapc.zzda, "gmob-apps", bundle, true);
            this.zzcem = true;
        }
    }

    public void zzb(zzi zzi2) {
        this.zzrd();
        this.zzc(zzi2);
    }

    private void zzrd() {
        if (this.zzcej && !this.zzcek) {
            zzdv.zza(this.zzcbz, this.zzced, "vff2");
            this.zzcek = true;
        }
        long l = zzu.zzgs().nanoTime();
        if (this.zzccd && this.zzcen && this.zzceo != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - this.zzceo);
            this.zzcee.zza(d);
        }
        this.zzcen = this.zzccd;
        this.zzceo = l;
    }

    private void zzc(zzi zzi2) {
        long l = zzdr.zzbdw.get();
        long l2 = zzi2.getCurrentPosition();
        for (int i = 0; i < this.zzceg.length; ++i) {
            long l3;
            if (this.zzceg[i] != null || l <= Math.abs(l2 - (l3 = this.zzcef[i]))) continue;
            this.zzceg[i] = this.zza((TextureView)zzi2);
            break;
        }
    }

    @TargetApi(value=14)
    String zza(TextureView textureView) {
        Bitmap bitmap = textureView.getBitmap(8, 8);
        long l = 0L;
        long l2 = 63L;
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                int n2 = bitmap.getPixel(n, i);
                int n3 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2);
                long l3 = n3 > 128 ? 1L : 0L;
                l |= l3 << (int)l2;
                ++n;
                --l2;
            }
        }
        return String.format("%016X", l);
    }

    public void zzre() {
        this.zzccd = true;
        if (this.zzcei && !this.zzcej) {
            zzdv.zza(this.zzcbz, this.zzced, "vfp2");
            this.zzcej = true;
        }
    }

    public void zzrf() {
        this.zzccd = false;
    }
}

