/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzji
public class zzc
extends zzkw
implements ServiceConnection {
    private final Object zzako = new Object();
    private boolean zzcff = false;
    private Context mContext;
    private zzik zzbta;
    private zzb zzcfg;
    private zzh zzcfh;
    private List<zzf> zzcfi = null;
    private zzk zzcfj;

    public zzc(Context context, zzik zzik2, zzk zzk2) {
        this(context, zzik2, zzk2, new zzb(context), zzh.zzq(context.getApplicationContext()));
    }

    zzc(Context context, zzik zzik2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzbta = zzik2;
        this.zzcfj = zzk2;
        this.zzcfg = zzb2;
        this.zzcfh = zzh2;
        this.zzcfi = this.zzcfh.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzfp() {
        Object object = this.zzako;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            zza.zzaxr().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            zza.zzaxr().zza(this.mContext, (ServiceConnection)this);
            this.zzcfg.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzako;
        synchronized (object) {
            zza.zzaxr().zza(this.mContext, (ServiceConnection)this);
            this.zzcfg.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        zzkx.zzdh((String)"In-app billing service disconnected.");
        this.zzcfg.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzcfg.zzav(iBinder);
            this.zzrr();
            this.zzcff = true;
            this.zzako.notify();
        }
    }

    protected void zzrr() {
        int n;
        Bundle bundle;
        if (this.zzcfi.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzcfi) {
            hashMap.put(object2.zzcfv, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzcfg.zzm(this.mContext.getPackageName(), (String)object3)) != null && (n = zzu.zzha().zzd(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string2 = (String)arrayList.get(i);
                String string3 = (String)arrayList2.get(i);
                String string4 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string2);
                String string5 = zzu.zzha().zzcg(string3);
                if (!zzf2.zzcfu.equals(string5)) continue;
                this.zza(zzf2, string3, string4);
                hashMap.remove(string2);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string6 : hashMap.keySet()) {
            this.zzcfh.zza((zzf)hashMap.get(string6));
        }
    }

    protected void zza(final zzf zzf2, String string2, String string3) {
        final Intent intent = new Intent();
        zzu.zzha();
        intent.putExtra("RESPONSE_CODE", 0);
        zzu.zzha();
        intent.putExtra("INAPP_PURCHASE_DATA", string2);
        zzu.zzha();
        intent.putExtra("INAPP_DATA_SIGNATURE", string3);
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzcfj.zza(zzf2.zzcfu, -1, intent)) {
                        zzc.this.zzbta.zza((zzij)new zzg(zzc.this.mContext, zzf2.zzcfv, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzbta.zza((zzij)new zzg(zzc.this.mContext, zzf2.zzcfv, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzkx.zzdi((String)"Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l) {
        do {
            if (this.zzf(l)) continue;
            zzkx.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzcff);
    }

    private boolean zzf(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzako.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            zzkx.zzdi((String)"waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

