/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.request.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzji
public final class LargeParcelTeleporter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<LargeParcelTeleporter> CREATOR = new zzm();
    final int mVersionCode;
    ParcelFileDescriptor zzcme;
    private Parcelable zzcmf;
    private boolean zzcmg;

    LargeParcelTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor) {
        this.mVersionCode = n;
        this.zzcme = parcelFileDescriptor;
        this.zzcmf = null;
        this.zzcmg = true;
    }

    public LargeParcelTeleporter(SafeParcelable safeParcelable) {
        this.mVersionCode = 1;
        this.zzcme = null;
        this.zzcmf = safeParcelable;
        this.zzcmg = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzcmg) {
            byte[] byArray;
            if (this.zzcme == null) {
                zzkx.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcme));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzo.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzcmf = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzcmg = false;
        }
        return (T)((SafeParcelable)this.zzcmf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzcme == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzcmf.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzcme = this.zzj(byArray);
        }
        zzm.zza(this, parcel, n);
    }

    protected <T> ParcelFileDescriptor zzj(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable((OutputStream)autoCloseOutputStream2, byArray){
                final /* synthetic */ OutputStream zzcmh;
                final /* synthetic */ byte[] zzcmi;
                {
                    this.zzcmh = outputStream;
                    this.zzcmi = byArray;
                }

                @Override
                public void run() {
                    block7: {
                        DataOutputStream dataOutputStream = null;
                        try {
                            dataOutputStream = new DataOutputStream(this.zzcmh);
                            dataOutputStream.writeInt(this.zzcmi.length);
                            dataOutputStream.write(this.zzcmi);
                        }
                        catch (IOException iOException) {
                            zzkx.zzb((String)"Error transporting the ad response", (Throwable)iOException);
                            zzu.zzgq().zza(iOException, "LargeParcelTeleporter.pipeData.1");
                            break block7;
                        }
                        finally {
                            if (dataOutputStream == null) {
                                zzo.zzb((Closeable)this.zzcmh);
                            } else {
                                zzo.zzb((Closeable)dataOutputStream);
                            }
                        }
                        zzo.zzb((Closeable)dataOutputStream);
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzkx.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzu.zzgq().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzo.zzb(autoCloseOutputStream);
            return null;
        }
    }
}

