/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zzc;
import com.google.android.gms.gass.internal.zza;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzasa;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzay;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzdr;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzbc {
    private static final String TAG = zzbc.class.getSimpleName();
    protected Context zzahs;
    protected Context zzaht;
    private ExecutorService zzahu;
    private DexClassLoader zzahv;
    private zzax zzahw;
    private byte[] zzahx;
    private volatile AdvertisingIdClient zzahy = null;
    private volatile boolean zzagy = false;
    private Future zzahz = null;
    private volatile zzaf.zza zzaia = null;
    private Future zzaib = null;
    private volatile boolean zzaic = false;
    protected static final Object zzaid = new Object();
    private zzap zzaie;
    private GoogleApiClient zzaif = null;
    protected boolean zzaig = false;
    protected static final Object zzaih = new Object();
    protected boolean zzaii = false;
    private static zzc zzaij = null;
    protected boolean zzaik = false;
    private Map<Pair<String, String>, zzbx> zzail;

    public static zzbc zza(Context context, String string2, String string3, boolean bl) {
        zzbc zzbc2 = new zzbc(context);
        try {
            if (zzbc2.zzc(string2, string3, bl)) {
                return zzbc2;
            }
        }
        catch (zzaz zzaz2) {
            // empty catch block
        }
        return null;
    }

    public Context getContext() {
        return this.zzahs;
    }

    public Context getApplicationContext() {
        return this.zzaht;
    }

    public ExecutorService zzcm() {
        return this.zzahu;
    }

    public DexClassLoader zzcn() {
        return this.zzahv;
    }

    public zzax zzco() {
        return this.zzahw;
    }

    public byte[] zzcp() {
        return this.zzahx;
    }

    public GoogleApiClient zzcq() {
        return this.zzaif;
    }

    public boolean zzcr() {
        return this.zzaig;
    }

    public boolean zzcs() {
        return this.zzaik;
    }

    public zzap zzct() {
        return this.zzaie;
    }

    public boolean zzcu() {
        return this.zzaii;
    }

    public zzaf.zza zzcv() {
        return this.zzaia;
    }

    public Future zzcw() {
        return this.zzaib;
    }

    private zzbc(Context context) {
        this.zzahs = context;
        this.zzaht = context.getApplicationContext();
        this.zzail = new HashMap<Pair<String, String>, zzbx>();
    }

    private boolean zzc(String string2, String string3, boolean bl) throws zzaz {
        this.zzahu = Executors.newCachedThreadPool();
        this.zzc(bl);
        this.zzdb();
        this.zzcy();
        if (zzbe.zzdg() && zzdr.zzbih.get().booleanValue()) {
            throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
        }
        this.zzo(string2);
        boolean bl2 = this.zzp(string3);
        this.zzaie = new zzap(this);
        return true;
    }

    private void zzo(String string2) throws zzaz {
        this.zzahw = new zzax(null);
        try {
            this.zzahx = this.zzahw.zzn(string2);
        }
        catch (zzax.zza zza2) {
            throw new zzaz(zza2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzp(String string2) throws zzaz {
        try {
            File file = this.zzahs.getCacheDir();
            if (file == null && (file = this.zzahs.getDir("dex", 0)) == null) {
                throw new zzaz();
            }
            String string3 = zzay.zzba();
            File file2 = this.zza(string2, file, string3);
            this.zzb(file, string3);
            try {
                this.zzahv = new DexClassLoader(file2.getAbsolutePath(), file.getAbsolutePath(), null, this.zzahs.getClassLoader());
                boolean bl = true;
                this.zza(file2);
                this.zza(file, string3);
            }
            catch (Throwable throwable) {
                this.zza(file2);
                this.zza(file, string3);
                this.zzq(String.format("%s/%s.dex", file, string3));
                throw throwable;
            }
            this.zzq(String.format("%s/%s.dex", file, string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new zzaz(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new zzaz(iOException);
        }
        catch (zzax.zza zza2) {
            throw new zzaz(zza2);
        }
        catch (NullPointerException nullPointerException) {
            throw new zzaz(nullPointerException);
        }
        return true;
    }

    @NonNull
    private File zza(String string2, File file, String string3) throws zzax.zza, IOException {
        File file2 = new File(String.format("%s/%s.jar", file, string3));
        if (!file2.exists()) {
            byte[] byArray = this.zzahw.zzc(this.zzahx, string2);
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zza(File file, String string2) {
        block29: {
            byte[] byArray;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            File file3;
            block28: {
                file3 = new File(String.format("%s/%s.tmp", file, string2));
                if (file3.exists()) {
                    return;
                }
                file2 = new File(String.format("%s/%s.dex", file, string2));
                if (!file2.exists()) {
                    return;
                }
                fileInputStream = null;
                fileOutputStream = null;
                long l = file2.length();
                if (l <= 0L) {
                    return;
                }
                byArray = new byte[(int)l];
                fileInputStream = new FileInputStream(file2);
                int n = fileInputStream.read(byArray);
                if (n > 0) break block28;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.zza(file2);
                return;
            }
            try {
                zzaf.zzd zzd2 = new zzaf.zzd();
                zzd2.zzfx = Build.VERSION.SDK.getBytes();
                zzd2.zzfw = string2.getBytes();
                byte[] byArray2 = this.zzahw.zzd(this.zzahx, byArray).getBytes();
                zzd2.data = byArray2;
                zzd2.zzfv = zzan.zzh(byArray2);
                byArray = null;
                file3.createNewFile();
                fileOutputStream = new FileOutputStream(file3);
                byte[] byArray3 = zzasa.zzf((zzasa)zzd2);
                zzd2 = null;
                fileOutputStream.write(byArray3, 0, byArray3.length);
                fileOutputStream.close();
            }
            catch (zzax.zza | IOException | NoSuchAlgorithmException exception) {
                break block29;
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                this.zza(file2);
            }
        }
    }

    private void zzq(String string2) {
        File file = new File(string2);
        this.zza(file);
    }

    private void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean zzb(File file, String string2) {
        File file2 = new File(String.format("%s/%s.tmp", file, string2));
        if (!file2.exists()) {
            return false;
        }
        File file3 = new File(String.format("%s/%s.dex", file, string2));
        if (file3.exists()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            long l = file2.length();
            if (l <= 0L) {
                this.zza(file2);
                boolean bl = false;
                try {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[(int)l];
            int n = fileInputStream.read(byArray);
            if (n <= 0) {
                Log.d((String)TAG, (String)"Cannot read the cache data.");
                this.zza(file2);
                boolean bl = false;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            zzaf.zzd zzd2 = zzaf.zzd.zze((byte[])byArray);
            byArray = null;
            if (!(string2.equals(new String(zzd2.zzfw)) && Arrays.equals(zzd2.zzfv, zzan.zzh(zzd2.data)) && Arrays.equals(zzd2.zzfx, Build.VERSION.SDK.getBytes()))) {
                this.zza(file2);
                boolean bl = false;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            byte[] byArray2 = this.zzahw.zzc(this.zzahx, new String(zzd2.data));
            file3.createNewFile();
            fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byArray2, 0, byArray2.length);
            return true;
        }
        catch (zzax.zza | IOException | NoSuchAlgorithmException exception) {
            boolean bl = false;
            return false;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean zza(String string2, String string3, List<Class> list) {
        if (!this.zzail.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzail.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzbx(this, string2, string3, list));
            return true;
        }
        return false;
    }

    public Method zzc(String string2, String string3) {
        zzbx zzbx2 = this.zzail.get(new Pair((Object)string2, (Object)string3));
        if (zzbx2 == null) {
            return null;
        }
        return zzbx2.zzdq();
    }

    private void zzc(boolean bl) {
        this.zzagy = bl;
        if (!bl) {
            return;
        }
        this.zzahz = this.zzahu.submit(new Runnable(){

            @Override
            public void run() {
                zzbc.this.zzcx();
            }
        });
    }

    private void zzcx() {
        try {
            if (this.zzahy == null && this.zzaht != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzaht);
                advertisingIdClient.start();
                this.zzahy = advertisingIdClient;
            }
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzahy = null;
        }
    }

    private void zzcy() {
        if (!zzdr.zzbij.get().booleanValue()) {
            return;
        }
        this.zzcz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcz() {
        Object object = zzaid;
        synchronized (object) {
            if (!this.zzaic) {
                this.zzaib = this.zzahu.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        zzbc.this.zzda();
                        Object object = zzaid;
                        synchronized (object) {
                            zzbc.this.zzaic = false;
                        }
                    }
                });
                this.zzaic = true;
            }
        }
    }

    private void zzda() {
        if (this.zzaii) {
            try {
                PackageInfo packageInfo = this.zzahs.getPackageManager().getPackageInfo(this.zzahs.getPackageName(), 0);
                this.zzaia = zza.zzi((Context)this.zzahs, (String)this.zzahs.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    private void zzdb() {
        this.zzahu.execute(new Runnable(){

            @Override
            public void run() {
                zzdr.initialize(zzbc.this.zzahs);
            }
        });
        zzaij = zzc.zzaql();
        this.zzaig = zzaij.zzbk(this.zzahs) > 0;
        boolean bl = this.zzaii = zzaij.isGooglePlayServicesAvailable(this.zzahs) == 0;
        if (this.zzahs.getApplicationContext() != null) {
            this.zzaif = new GoogleApiClient.Builder(this.zzahs).addApi(com.google.android.gms.clearcut.zza.API).build();
        }
    }

    public AdvertisingIdClient zzdc() {
        if (!this.zzagy) {
            return null;
        }
        if (this.zzahy != null) {
            return this.zzahy;
        }
        if (this.zzahz != null) {
            try {
                this.zzahz.get(2000L, TimeUnit.MILLISECONDS);
                this.zzahz = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzahz.cancel(true);
            }
        }
        return this.zzahy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzdd() {
        Object object = zzaih;
        synchronized (object) {
            if (this.zzaik) {
                return;
            }
            if (this.zzaii && this.zzaif != null) {
                this.zzaif.connect();
                this.zzaik = true;
            } else {
                this.zzaik = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzde() {
        Object object = zzaih;
        synchronized (object) {
            if (this.zzaik && this.zzaif != null) {
                this.zzaif.disconnect();
                this.zzaik = false;
            }
        }
    }

    public int zzaw() {
        int n = Integer.MIN_VALUE;
        zzap zzap2 = this.zzct();
        if (zzap2 != null) {
            n = zzap2.zzaw();
        }
        return n;
    }
}

