/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcq;
import com.google.android.gms.internal.zzct;
import com.google.android.gms.internal.zzcw;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzmd;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzcp
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzako = new Object();
    private final WeakReference<zzko> zzate;
    private WeakReference<ViewTreeObserver> zzatf;
    private final zzcw zzatg;
    protected final zzcn zzath;
    private final Context zzatc;
    private final WindowManager zzati;
    private final PowerManager zzatj;
    private final KeyguardManager zzatk;
    @Nullable
    private zzcq zzatl;
    private boolean zzatm;
    private boolean zzapl = false;
    private boolean zzatn = false;
    private boolean zzato;
    private boolean zzatp;
    private boolean zzatq;
    @Nullable
    BroadcastReceiver zzatr;
    private final HashSet<zzcm> zzats = new HashSet();
    private zzlm zzasn;
    private final HashSet<zzct> zzatt = new HashSet();

    public zzcp(Context context, AdSizeParcel adSizeParcel, zzko zzko2, VersionInfoParcel versionInfoParcel, zzcw zzcw2) {
        this.zzate = new WeakReference<zzko>(zzko2);
        this.zzatg = zzcw2;
        this.zzatf = new WeakReference<Object>(null);
        this.zzato = true;
        this.zzatq = false;
        this.zzasn = new zzlm(200L);
        this.zzath = new zzcn(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzazq, zzko2.zzcsi, zzko2.zzic(), adSizeParcel.zzazt);
        this.zzati = (WindowManager)context.getSystemService("window");
        this.zzatj = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzatk = (KeyguardManager)context.getSystemService("keyguard");
        this.zzatc = context;
    }

    protected void zzj(boolean bl) {
        for (zzcm zzcm2 : this.zzats) {
            zzcm2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzie() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.zzatr != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzatr = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzcp.this.zzk(3);
                }
            };
            this.zzatc.registerReceiver(this.zzatr, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzif() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.zzatr != null) {
                try {
                    this.zzatc.unregisterReceiver(this.zzatr);
                }
                catch (IllegalStateException illegalStateException) {
                    zzkx.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    zzu.zzgq().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                }
                this.zzatr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzako;
        synchronized (object) {
            this.zzik();
            this.zzif();
            this.zzato = false;
            this.zzih();
            this.zzim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzig() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.zzato) {
                this.zzatp = true;
                try {
                    JSONObject jSONObject = this.zzip();
                    this.zza(jSONObject, true);
                }
                catch (JSONException jSONException) {
                    zzkx.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzkx.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzath.zzib());
                zzkx.zzdg((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzk(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzk(int n) {
        Object object = this.zzako;
        synchronized (object) {
            boolean bl;
            if (!this.zzin() || !this.zzato) {
                return;
            }
            View view = this.zzatg.zzir();
            boolean bl2 = view != null && zzu.zzgm().zza(view, this.zzatj, this.zzatk) && view.getGlobalVisibleRect(new Rect(), null);
            boolean bl3 = this.zzatg.zzis();
            if (bl3) {
                this.zzig();
                return;
            }
            boolean bl4 = bl = n == 1;
            if (bl && !this.zzasn.tryAcquire() && bl2 == this.zzatq) {
                return;
            }
            if (!bl2 && !this.zzatq && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject, false);
                this.zzatq = bl2;
            }
            catch (RuntimeException | JSONException throwable) {
                zzkx.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            this.zzij();
            this.zzih();
        }
    }

    protected void zzih() {
        if (this.zzatl != null) {
            this.zzatl.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzii() {
        Object object = this.zzako;
        synchronized (object) {
            return this.zzato;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzij() {
        zzcw zzcw2 = this.zzatg.zzit();
        View view = zzcw2.zzir();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzatf.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzik();
        if (!this.zzatm || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzatm = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzatf = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzath.zzib());
    }

    void zzb(zzmd zzmd2, Map<String, String> map) {
        this.zza(zzmd2.getView(), map);
    }

    void zza(zzct zzct2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzath.zzib());
        zzkx.zzdg((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzct2);
    }

    void zzc(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
        this.zzj(bl);
    }

    protected void zzik() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzatf.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzil() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzath.zzhz()).put("activeViewJSON", (Object)this.zzath.zzia()).put("timestamp", zzu.zzgs().elapsedRealtime()).put("adFormat", (Object)this.zzath.zzhy()).put("hashCode", (Object)this.zzath.zzib()).put("isMraid", this.zzath.zzic()).put("isStopped", this.zzatn).put("isPaused", this.zzapl).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzath.zzid()).put("appMuted", zzu.zzgm().zzft()).put("appVolume", (double)zzu.zzgm().zzfr()).put("deviceVolume", (double)zzu.zzgm().zzah(this.zzatc));
        return jSONObject;
    }

    JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    protected void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = this.zza(jSONObject);
            this.zzb(jSONObject2, bl);
        }
        catch (Throwable throwable) {
            zzkx.zzb((String)"Skipping active view message.", (Throwable)throwable);
        }
    }

    public void zza(zzct zzct2) {
        if (this.zzatt.isEmpty()) {
            this.zzie();
            this.zzk(3);
        }
        this.zzatt.add(zzct2);
        try {
            JSONObject jSONObject = this.zzd(this.zzatg.zzir());
            JSONObject jSONObject2 = this.zza(jSONObject);
            zzct2.zzc(jSONObject2, false);
        }
        catch (JSONException jSONException) {
            zzkx.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
        }
    }

    public void zzb(zzct zzct2) {
        this.zzatt.remove(zzct2);
        zzct2.zziv();
        if (this.zzatt.isEmpty()) {
            this.destroy();
        }
    }

    protected void zzim() {
        ArrayList<zzct> arrayList = new ArrayList<zzct>(this.zzatt);
        for (zzct zzct2 : arrayList) {
            this.zzb(zzct2);
        }
    }

    protected void zzb(JSONObject jSONObject, boolean bl) {
        ArrayList<zzct> arrayList = new ArrayList<zzct>(this.zzatt);
        for (zzct zzct2 : arrayList) {
            zzct2.zzc(jSONObject, bl);
        }
    }

    protected boolean zzin() {
        for (zzct zzct2 : this.zzatt) {
            if (!zzct2.zziu()) continue;
            return true;
        }
        return false;
    }

    protected JSONObject zzio() throws JSONException {
        return this.zzil().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(@Nullable View view) throws JSONException {
        if (view == null) {
            return this.zzio();
        }
        boolean bl = zzu.zzgo().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzkx.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzati.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzati.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzil();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzu.zzgm().zza(view, this.zzatj, this.zzatk));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzatj.isScreenOn();
    }

    protected JSONObject zzip() throws JSONException {
        JSONObject jSONObject = this.zzil();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzk(1);
    }

    public void onGlobalLayout() {
        this.zzk(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzcq zzcq2) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzatl = zzcq2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzako;
        synchronized (object) {
            this.zzatn = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzako;
        synchronized (object) {
            this.zzapl = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzako;
        synchronized (object) {
            this.zzapl = false;
            this.zzk(3);
        }
    }

    public zzcn zziq() {
        return this.zzath;
    }

    public static class zzb
    implements zzcw {
        private zzi zzatw;

        public zzb(zzi zzi2) {
            this.zzatw = zzi2;
        }

        @Override
        public View zzir() {
            return this.zzatw != null ? this.zzatw.zzmy() : null;
        }

        @Override
        public boolean zzis() {
            return this.zzatw == null;
        }

        @Override
        public zzcw zzit() {
            return this;
        }
    }

    public static class zza
    implements zzcw {
        private WeakReference<zzi> zzatv;

        public zza(zzi zzi2) {
            this.zzatv = new WeakReference<zzi>(zzi2);
        }

        @Override
        @Nullable
        public View zzir() {
            zzi zzi2 = (zzi)this.zzatv.get();
            return zzi2 != null ? zzi2.zzmy() : null;
        }

        @Override
        public boolean zzis() {
            return this.zzatv.get() == null;
        }

        @Override
        public zzcw zzit() {
            return new zzb((zzi)this.zzatv.get());
        }
    }

    public static class zzc
    implements zzcw {
        @Nullable
        private final View mView;
        @Nullable
        private final zzko zzatx;

        public zzc(View view, zzko zzko2) {
            this.mView = view;
            this.zzatx = zzko2;
        }

        @Override
        public View zzir() {
            return this.mView;
        }

        @Override
        public boolean zzis() {
            return this.zzatx == null || this.mView == null;
        }

        @Override
        public zzcw zzit() {
            return this;
        }
    }

    public static class zzd
    implements zzcw {
        private final WeakReference<View> zzaty;
        private final WeakReference<zzko> zzatz;

        public zzd(View view, zzko zzko2) {
            this.zzaty = new WeakReference<View>(view);
            this.zzatz = new WeakReference<zzko>(zzko2);
        }

        @Override
        public View zzir() {
            return (View)this.zzaty.get();
        }

        @Override
        public boolean zzis() {
            return this.zzaty.get() == null || this.zzatz.get() == null;
        }

        @Override
        public zzcw zzit() {
            return new zzc((View)this.zzaty.get(), (zzko)this.zzatz.get());
        }
    }
}

