/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzlb;

@zzji
public class zzho
implements MediationInterstitialAdapter {
    private Activity zzbxt;
    private zzef zzbxu;
    private MediationInterstitialListener zzbxv;
    private Uri mUri;

    public static boolean zzo(Context context) {
        return zzef.zzn(context);
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzbxv = mediationInterstitialListener;
        if (this.zzbxv == null) {
            zzb.zzdi((String)"Listener not set for mediation. Returning.");
            return;
        }
        if (!(context instanceof Activity)) {
            zzb.zzdi((String)"AdMobCustomTabs can only work with Activity context. Bailing out.");
            this.zzbxv.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        if (!zzho.zzo(context)) {
            zzb.zzdi((String)"Default browser does not support custom tabs. Bailing out.");
            this.zzbxv.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String string2 = bundle.getString("tab_url");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzb.zzdi((String)"The tab_url retrieved from mediation metadata is empty. Bailing out.");
            this.zzbxv.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.zzbxt = (Activity)context;
        this.mUri = Uri.parse((String)string2);
        this.zzbxu = new zzef();
        zzef.zza zza2 = new zzef.zza(){

            @Override
            public void zzmh() {
                zzb.zzdg((String)"Hinting CustomTabsService for the load of the new url.");
            }

            @Override
            public void zzmi() {
                zzb.zzdg((String)"Disconnecting from CustomTabs service.");
            }
        };
        this.zzbxu.zza(zza2);
        this.zzbxu.zze(this.zzbxt);
        this.zzbxv.onAdLoaded((MediationInterstitialAdapter)this);
    }

    public void showInterstitial() {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(this.zzbxu.zzmf()).build();
        customTabsIntent.intent.setData(this.mUri);
        AdLauncherIntentInfoParcel adLauncherIntentInfoParcel = new AdLauncherIntentInfoParcel(customTabsIntent.intent);
        final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(adLauncherIntentInfoParcel, null, new zzg(){

            @Override
            public void zzeq() {
                zzb.zzdg((String)"AdMobCustomTabsAdapter overlay is closed.");
                zzho.this.zzbxv.onAdClosed((MediationInterstitialAdapter)zzho.this);
                zzho.this.zzbxu.zzd(zzho.this.zzbxt);
            }

            @Override
            public void onPause() {
                zzb.zzdg((String)"AdMobCustomTabsAdapter overlay is paused.");
            }

            @Override
            public void onResume() {
                zzb.zzdg((String)"AdMobCustomTabsAdapter overlay is resumed.");
            }

            @Override
            public void zzer() {
                zzb.zzdg((String)"Opening AdMobCustomTabsAdapter overlay.");
                zzho.this.zzbxv.onAdOpened((MediationInterstitialAdapter)zzho.this);
            }
        }, null, new VersionInfoParcel(0, 0, false));
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                zzu.zzgk().zza((Context)zzho.this.zzbxt, adOverlayInfoParcel);
            }
        });
        zzu.zzgq().zzah(false);
    }

    public void onDestroy() {
        zzb.zzdg((String)"Destroying AdMobCustomTabsAdapter adapter.");
        try {
            this.zzbxu.zzd(this.zzbxt);
        }
        catch (Exception exception) {
            zzb.zzb((String)"Exception while unbinding from CustomTabsService.", (Throwable)exception);
        }
    }

    public void onPause() {
        zzb.zzdg((String)"Pausing AdMobCustomTabsAdapter adapter.");
    }

    public void onResume() {
        zzb.zzdg((String)"Resuming AdMobCustomTabsAdapter adapter.");
    }
}

