/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzji;
import java.util.Locale;

@zzji
public final class zzjr {
    public final int zzcps;
    public final boolean zzcpt;
    public final boolean zzcpu;
    public final String zzcpv;
    public final String zzcpw;
    public final boolean zzcpx;
    public final boolean zzcpy;
    public final boolean zzcpz;
    public final boolean zzcqa;
    public final String zzcqb;
    public final String zzcqc;
    public final int zzcqd;
    public final int zzcqe;
    public final int zzcqf;
    public final int zzcqg;
    public final int zzcqh;
    public final int zzcqi;
    public final float zzavd;
    public final int zzcke;
    public final int zzckf;
    public final double zzcqj;
    public final boolean zzcqk;
    public final boolean zzcql;
    public final int zzcqm;
    public final String zzcqn;
    public final boolean zzcqo;

    zzjr(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6, boolean bl9) {
        this.zzcps = n;
        this.zzcpt = bl;
        this.zzcpu = bl2;
        this.zzcpv = string2;
        this.zzcpw = string3;
        this.zzcpx = bl3;
        this.zzcpy = bl4;
        this.zzcpz = bl5;
        this.zzcqa = bl6;
        this.zzcqb = string4;
        this.zzcqc = string5;
        this.zzcqd = n2;
        this.zzcqe = n3;
        this.zzcqf = n4;
        this.zzcqg = n5;
        this.zzcqh = n6;
        this.zzcqi = n7;
        this.zzavd = f;
        this.zzcke = n8;
        this.zzckf = n9;
        this.zzcqj = d;
        this.zzcqk = bl7;
        this.zzcql = bl8;
        this.zzcqm = n10;
        this.zzcqn = string6;
        this.zzcqo = bl9;
    }

    public static final class zza {
        private int zzcps;
        private boolean zzcpz;
        private boolean zzcqa;
        private int zzcqd;
        private int zzcqh;
        private int zzcqi;
        private String zzcpv;
        private int zzcqe;
        private int zzcqf;
        private int zzcqg;
        private boolean zzcql;
        private int zzcqm;
        private double zzcqj;
        private boolean zzcqk;
        private String zzcqn;
        private boolean zzcpt;
        private boolean zzcpu;
        private String zzcpw;
        private boolean zzcpx;
        private boolean zzcpy;
        private String zzcqb;
        private String zzcqc;
        private float zzavd;
        private int zzcke;
        private int zzckf;
        private boolean zzcqo;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzs(context);
            this.zza(context, packageManager);
            this.zzt(context);
            Locale locale = Locale.getDefault();
            this.zzcpt = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzcpu = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzcpw = locale.getCountry();
            this.zzcpx = zzm.zzkr().zzwp();
            this.zzcpy = zzi.zzcj((Context)context);
            this.zzcqb = locale.getLanguage();
            this.zzcqc = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzavd = displayMetrics.density;
            this.zzcke = displayMetrics.widthPixels;
            this.zzckf = displayMetrics.heightPixels;
        }

        public zza(Context context, zzjr zzjr2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzs(context);
            this.zza(context, packageManager);
            this.zzt(context);
            this.zzu(context);
            this.zzcpt = zzjr2.zzcpt;
            this.zzcpu = zzjr2.zzcpu;
            this.zzcpw = zzjr2.zzcpw;
            this.zzcpx = zzjr2.zzcpx;
            this.zzcpy = zzjr2.zzcpy;
            this.zzcqb = zzjr2.zzcqb;
            this.zzcqc = zzjr2.zzcqc;
            this.zzavd = zzjr2.zzavd;
            this.zzcke = zzjr2.zzcke;
            this.zzckf = zzjr2.zzckf;
        }

        private void zzs(Context context) {
            AudioManager audioManager = zzu.zzgm().zzag(context);
            if (audioManager != null) {
                try {
                    this.zzcps = audioManager.getMode();
                    this.zzcpz = audioManager.isMusicActive();
                    this.zzcqa = audioManager.isSpeakerphoneOn();
                    this.zzcqd = audioManager.getStreamVolume(3);
                    this.zzcqh = audioManager.getRingerMode();
                    this.zzcqi = audioManager.getStreamVolume(2);
                    return;
                }
                catch (Throwable throwable) {
                    zzu.zzgq().zza(throwable, "DeviceInfo.gatherAudioInfo");
                }
            }
            this.zzcps = -2;
            this.zzcpz = false;
            this.zzcqa = false;
            this.zzcqd = 0;
            this.zzcqh = 0;
            this.zzcqi = 0;
        }

        @TargetApi(value=16)
        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzcpv = telephonyManager.getNetworkOperator();
            this.zzcqf = telephonyManager.getNetworkType();
            this.zzcqg = telephonyManager.getPhoneType();
            this.zzcqe = -2;
            this.zzcql = false;
            this.zzcqm = -1;
            if (zzu.zzgm().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzcqe = networkInfo.getType();
                    this.zzcqm = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzcqe = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzcql = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzt(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzcqj = (float)n2 / (float)n3;
                this.zzcqk = n == 2 || n == 5;
            } else {
                this.zzcqj = -1.0;
                this.zzcqk = false;
            }
        }

        private void zzu(Context context) {
            this.zzcqn = Build.FINGERPRINT;
            this.zzcqo = zzef.zzn(context);
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                String string2;
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                if (packageInfo != null) {
                    int n = packageInfo.versionCode;
                    String string3 = String.valueOf(activityInfo.packageName);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append(n).append(".").append(string3).toString();
                } else {
                    string2 = null;
                }
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zzjr zztr() {
            return new zzjr(this.zzcps, this.zzcpt, this.zzcpu, this.zzcpv, this.zzcpw, this.zzcpx, this.zzcpy, this.zzcpz, this.zzcqa, this.zzcqb, this.zzcqc, this.zzcqd, this.zzcqe, this.zzcqf, this.zzcqg, this.zzcqh, this.zzcqi, this.zzavd, this.zzcke, this.zzckf, this.zzcqj, this.zzcqk, this.zzcql, this.zzcqm, this.zzcqn, this.zzcqo);
        }
    }
}

