/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.internal.zztd;
import java.util.Collections;
import java.util.List;

public class zzrz
extends zzru {
    private final zza zzadk;
    private zzsu zzadl;
    private final zzsl zzadm;
    private zztd zzadn;

    protected zzrz(zzrw zzrw2) {
        super(zzrw2);
        this.zzadn = new zztd(zzrw2.zznq());
        this.zzadk = new zza();
        this.zzadm = new zzsl(zzrw2){

            @Override
            public void run() {
                zzrz.this.zznO();
            }
        };
    }

    @Override
    protected void zzmr() {
    }

    public boolean isConnected() {
        this.zzmq();
        this.zznA();
        return this.zzadl != null;
    }

    public boolean zzb(zzst zzst2) {
        zzac.zzw((Object)zzst2);
        this.zzmq();
        this.zznA();
        zzsu zzsu2 = this.zzadl;
        if (zzsu2 == null) {
            return false;
        }
        String string = zzst2.zzps() ? this.zzns().zzoJ() : this.zzns().zzoK();
        List<zzsf> list = Collections.emptyList();
        try {
            zzsu2.zza(zzst2.zzfz(), zzst2.zzpq(), string, list);
            this.zznN();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbO("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zznM() {
        this.zzmq();
        this.zznA();
        zzsu zzsu2 = this.zzadl;
        if (zzsu2 == null) {
            return false;
        }
        try {
            zzsu2.zznj();
            this.zznN();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbO("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zznN() {
        this.zzadn.start();
        this.zzadm.zzx(this.zzns().zzoQ());
    }

    public boolean connect() {
        this.zzmq();
        this.zznA();
        if (this.zzadl != null) {
            return true;
        }
        zzsu zzsu2 = this.zzadk.zznP();
        if (zzsu2 != null) {
            this.zzadl = zzsu2;
            this.zznN();
            return true;
        }
        return false;
    }

    private void zza(zzsu zzsu2) {
        this.zzmq();
        this.zzadl = zzsu2;
        this.zznN();
        this.zzlZ().onServiceConnected();
    }

    public void disconnect() {
        this.zzmq();
        this.zznA();
        try {
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyc();
            zza2.zza(this.getContext(), (ServiceConnection)this.zzadk);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzadl != null) {
            this.zzadl = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName componentName) {
        this.zzmq();
        if (this.zzadl != null) {
            this.zzadl = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.onDisconnect();
        }
    }

    private void zznO() {
        this.zzmq();
        if (!this.isConnected()) {
            return;
        }
        this.zzbO("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzlZ().zznm();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzsu zzadp;
        private volatile boolean zzadq;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzsu zznP() {
            zzrz.this.zzmq();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzrz.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyc();
            zza zza3 = this;
            synchronized (zza3) {
                this.zzadp = null;
                this.zzadq = true;
                boolean bl = zza2.zza(context, intent, (ServiceConnection)zzrz.this.zzadk, 129);
                zzrz.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzadq = false;
                    return null;
                }
                try {
                    long l = zzrz.this.zzns().zzoR();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzrz.this.zzbR("Wait for service connect was interrupted");
                }
                this.zzadq = false;
                zzsu zzsu2 = this.zzadp;
                this.zzadp = null;
                if (zzsu2 == null) {
                    zzrz.this.zzbS("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzsu2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzac.zzdn((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (iBinder == null) {
                        zzrz.this.zzbS("Service connected with null binder");
                        return;
                    }
                    zzsu zzsu2 = null;
                    try {
                        object = iBinder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzsu2 = zzsu.zza.zzam(iBinder);
                            zzrz.this.zzbO("Bound to IAnalyticsService interface");
                        } else {
                            zzrz.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzrz.this.zzbS("Service connect failed to get IAnalyticsService");
                    }
                    if (zzsu2 == null) {
                        try {
                            com.google.android.gms.common.stats.zza.zzyc().zza(zzrz.this.getContext(), (ServiceConnection)zzrz.this.zzadk);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzadq) {
                        zzrz.this.zzbR("onServiceConnected received after the timeout limit");
                        object = zzsu2;
                        zzrz.this.zznt().zzg(new Runnable((zzsu)object){
                            final /* synthetic */ zzsu zzadr;
                            {
                                this.zzadr = zzsu2;
                            }

                            @Override
                            public void run() {
                                if (!zzrz.this.isConnected()) {
                                    zzrz.this.zzbP("Connected to service after a timeout");
                                    zzrz.this.zza(this.zzadr);
                                }
                            }
                        });
                    } else {
                        this.zzadp = zzsu2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName componentName) {
            zzac.zzdn((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzrz.this.zznt().zzg(new Runnable(){

                @Override
                public void run() {
                    zzrz.this.onServiceDisconnected(componentName);
                }
            });
        }
    }
}

