/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzacx;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzrw;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.internal.zzry;
import com.google.android.gms.internal.zzrz;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zzsn;
import com.google.android.gms.internal.zzso;
import com.google.android.gms.internal.zzsq;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsy;
import com.google.android.gms.internal.zzsz;
import com.google.android.gms.internal.zzta;
import com.google.android.gms.internal.zztb;
import com.google.android.gms.internal.zztc;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.internal.zztg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzsc
extends zzru {
    private boolean mStarted;
    private final zzsa zzadz;
    private final zzsz zzadA;
    private final zzsy zzadB;
    private final zzrz zzadC;
    private long zzadD;
    private final zzsl zzadE;
    private final zzsl zzadF;
    private final zztd zzadG;
    private long zzadH;
    private boolean zzadI;

    protected zzsc(zzrw zzrw2, zzrx zzrx2) {
        super(zzrw2);
        zzac.zzw((Object)zzrx2);
        this.zzadD = Long.MIN_VALUE;
        this.zzadB = zzrx2.zzk(zzrw2);
        this.zzadz = zzrx2.zzm(zzrw2);
        this.zzadA = zzrx2.zzn(zzrw2);
        this.zzadC = zzrx2.zzo(zzrw2);
        this.zzadG = new zztd(this.zznq());
        this.zzadE = new zzsl(zzrw2){

            @Override
            public void run() {
                zzsc.this.zzoa();
            }
        };
        this.zzadF = new zzsl(zzrw2){

            @Override
            public void run() {
                zzsc.this.zzob();
            }
        };
    }

    @Override
    protected void zzmr() {
        this.zzadz.initialize();
        this.zzadA.initialize();
        this.zzadC.initialize();
    }

    void start() {
        this.zznA();
        zzac.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zznt().zzg(new Runnable(){

            @Override
            public void run() {
                zzsc.this.zznZ();
            }
        });
    }

    private void zznY() {
        boolean bl;
        this.zzmq();
        zzrw zzrw2 = this.zznp();
        Context context = zzrw2.getContext();
        boolean bl2 = zztb.zzT(context);
        if (!bl2) {
            this.zzbR("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = zztc.zzU(context);
            if (!bl) {
                this.zzbS("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzT(context);
        if (!bl) {
            this.zzbR("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzU(context);
            if (!bl3) {
                this.zzbR("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzbV(String string) {
        int n = zzacx.zzaQ((Context)this.getContext()).checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zznZ() {
        this.zznA();
        this.zznY();
        this.zznv().zzpE();
        if (!this.zzbV("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbS("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzoo();
        }
        if (!this.zzbV("android.permission.INTERNET")) {
            this.zzbS("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzoo();
        }
        if (zztc.zzU(this.getContext())) {
            this.zzbO("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzbR("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzadI && !this.zzadz.isEmpty()) {
            this.zzoc();
        }
        this.zzog();
    }

    private void zzoa() {
        this.zzb(new zzso(){

            @Override
            public void zzf(Throwable throwable) {
                zzsc.this.zzog();
            }
        });
    }

    void zzno() {
        this.zzmq();
        this.zzadH = this.zznq().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzmq();
        this.zzod();
    }

    public void zznm() {
        zzh.zzmq();
        this.zznA();
        this.zzbO("Service disconnected");
    }

    public void zzV(boolean bl) {
        this.zzog();
    }

    private void zzob() {
        try {
            this.zzadz.zznS();
            this.zzog();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzadF.zzx(86400000L);
    }

    protected void zzc(zzry zzry2) {
        this.zzmq();
        this.zzb("Sending first hit to property", zzry2.zznJ());
        if (this.zznv().zzpF().zzz(this.zzns().zzoY())) {
            return;
        }
        String string = this.zznv().zzpI();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzrf zzrf2 = zztg.zza(this.zznr(), string);
        this.zzb("Found relevant installation campaign", zzrf2);
        this.zza(zzry2, zzrf2);
    }

    public void zzw(long l) {
        zzh.zzmq();
        this.zznA();
        if (l < 0L) {
            l = 0L;
        }
        this.zzadD = l;
        this.zzog();
    }

    protected void zzoc() {
        if (this.zzadI) {
            return;
        }
        if (!this.zzns().zzox()) {
            return;
        }
        if (this.zzadC.isConnected()) {
            return;
        }
        long l = this.zzns().zzoS();
        if (this.zzadG.zzz(l)) {
            this.zzadG.start();
            this.zzbO("Connecting to service");
            if (this.zzadC.connect()) {
                this.zzbO("Connected to service");
                this.zzadG.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzry zzry2, boolean bl) {
        long l;
        zzac.zzw((Object)zzry2);
        this.zznA();
        this.zzmq();
        try {
            this.zzadz.beginTransaction();
            this.zzadz.zza(zzry2.zznI(), zzry2.zzlX());
            l = this.zzadz.zza(zzry2.zznI(), zzry2.zzlX(), zzry2.zznJ());
            if (!bl) {
                zzry2.zzr(l);
            } else {
                zzry2.zzr(l + 1L);
            }
            this.zzadz.zzb(zzry2);
            this.zzadz.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzadz.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzst zzst2) {
        zzac.zzw((Object)zzst2);
        zzh.zzmq();
        this.zznA();
        if (this.zzadI) {
            this.zzbP("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzst2);
        }
        zzst2 = this.zzf(zzst2);
        this.zzoc();
        if (this.zzadC.zzb(zzst2)) {
            this.zzbP("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzadz.zzc(zzst2);
            this.zzog();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zznr().zza(zzst2, "deliver: failed to insert hit to database");
        }
    }

    public void zznj() {
        zzh.zzmq();
        this.zznA();
        this.zzbO("Delete all hits from local store");
        try {
            this.zzadz.zznQ();
            this.zzadz.zznR();
            this.zzog();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzoc();
        if (this.zzadC.zznM()) {
            this.zzbO("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzst zzf(zzst zzst2) {
        if (!TextUtils.isEmpty((CharSequence)zzst2.zzpu())) {
            return zzst2;
        }
        zzta.zza zza2 = this.zznv().zzpJ();
        Pair<String, Long> pair = zza2.zzpM();
        if (pair == null) {
            return zzst2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        Object object = String.valueOf(l);
        String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
        object = new HashMap<String, String>(zzst2.zzfz());
        object.put("_m", string2);
        return zzst.zza(this, zzst2, (Map<String, String>)object);
    }

    public void zzod() {
        zzh.zzmq();
        this.zznA();
        if (!this.zzns().zzox()) {
            this.zzbR("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzadC.isConnected()) {
            this.zzbO("Service not connected");
            return;
        }
        if (this.zzadz.isEmpty()) {
            return;
        }
        this.zzbO("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzst> list;
            try {
                list = this.zzadz.zzt(this.zzns().zzoG());
                if (list.isEmpty()) {
                    this.zzog();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzok();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzst zzst2 = list.get(0);
                if (!this.zzadC.zzb(zzst2)) {
                    this.zzog();
                    return;
                }
                list.remove(zzst2);
                try {
                    this.zzadz.zzu(zzst2.zzpp());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzok();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzoe() {
        boolean bl;
        zzh.zzmq();
        this.zznA();
        this.zzbO("Dispatching a batch of local hits");
        boolean bl2 = !this.zzadC.isConnected();
        boolean bl3 = bl = !this.zzadA.zzpA();
        if (bl2 && bl) {
            this.zzbO("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zzns().zzoG(), this.zzns().zzoH());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzst> list;
                block38: {
                    this.zzadz.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzadz.zzt(l);
                        if (!list.isEmpty()) break block38;
                        this.zzbO("Store is empty, nothing to dispatch");
                        this.zzok();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzok();
                        try {
                            this.zzadz.setTransactionSuccessful();
                            this.zzadz.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzok();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzst)object).zzpp() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzok();
                    return false;
                }
                if (this.zzadC.isConnected()) {
                    this.zzbO("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzadC.zzb((zzst)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzst)object2).zzpp());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzadz.zzu(((zzst)object2).zzpp());
                            arrayList.add(((zzst)object2).zzpp());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzok();
                            try {
                                this.zzadz.setTransactionSuccessful();
                                this.zzadz.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzok();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzadA.zzpA()) {
                    object2 = this.zzadA.zzt(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzadz.zzr((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzok();
                        try {
                            this.zzadz.setTransactionSuccessful();
                            this.zzadz.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzok();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzadz.setTransactionSuccessful();
                    this.zzadz.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzok();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzso zzso2) {
        this.zza(zzso2, this.zzadH);
    }

    public void zza(zzso zzso2, long l) {
        block5: {
            zzh.zzmq();
            this.zznA();
            long l2 = -1L;
            long l3 = this.zznv().zzpG();
            if (l3 != 0L) {
                l2 = Math.abs(this.zznq().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            this.zzoc();
            try {
                this.zzoe();
                this.zznv().zzpH();
                this.zzog();
                if (zzso2 != null) {
                    zzso2.zzf(null);
                }
                if (this.zzadH != l) {
                    this.zzadB.zzpz();
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zznv().zzpH();
                this.zzog();
                if (zzso2 == null) break block5;
                zzso2.zzf(throwable);
            }
        }
    }

    public void zzof() {
        zzh.zzmq();
        this.zznA();
        this.zzbP("Sync dispatching local hits");
        long l = this.zzadH;
        this.zzoc();
        try {
            this.zzoe();
            this.zznv().zzpH();
            this.zzog();
            if (this.zzadH != l) {
                this.zzadB.zzpz();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzog();
        }
    }

    public long zznT() {
        zzh.zzmq();
        this.zznA();
        try {
            return this.zzadz.zznT();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzog() {
        boolean bl;
        this.zznp().zzmq();
        this.zznA();
        if (!this.zzoh()) {
            this.zzadB.unregister();
            this.zzok();
            return;
        }
        if (this.zzadz.isEmpty()) {
            this.zzadB.unregister();
            this.zzok();
            return;
        }
        if (!zzsq.zzaeR.get().booleanValue()) {
            this.zzadB.zzpx();
            bl = this.zzadB.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzoj();
        } else {
            this.zzok();
            this.zzoi();
        }
    }

    private boolean zzoh() {
        if (this.zzadI) {
            return false;
        }
        return this.zzon() > 0L;
    }

    private void zzoi() {
        long l;
        long l2;
        long l3;
        zzsn zzsn2 = this.zznu();
        if (!zzsn2.zzpd()) {
            return;
        }
        if (!zzsn2.zzcv() && (l3 = this.zznT()) != 0L && (l2 = Math.abs((l = this.zznq().currentTimeMillis()) - l3)) <= this.zzns().zzoF()) {
            long l4 = this.zzns().zzoE();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzsn2.schedule();
        }
    }

    private void zzoj() {
        long l;
        long l2;
        this.zzoi();
        long l3 = this.zzon();
        long l4 = this.zznv().zzpG();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zznq().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zzns().zzoC(), l3)) : Math.min(this.zzns().zzoC(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzadE.zzcv()) {
            l = Math.max(1L, l5 + this.zzadE.zzpa());
            this.zzadE.zzy(l);
        } else {
            this.zzadE.zzx(l5);
        }
    }

    private void zzok() {
        this.zzol();
        this.zzom();
    }

    private void zzol() {
        if (this.zzadE.zzcv()) {
            this.zzbO("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzadE.cancel();
    }

    private void zzom() {
        zzsn zzsn2 = this.zznu();
        if (zzsn2.zzcv()) {
            zzsn2.cancel();
        }
    }

    public long zzon() {
        if (this.zzadD != Long.MIN_VALUE) {
            return this.zzadD;
        }
        long l = this.zzns().zzoD();
        if (this.zzma().zzpk()) {
            l = (long)this.zzma().zzqb() * 1000L;
        }
        return l;
    }

    public void zzbW(String string) {
        zzac.zzdv((String)string);
        this.zzmq();
        zzrf zzrf2 = zztg.zza(this.zznr(), string);
        if (zzrf2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zznv().zzpI();
        if (string.equals(string2)) {
            this.zzbR("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zznv().zzca(string);
        if (this.zznv().zzpF().zzz(this.zzns().zzoY())) {
            this.zzd("Campaign received too late, ignoring", zzrf2);
            return;
        }
        this.zzb("Received installation campaign", zzrf2);
        List<zzry> list = this.zzadz.zzv(0L);
        for (zzry zzry2 : list) {
            this.zza(zzry2, zzrf2);
        }
    }

    private void zza(zzry zzry2, zzrf zzrf2) {
        zzac.zzw((Object)zzry2);
        zzac.zzw((Object)zzrf2);
        zza zza2 = new zza(this.zznp());
        zza2.zzbn(zzry2.zznJ());
        zza2.enableAdvertisingIdCollection(zzry2.zznK());
        zze zze2 = zza2.zzlN();
        zzrn zzrn2 = zze2.zzb(zzrn.class);
        zzrn2.zzbD("data");
        zzrn2.zzS(true);
        zze2.zza(zzrf2);
        zzri zzri2 = zze2.zzb(zzri.class);
        zzre zzre2 = zze2.zzb(zzre.class);
        for (Map.Entry<String, String> entry : zzry2.zzfz().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzre2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzre2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzre2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzre2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzrn2.setUserId(string2);
                continue;
            }
            zzri2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzry2.zznJ(), zzrf2);
        zze2.zzp(this.zznv().zzpE());
        zze2.zzmf();
    }

    public void zzoo() {
        this.zznA();
        this.zzmq();
        this.zzadI = true;
        this.zzadC.disconnect();
        this.zzog();
    }
}

