/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzru;
import com.google.android.gms.internal.zzrw;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzse
extends zzru {
    private volatile String zzacg;
    private Future<String> zzadR;

    protected zzse(zzrw zzrw2) {
        super(zzrw2);
    }

    @Override
    protected void zzmr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzop() {
        this.zznA();
        zzse zzse2 = this;
        synchronized (zzse2) {
            if (this.zzacg == null) {
                this.zzadR = this.zznt().zzc(new Callable<String>(){

                    public String zzou() throws Exception {
                        return zzse.this.zzor();
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.zzou();
                    }
                });
            }
            if (this.zzadR != null) {
                try {
                    this.zzacg = this.zzadR.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzacg = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzacg = "0";
                }
                if (this.zzacg == null) {
                    this.zzacg = "0";
                }
                this.zza("Loaded clientId", this.zzacg);
                this.zzadR = null;
            }
            return this.zzacg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzoq() {
        zzse zzse2 = this;
        synchronized (zzse2) {
            this.zzacg = null;
            this.zzadR = this.zznt().zzc(new Callable<String>(){

                public String zzou() throws Exception {
                    return zzse.this.zzos();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzou();
                }
            });
        }
        return this.zzop();
    }

    String zzor() {
        String string = this.zzY(this.zznt().getContext());
        if (string == null) {
            string = this.zzos();
        }
        return string;
    }

    private String zzos() {
        String string = this.zzot();
        try {
            if (!this.zzq(this.zznt().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    protected String zzot() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String zzY(Context context) {
        zzac.zzdo((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzbR("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzbR("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzq(Context context, String string) {
        zzac.zzdv((String)string);
        zzac.zzdo((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }
}

