/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zzsr;
import com.google.android.gms.internal.zzsz;
import com.google.android.gms.internal.zzta;
import com.google.android.gms.internal.zztj;
import java.util.Collections;
import java.util.List;

public class zzsf
extends zzsa {
    private final zza zzael;
    private zzta zzaem;
    private final zzsr zzaen;
    private zztj zzaeo;

    protected zzsf(zzsc zzsc2) {
        super(zzsc2);
        this.zzaeo = new zztj(zzsc2.zznR());
        this.zzael = new zza();
        this.zzaen = new zzsr(zzsc2){

            @Override
            public void run() {
                zzsf.this.zzop();
            }
        };
    }

    @Override
    protected void zzmS() {
    }

    public boolean isConnected() {
        this.zzmR();
        this.zzob();
        return this.zzaem != null;
    }

    public boolean zzb(zzsz zzsz2) {
        zzac.zzw((Object)zzsz2);
        this.zzmR();
        this.zzob();
        zzta zzta2 = this.zzaem;
        if (zzta2 == null) {
            return false;
        }
        String string = zzsz2.zzpS() ? this.zznT().zzpj() : this.zznT().zzpk();
        List<zzsl> list = Collections.emptyList();
        try {
            zzta2.zza(zzsz2.zzfE(), zzsz2.zzpQ(), string, list);
            this.zzoo();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbP("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zzon() {
        this.zzmR();
        this.zzob();
        zzta zzta2 = this.zzaem;
        if (zzta2 == null) {
            return false;
        }
        try {
            zzta2.zznK();
            this.zzoo();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzbP("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zzoo() {
        this.zzaeo.start();
        this.zzaen.zzy(this.zznT().zzpq());
    }

    public boolean connect() {
        this.zzmR();
        this.zzob();
        if (this.zzaem != null) {
            return true;
        }
        zzta zzta2 = this.zzael.zzoq();
        if (zzta2 != null) {
            this.zzaem = zzta2;
            this.zzoo();
            return true;
        }
        return false;
    }

    private void zza(zzta zzta2) {
        this.zzmR();
        this.zzaem = zzta2;
        this.zzoo();
        this.zzmA().onServiceConnected();
    }

    public void disconnect() {
        this.zzmR();
        this.zzob();
        try {
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyJ();
            zza2.zza(this.getContext(), (ServiceConnection)this.zzael);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (this.zzaem != null) {
            this.zzaem = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName componentName) {
        this.zzmR();
        if (this.zzaem != null) {
            this.zzaem = null;
            this.zza("Disconnected from device AnalyticsService", componentName);
            this.onDisconnect();
        }
    }

    private void zzop() {
        this.zzmR();
        if (!this.isConnected()) {
            return;
        }
        this.zzbP("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzmA().zznN();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzta zzaeq;
        private volatile boolean zzaer;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzta zzoq() {
            zzsf.this.zzmR();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzsf.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyJ();
            zza zza3 = this;
            synchronized (zza3) {
                this.zzaeq = null;
                this.zzaer = true;
                boolean bl = zza2.zza(context, intent, (ServiceConnection)zzsf.this.zzael, 129);
                zzsf.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzaer = false;
                    return null;
                }
                try {
                    long l = zzsf.this.zznT().zzpr();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzsf.this.zzbS("Wait for service connect was interrupted");
                }
                this.zzaer = false;
                zzta zzta2 = this.zzaeq;
                this.zzaeq = null;
                if (zzta2 == null) {
                    zzsf.this.zzbT("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzta2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzac.zzdj((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (iBinder == null) {
                        zzsf.this.zzbT("Service connected with null binder");
                        return;
                    }
                    zzta zzta2 = null;
                    try {
                        object = iBinder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzta2 = zzta.zza.zzam(iBinder);
                            zzsf.this.zzbP("Bound to IAnalyticsService interface");
                        } else {
                            zzsf.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzsf.this.zzbT("Service connect failed to get IAnalyticsService");
                    }
                    if (zzta2 == null) {
                        try {
                            com.google.android.gms.common.stats.zza.zzyJ().zza(zzsf.this.getContext(), (ServiceConnection)zzsf.this.zzael);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzaer) {
                        zzsf.this.zzbS("onServiceConnected received after the timeout limit");
                        object = zzta2;
                        zzsf.this.zznU().zzg(new Runnable((zzta)object){
                            final /* synthetic */ zzta zzaes;
                            {
                                this.zzaes = zzta2;
                            }

                            @Override
                            public void run() {
                                if (!zzsf.this.isConnected()) {
                                    zzsf.this.zzbQ("Connected to service after a timeout");
                                    zzsf.this.zza(this.zzaes);
                                }
                            }
                        });
                    } else {
                        this.zzaeq = zzta2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName componentName) {
            zzac.zzdj((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzsf.this.zznU().zzg(new Runnable(){

                @Override
                public void run() {
                    zzsf.this.onServiceDisconnected(componentName);
                }
            });
        }
    }
}

