/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsj;
import com.google.android.gms.internal.zzsm;
import com.google.android.gms.internal.zzsz;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zztm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

class zztf
extends zzsa {
    private final String zzIA = zztf.zza("GoogleAnalytics", zzsb.VERSION, Build.VERSION.RELEASE, zztm.zza(Locale.getDefault()), Build.MODEL, Build.ID);
    private final zztj zzagy;
    private static final byte[] zzagz = "\n".getBytes();

    zztf(zzsc zzsc2) {
        super(zzsc2);
        this.zzagy = new zztj(zzsc2.zznR());
    }

    @Override
    protected void zzmS() {
        this.zza("Network initialized. User agent", this.zzIA);
    }

    private static String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    public boolean zzqa() {
        this.zzmR();
        this.zzob();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {}
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzbP("No network connectivity");
            return false;
        }
        return true;
    }

    public List<Long> zzt(List<zzsz> list) {
        boolean bl;
        boolean bl2;
        this.zzmR();
        this.zzob();
        zzac.zzw(list);
        if (this.zznT().zzpp().isEmpty() || !this.zzagy.zzA(this.zznT().zzpi() * 1000L)) {
            bl2 = false;
            bl = false;
        } else {
            bl2 = this.zznT().zzpn() != zzsj.zzaeL;
            boolean bl3 = bl = this.zznT().zzpo() == zzsm.zzaeW;
        }
        if (bl2) {
            return this.zza(list, bl);
        }
        return this.zzu(list);
    }

    List<Long> zzu(List<zzsz> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
        for (zzsz zzsz2 : list) {
            if (!this.zzg(zzsz2)) break;
            arrayList.add(zzsz2.zzpP());
            if (arrayList.size() < this.zznT().zzpg()) continue;
            break;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL) {
        zzac.zzw((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.connect();
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzmA().zznP();
            }
            this.zzb("GET status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            return 0;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zza(URL uRL, byte[] byArray) {
        zzac.zzw((Object)uRL);
        zzac.zzw((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (this.zzkI()) {
            this.zza("Post payload\n", new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzmA().zznP();
            }
            this.zzb("POST status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static byte[] zzk(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int zzb(URL uRL, byte[] byArray) {
        zzac.zzw((Object)uRL);
        zzac.zzw((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            byte[] byArray2 = zztf.zzk(byArray);
            this.zza("POST compressed size, ratio %, url", byArray2.length, 100L * (long)byArray2.length / (long)byArray.length, uRL);
            if (byArray2.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray2.length, byArray.length);
            }
            if (this.zzkI()) {
                String string = String.valueOf(new String(byArray));
                this.zza("Post payload", string.length() != 0 ? "\n".concat(string) : new String("\n"));
            }
            httpURLConnection = this.zzc(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray2.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray2);
            outputStream.close();
            outputStream = null;
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzmA().zznP();
            }
            this.zzb("POST status", n);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http connection input stream", iOException);
                }
            }
        }
    }

    HttpURLConnection zzc(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(this.zznT().zzpw());
        httpURLConnection.setReadTimeout(this.zznT().zzpx());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zzIA);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private boolean zzg(zzsz zzsz2) {
        zzac.zzw((Object)zzsz2);
        String string = this.zza(zzsz2, !zzsz2.zzpS());
        if (string == null) {
            this.zznS().zza(zzsz2, "Error formatting hit for upload");
            return true;
        }
        if (string.length() <= this.zznT().zzoY()) {
            URL uRL = this.zzb(zzsz2, string);
            if (uRL == null) {
                this.zzbT("Failed to build collect GET endpoint url");
                return false;
            }
            return this.zzb(uRL) == 200;
        }
        string = this.zza(zzsz2, false);
        if (string == null) {
            this.zznS().zza(zzsz2, "Error formatting hit for POST upload");
            return true;
        }
        byte[] byArray = string.getBytes();
        if (byArray.length > this.zznT().zzpa()) {
            this.zznS().zza(zzsz2, "Hit payload exceeds size limit");
            return true;
        }
        URL uRL = this.zzh(zzsz2);
        if (uRL == null) {
            this.zzbT("Failed to build collect POST endpoint url");
            return false;
        }
        return this.zza(uRL, byArray) == 200;
    }

    List<Long> zza(List<zzsz> list, boolean bl) {
        zzac.zzax((!list.isEmpty() ? 1 : 0) != 0);
        this.zza("Uploading batched hits. compression, count", bl, list.size());
        zza zza2 = new zza();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (zzsz zzsz2 : list) {
            if (!zza2.zzj(zzsz2)) break;
            arrayList.add(zzsz2.zzpP());
        }
        if (zza2.zzqd() == 0) {
            return arrayList;
        }
        URL uRL = this.zzqb();
        if (uRL == null) {
            this.zzbT("Failed to build batching endpoint url");
            return Collections.emptyList();
        }
        int n = bl ? this.zzb(uRL, zza2.getPayload()) : this.zza(uRL, zza2.getPayload());
        if (200 == n) {
            this.zza("Batched upload completed. Hits batched", zza2.zzqd());
            return arrayList;
        }
        this.zza("Network error uploading hits. status code", n);
        if (this.zznT().zzpp().contains(n)) {
            this.zzbS("Server instructed the client to stop batching");
            this.zzagy.start();
        }
        return Collections.emptyList();
    }

    private URL zzh(zzsz zzsz2) {
        String string;
        if (zzsz2.zzpS()) {
            String string2 = String.valueOf(this.zznT().zzpj());
            String string3 = String.valueOf(this.zznT().zzpl());
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            String string4 = String.valueOf(this.zznT().zzpk());
            String string5 = String.valueOf(this.zznT().zzpl());
            string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzb(zzsz zzsz2, String string) {
        String string2;
        String string3;
        if (zzsz2.zzpS()) {
            string3 = String.valueOf(this.zznT().zzpj());
            String string4 = String.valueOf(this.zznT().zzpl());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append(string3).append(string4).append("?").append(string).toString();
        } else {
            string3 = String.valueOf(this.zznT().zzpk());
            String string5 = String.valueOf(this.zznT().zzpl());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string5).length() + String.valueOf(string).length()).append(string3).append(string5).append("?").append(string).toString();
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private URL zzqb() {
        String string = String.valueOf(this.zznT().zzpj());
        String string2 = String.valueOf(this.zznT().zzpm());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    String zza(zzsz zzsz2, boolean bl) {
        zzac.zzw((Object)zzsz2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzsz2.zzfE().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                this.zza(stringBuilder, string, entry.getValue());
            }
            this.zza(stringBuilder, "ht", String.valueOf(zzsz2.zzpQ()));
            long l = this.zznR().currentTimeMillis() - zzsz2.zzpQ();
            this.zza(stringBuilder, "qt", String.valueOf(l));
            if (bl) {
                long l2 = zzsz2.zzpT();
                String string = l2 != 0L ? String.valueOf(l2) : this.zzi(zzsz2);
                this.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    private String zzi(zzsz zzsz2) {
        return String.valueOf(zzsz2.zzpP());
    }

    private class zza {
        private int zzagA;
        private ByteArrayOutputStream zzagB = new ByteArrayOutputStream();

        public boolean zzj(zzsz zzsz2) {
            zzac.zzw((Object)zzsz2);
            if (this.zzagA + 1 > zztf.this.zznT().zzph()) {
                return false;
            }
            String string = zztf.this.zza(zzsz2, false);
            if (string == null) {
                zztf.this.zznS().zza(zzsz2, "Error formatting hit");
                return true;
            }
            byte[] byArray = string.getBytes();
            int n = byArray.length;
            if (n > zztf.this.zznT().zzoZ()) {
                zztf.this.zznS().zza(zzsz2, "Hit size exceeds the maximum size limit");
                return true;
            }
            if (this.zzagB.size() > 0) {
                ++n;
            }
            if (this.zzagB.size() + n > zztf.this.zznT().zzpb()) {
                return false;
            }
            try {
                if (this.zzagB.size() > 0) {
                    this.zzagB.write(zzagz);
                }
                this.zzagB.write(byArray);
            }
            catch (IOException iOException) {
                zztf.this.zze("Failed to write payload when batching hits", iOException);
                return true;
            }
            ++this.zzagA;
            return true;
        }

        public int zzqd() {
            return this.zzagA;
        }

        public byte[] getPayload() {
            return this.zzagB.toByteArray();
        }
    }
}

