/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zztd;
import com.google.android.gms.internal.zztm;

public class CampaignTrackingService
extends Service {
    private Handler mHandler;
    private static Boolean zzaby;

    public static boolean zzal(Context context) {
        zzac.zzw((Object)context);
        if (zzaby != null) {
            return zzaby;
        }
        boolean bl = zztm.zzy(context, "com.google.android.gms.analytics.CampaignTrackingService");
        zzaby = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onCreate() {
        super.onCreate();
        zzsc zzsc2 = zzsc.zzan((Context)this);
        zztd zztd2 = zzsc2.zznS();
        zztd2.zzbP("CampaignTrackingService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public void onDestroy() {
        zzsc zzsc2 = zzsc.zzan((Context)this);
        zztd zztd2 = zzsc2.zznS();
        zztd2.zzbP("CampaignTrackingService is shutting down");
        super.onDestroy();
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public int onStartCommand(Intent intent, int n, final int n2) {
        String string;
        this.zzmt();
        zzsc zzsc2 = zzsc.zzan((Context)this);
        final zztd zztd2 = zzsc2.zznS();
        String string2 = intent.getStringExtra("referrer");
        final Handler handler = this.getHandler();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zztd2.zzbS("No campaign found on com.android.vending.INSTALL_REFERRER \"referrer\" extra");
            zzsc2.zznU().zzg(new Runnable(){

                @Override
                public void run() {
                    CampaignTrackingService.this.zza(zztd2, handler, n2);
                }
            });
            return 2;
        }
        int n3 = zzsc2.zznT().zzoZ();
        if (string2.length() <= n3) {
            string = string2;
        } else {
            zztd2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string2.length(), n3);
            string = string2.substring(0, n3);
        }
        zztd2.zza("CampaignTrackingService called. startId, campaign", n2, string);
        zzsc2.zzmA().zza(string, new Runnable(){

            @Override
            public void run() {
                CampaignTrackingService.this.zza(zztd2, handler, n2);
            }
        });
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmt() {
        try {
            Object object = CampaignTrackingReceiver.zztX;
            synchronized (object) {
                zzbay zzbay2 = CampaignTrackingReceiver.zzabw;
                if (zzbay2 != null && zzbay2.isHeld()) {
                    zzbay2.release();
                }
            }
        }
        catch (SecurityException securityException) {}
    }

    protected void zza(final zztd zztd2, Handler handler, final int n) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                boolean bl = CampaignTrackingService.this.stopSelfResult(n);
                if (bl) {
                    zztd2.zza("Install campaign broadcast processed", bl);
                }
            }
        });
    }

    private Handler getHandler() {
        Handler handler = this.mHandler;
        if (handler == null) {
            this.mHandler = handler = new Handler(this.getMainLooper());
        }
        return handler;
    }
}

