/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsz;
import com.google.android.gms.internal.zztb;
import com.google.android.gms.internal.zztl;
import com.google.android.gms.internal.zztm;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzsa {
    private boolean zzacs;
    private final Map<String, String> zzFP = new HashMap<String, String>();
    private final Map<String, String> zzact = new HashMap<String, String>();
    private final zztb zzacu;
    private final zza zzacv;
    private ExceptionReporter zzacw;
    private zztl zzacx;

    Tracker(zzsc zzsc2, String string, zztb zztb2) {
        super(zzsc2);
        if (string != null) {
            this.zzFP.put("&tid", string);
        }
        this.zzFP.put("useSecure", "1");
        this.zzFP.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzacu = zztb2 == null ? new zztb("tracking", this.zznR()) : zztb2;
        this.zzacv = new zza(zzsc2);
    }

    @Override
    protected void zzmS() {
        String string;
        this.zzacv.initialize();
        String string2 = this.zzmB().zzmY();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzmB().zzmZ()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zztl zztl2) {
        String string;
        this.zzbP("Loading Tracker config values");
        this.zzacx = zztl2;
        if (this.zzacx.zzqs()) {
            string = this.zzacx.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzacx.zzqt()) {
            string = Double.toString(this.zzacx.zzqu());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzacx.zzqv()) {
            int n = this.zzacx.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzacx.zzqw()) {
            boolean bl = this.zzacx.zzqx();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzacx.zzqy()) {
            boolean bl = this.zzacx.zzqz();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzacx.zzqA());
    }

    private boolean zzmT() {
        return this.zzacw != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzmT() == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzacw = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzacw);
                this.zzbP("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzacw.zzmv();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzbP("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long l) {
        this.zzacv.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzacv.enableAutoActivityTracking(bl);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzac.zzw(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzac.zzw(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        final long l = this.zznR().currentTimeMillis();
        if (this.zzmu().getAppOptOut()) {
            this.zzbQ("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzmu().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzFP, hashMap);
        Tracker.zzb(map, hashMap);
        final boolean bl2 = zztm.zzg(this.zzFP.get("useSecure"), true);
        Tracker.zzc(this.zzact, hashMap);
        this.zzact.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zznS().zzg(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zznS().zzg(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzmU();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzFP.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzFP.put("&a", Integer.toString(n));
            }
        }
        this.zznU().zzg(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzacv.zzmV()) {
                    hashMap.put("sc", "start");
                }
                zztm.zzd(hashMap, "cid", Tracker.this.zzmu().zzmy());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zztm.zza(d = zztm.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                zzrx zzrx2 = Tracker.this.zznY();
                if (bl3) {
                    zztm.zzb(hashMap, "ate", zzrx2.zznw());
                    zztm.zzc(hashMap, "adid", zzrx2.zznG());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzrk zzrk2 = Tracker.this.zznZ().zzoy();
                zztm.zzc(hashMap, "an", zzrk2.zzmY());
                zztm.zzc(hashMap, "av", zzrk2.zzmZ());
                zztm.zzc(hashMap, "aid", zzrk2.zzke());
                zztm.zzc(hashMap, "aiid", zzrk2.zzna());
                hashMap.put("v", "1");
                hashMap.put("_v", zzsb.zzadQ);
                zztm.zzc(hashMap, "ul", Tracker.this.zzoa().zzpB().getLanguage());
                zztm.zzc(hashMap, "sr", Tracker.this.zzoa().zzpC());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzacu.zzpV()) {
                    Tracker.this.zznS().zzg(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zztm.zzcf((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzsz zzsz2 = new zzsz(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zznS().zzc("Dry run enabled. Would have sent hit", zzsz2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zztm.zza(hashMap2, "uid", hashMap);
                zztm.zza(hashMap2, "an", hashMap);
                zztm.zza(hashMap2, "aid", hashMap);
                zztm.zza(hashMap2, "av", hashMap);
                zztm.zza(hashMap2, "aiid", hashMap);
                zzse zzse2 = new zzse(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzmA().zza(zzse2);
                hashMap.put("_s", String.valueOf(l2));
                zzsz zzsz3 = new zzsz(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzmA().zza(zzsz3);
            }
        });
    }

    public String get(String string) {
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzFP.containsKey(string)) {
            return this.zzFP.get(string);
        }
        if (string.equals("&ul")) {
            return zztm.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zznX().zzoQ();
        }
        if (string.equals("&sr")) {
            return this.zzoa().zzpC();
        }
        if (string.equals("&aid")) {
            return this.zznZ().zzoy().zzke();
        }
        if (string.equals("&an")) {
            return this.zznZ().zzoy().zzmY();
        }
        if (string.equals("&av")) {
            return this.zznZ().zzoy().zzmZ();
        }
        if (string.equals("&aiid")) {
            return this.zznZ().zzoy().zzna();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzac.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzFP.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zztm.zzW(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzbS("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zztm.zzW(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzact.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzact.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzact.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzact.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzact.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzact.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzact.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzact.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzact.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzact.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzacs = bl;
    }

    boolean zzmU() {
        return this.zzacs;
    }

    static String zzq(Activity activity) {
        zzac.zzw((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzsa
    implements GoogleAnalytics.zza {
        private boolean zzacG;
        private int zzacH;
        private long zzacI;
        private boolean zzacJ;
        private long zzacK;

        protected zza(zzsc zzsc2) {
            super(zzsc2);
            this.zzacI = -1L;
        }

        @Override
        protected void zzmS() {
        }

        public void setSessionTimeout(long l) {
            this.zzacI = l;
            this.zzmW();
        }

        public void enableAutoActivityTracking(boolean bl) {
            this.zzacG = bl;
            this.zzmW();
        }

        public synchronized boolean zzmV() {
            boolean bl = this.zzacJ;
            this.zzacJ = false;
            return bl;
        }

        private void zzmW() {
            if (this.zzacI >= 0L || this.zzacG) {
                this.zzmu().zza(Tracker.this.zzacv);
            } else {
                this.zzmu().zzb(Tracker.this.zzacv);
            }
        }

        @Override
        public void zzo(Activity activity) {
            if (this.zzacH == 0 && this.zzmX()) {
                this.zzacJ = true;
            }
            ++this.zzacH;
            if (this.zzacG) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzacx != null ? Tracker.this.zzacx.zzr(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzq(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzp(Activity activity) {
            --this.zzacH;
            this.zzacH = Math.max(0, this.zzacH);
            if (this.zzacH == 0) {
                this.zzacK = this.zznR().elapsedRealtime();
            }
        }

        boolean zzmX() {
            return this.zznR().elapsedRealtime() >= this.zzacK + Math.max(1000L, this.zzacI);
        }
    }
}

