/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.internal.zzrt;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.internal.zzsg;
import com.google.android.gms.internal.zzsr;
import com.google.android.gms.internal.zzst;
import com.google.android.gms.internal.zzsu;
import com.google.android.gms.internal.zzsw;
import com.google.android.gms.internal.zzsz;
import com.google.android.gms.internal.zzte;
import com.google.android.gms.internal.zztf;
import com.google.android.gms.internal.zztg;
import com.google.android.gms.internal.zzth;
import com.google.android.gms.internal.zzti;
import com.google.android.gms.internal.zztj;
import com.google.android.gms.internal.zztm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzsi
extends zzsa {
    private boolean mStarted;
    private final zzsg zzaeA;
    private final zztf zzaeB;
    private final zzte zzaeC;
    private final zzsf zzaeD;
    private long zzaeE;
    private final zzsr zzaeF;
    private final zzsr zzaeG;
    private final zztj zzaeH;
    private long zzaeI;
    private boolean zzaeJ;

    protected zzsi(zzsc zzsc2, zzsd zzsd2) {
        super(zzsc2);
        zzac.zzw((Object)zzsd2);
        this.zzaeE = Long.MIN_VALUE;
        this.zzaeC = zzsd2.zzk(zzsc2);
        this.zzaeA = zzsd2.zzm(zzsc2);
        this.zzaeB = zzsd2.zzn(zzsc2);
        this.zzaeD = zzsd2.zzo(zzsc2);
        this.zzaeH = new zztj(this.zznR());
        this.zzaeF = new zzsr(zzsc2){

            @Override
            public void run() {
                zzsi.this.zzoB();
            }
        };
        this.zzaeG = new zzsr(zzsc2){

            @Override
            public void run() {
                zzsi.this.zzoC();
            }
        };
    }

    @Override
    protected void zzmS() {
        this.zzaeA.initialize();
        this.zzaeB.initialize();
        this.zzaeD.initialize();
    }

    void start() {
        this.zzob();
        zzac.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zznU().zzg(new Runnable(){

            @Override
            public void run() {
                zzsi.this.zzoA();
            }
        });
    }

    private void zzoz() {
        boolean bl;
        this.zzmR();
        zzsc zzsc2 = this.zznQ();
        Context context = zzsc2.getContext();
        boolean bl2 = zzth.zzak(context);
        if (!bl2) {
            this.zzbS("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = zzti.zzal(context);
            if (!bl) {
                this.zzbT("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzak(context);
        if (!bl) {
            this.zzbS("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzal(context);
            if (!bl3) {
                this.zzbS("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzbW(String string) {
        int n = zzadg.zzbi((Context)this.getContext()).checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zzoA() {
        this.zzob();
        this.zzoz();
        this.zznW().zzqe();
        if (!this.zzbW("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbT("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzoP();
        }
        if (!this.zzbW("android.permission.INTERNET")) {
            this.zzbT("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzoP();
        }
        if (zzti.zzal(this.getContext())) {
            this.zzbP("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzbS("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzaeJ && !this.zzaeA.isEmpty()) {
            this.zzoD();
        }
        this.zzoH();
    }

    private void zzoB() {
        this.zzb(new zzsu(){

            @Override
            public void zzf(Throwable throwable) {
                zzsi.this.zzoH();
            }
        });
    }

    void zznP() {
        this.zzmR();
        this.zzaeI = this.zznR().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zzmR();
        this.zzoE();
    }

    public void zznN() {
        zzh.zzmR();
        this.zzob();
        this.zzbP("Service disconnected");
    }

    public void zzV(boolean bl) {
        this.zzoH();
    }

    private void zzoC() {
        try {
            this.zzaeA.zzot();
            this.zzoH();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzaeG.zzy(86400000L);
    }

    protected void zzc(zzse zzse2) {
        this.zzmR();
        this.zzb("Sending first hit to property", zzse2.zzok());
        if (this.zznW().zzqf().zzA(this.zznT().zzpy())) {
            return;
        }
        String string = this.zznW().zzqi();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzrl zzrl2 = zztm.zza(this.zznS(), string);
        this.zzb("Found relevant installation campaign", zzrl2);
        this.zza(zzse2, zzrl2);
    }

    public void zzx(long l) {
        zzh.zzmR();
        this.zzob();
        if (l < 0L) {
            l = 0L;
        }
        this.zzaeE = l;
        this.zzoH();
    }

    protected void zzoD() {
        if (this.zzaeJ) {
            return;
        }
        if (!this.zznT().zzoX()) {
            return;
        }
        if (this.zzaeD.isConnected()) {
            return;
        }
        long l = this.zznT().zzps();
        if (this.zzaeH.zzA(l)) {
            this.zzaeH.start();
            this.zzbP("Connecting to service");
            if (this.zzaeD.connect()) {
                this.zzbP("Connected to service");
                this.zzaeH.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzse zzse2, boolean bl) {
        long l;
        zzac.zzw((Object)zzse2);
        this.zzob();
        this.zzmR();
        try {
            this.zzaeA.beginTransaction();
            this.zzaeA.zza(zzse2.zzoj(), zzse2.zzmy());
            l = this.zzaeA.zza(zzse2.zzoj(), zzse2.zzmy(), zzse2.zzok());
            if (!bl) {
                zzse2.zzs(l);
            } else {
                zzse2.zzs(l + 1L);
            }
            this.zzaeA.zzb(zzse2);
            this.zzaeA.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzaeA.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzsz zzsz2) {
        zzac.zzw((Object)zzsz2);
        zzh.zzmR();
        this.zzob();
        if (this.zzaeJ) {
            this.zzbQ("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzsz2);
        }
        zzsz2 = this.zzf(zzsz2);
        this.zzoD();
        if (this.zzaeD.zzb(zzsz2)) {
            this.zzbQ("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzaeA.zzc(zzsz2);
            this.zzoH();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zznS().zza(zzsz2, "deliver: failed to insert hit to database");
        }
    }

    public void zznK() {
        zzh.zzmR();
        this.zzob();
        this.zzbP("Delete all hits from local store");
        try {
            this.zzaeA.zzor();
            this.zzaeA.zzos();
            this.zzoH();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzoD();
        if (this.zzaeD.zzon()) {
            this.zzbP("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzsz zzf(zzsz zzsz2) {
        if (!TextUtils.isEmpty((CharSequence)zzsz2.zzpU())) {
            return zzsz2;
        }
        zztg.zza zza2 = this.zznW().zzqj();
        Pair<String, Long> pair = zza2.zzqm();
        if (pair == null) {
            return zzsz2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        Object object = String.valueOf(l);
        String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
        object = new HashMap<String, String>(zzsz2.zzfE());
        object.put("_m", string2);
        return zzsz.zza(this, zzsz2, (Map<String, String>)object);
    }

    public void zzoE() {
        zzh.zzmR();
        this.zzob();
        if (!this.zznT().zzoX()) {
            this.zzbS("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzaeD.isConnected()) {
            this.zzbP("Service not connected");
            return;
        }
        if (this.zzaeA.isEmpty()) {
            return;
        }
        this.zzbP("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzsz> list;
            try {
                list = this.zzaeA.zzu(this.zznT().zzpg());
                if (list.isEmpty()) {
                    this.zzoH();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzoL();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzsz zzsz2 = list.get(0);
                if (!this.zzaeD.zzb(zzsz2)) {
                    this.zzoH();
                    return;
                }
                list.remove(zzsz2);
                try {
                    this.zzaeA.zzv(zzsz2.zzpP());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzoL();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzoF() {
        boolean bl;
        zzh.zzmR();
        this.zzob();
        this.zzbP("Dispatching a batch of local hits");
        boolean bl2 = !this.zzaeD.isConnected();
        boolean bl3 = bl = !this.zzaeB.zzqa();
        if (bl2 && bl) {
            this.zzbP("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zznT().zzpg(), this.zznT().zzph());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzsz> list;
                block38: {
                    this.zzaeA.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzaeA.zzu(l);
                        if (!list.isEmpty()) break block38;
                        this.zzbP("Store is empty, nothing to dispatch");
                        this.zzoL();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzoL();
                        try {
                            this.zzaeA.setTransactionSuccessful();
                            this.zzaeA.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzoL();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzsz)object).zzpP() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzoL();
                    return false;
                }
                if (this.zzaeD.isConnected()) {
                    this.zzbP("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzaeD.zzb((zzsz)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzsz)object2).zzpP());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzaeA.zzv(((zzsz)object2).zzpP());
                            arrayList.add(((zzsz)object2).zzpP());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzoL();
                            try {
                                this.zzaeA.setTransactionSuccessful();
                                this.zzaeA.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzoL();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzaeB.zzqa()) {
                    object2 = this.zzaeB.zzt(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzaeA.zzr((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzoL();
                        try {
                            this.zzaeA.setTransactionSuccessful();
                            this.zzaeA.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzoL();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzaeA.setTransactionSuccessful();
                    this.zzaeA.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzoL();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzsu zzsu2) {
        this.zza(zzsu2, this.zzaeI);
    }

    public void zza(zzsu zzsu2, long l) {
        block5: {
            zzh.zzmR();
            this.zzob();
            long l2 = -1L;
            long l3 = this.zznW().zzqg();
            if (l3 != 0L) {
                l2 = Math.abs(this.zznR().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            this.zzoD();
            try {
                this.zzoF();
                this.zznW().zzqh();
                this.zzoH();
                if (zzsu2 != null) {
                    zzsu2.zzf(null);
                }
                if (this.zzaeI != l) {
                    this.zzaeC.zzpZ();
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zznW().zzqh();
                this.zzoH();
                if (zzsu2 == null) break block5;
                zzsu2.zzf(throwable);
            }
        }
    }

    public void zzoG() {
        zzh.zzmR();
        this.zzob();
        this.zzbQ("Sync dispatching local hits");
        long l = this.zzaeI;
        this.zzoD();
        try {
            this.zzoF();
            this.zznW().zzqh();
            this.zzoH();
            if (this.zzaeI != l) {
                this.zzaeC.zzpZ();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzoH();
        }
    }

    public long zzou() {
        zzh.zzmR();
        this.zzob();
        try {
            return this.zzaeA.zzou();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzoH() {
        boolean bl;
        this.zznQ().zzmR();
        this.zzob();
        if (!this.zzoI()) {
            this.zzaeC.unregister();
            this.zzoL();
            return;
        }
        if (this.zzaeA.isEmpty()) {
            this.zzaeC.unregister();
            this.zzoL();
            return;
        }
        if (!zzsw.zzafS.get().booleanValue()) {
            this.zzaeC.zzpX();
            bl = this.zzaeC.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzoK();
        } else {
            this.zzoL();
            this.zzoJ();
        }
    }

    private boolean zzoI() {
        if (this.zzaeJ) {
            return false;
        }
        return this.zzoO() > 0L;
    }

    private void zzoJ() {
        long l;
        long l2;
        long l3;
        zzst zzst2 = this.zznV();
        if (!zzst2.zzpD()) {
            return;
        }
        if (!zzst2.zzcy() && (l3 = this.zzou()) != 0L && (l2 = Math.abs((l = this.zznR().currentTimeMillis()) - l3)) <= this.zznT().zzpf()) {
            long l4 = this.zznT().zzpe();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzst2.schedule();
        }
    }

    private void zzoK() {
        long l;
        long l2;
        this.zzoJ();
        long l3 = this.zzoO();
        long l4 = this.zznW().zzqg();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zznR().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zznT().zzpc(), l3)) : Math.min(this.zznT().zzpc(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzaeF.zzcy()) {
            l = Math.max(1L, l5 + this.zzaeF.zzpA());
            this.zzaeF.zzz(l);
        } else {
            this.zzaeF.zzy(l5);
        }
    }

    private void zzoL() {
        this.zzoM();
        this.zzoN();
    }

    private void zzoM() {
        if (this.zzaeF.zzcy()) {
            this.zzbP("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzaeF.cancel();
    }

    private void zzoN() {
        zzst zzst2 = this.zznV();
        if (zzst2.zzcy()) {
            zzst2.cancel();
        }
    }

    public long zzoO() {
        if (this.zzaeE != Long.MIN_VALUE) {
            return this.zzaeE;
        }
        long l = this.zznT().zzpd();
        if (this.zzmB().zzpK()) {
            l = (long)this.zzmB().zzqB() * 1000L;
        }
        return l;
    }

    public void zzbX(String string) {
        zzac.zzdr((String)string);
        this.zzmR();
        zzrl zzrl2 = zztm.zza(this.zznS(), string);
        if (zzrl2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zznW().zzqi();
        if (string.equals(string2)) {
            this.zzbS("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zznW().zzcb(string);
        if (this.zznW().zzqf().zzA(this.zznT().zzpy())) {
            this.zzd("Campaign received too late, ignoring", zzrl2);
            return;
        }
        this.zzb("Received installation campaign", zzrl2);
        List<zzse> list = this.zzaeA.zzw(0L);
        for (zzse zzse2 : list) {
            this.zza(zzse2, zzrl2);
        }
    }

    private void zza(zzse zzse2, zzrl zzrl2) {
        zzac.zzw((Object)zzse2);
        zzac.zzw((Object)zzrl2);
        zza zza2 = new zza(this.zznQ());
        zza2.zzbo(zzse2.zzok());
        zza2.enableAdvertisingIdCollection(zzse2.zzol());
        zze zze2 = zza2.zzmo();
        zzrt zzrt2 = zze2.zzb(zzrt.class);
        zzrt2.zzbE("data");
        zzrt2.zzS(true);
        zze2.zza(zzrl2);
        zzro zzro2 = zze2.zzb(zzro.class);
        zzrk zzrk2 = zze2.zzb(zzrk.class);
        for (Map.Entry<String, String> entry : zzse2.zzfE().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzrk2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzrk2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzrk2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzrk2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzrt2.setUserId(string2);
                continue;
            }
            zzro2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzse2.zzok(), zzrl2);
        zze2.zzq(this.zznW().zzqe());
        zze2.zzmG();
    }

    public void zzoP() {
        this.zzob();
        this.zzmR();
        this.zzaeJ = true;
        this.zzaeD.disconnect();
        this.zzoH();
    }
}

