/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzapn;
import com.google.android.gms.internal.zzaqb;
import com.google.android.gms.internal.zzaqd;
import com.google.android.gms.internal.zzaqf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzadE = new ArrayList<Runnable>();
    private boolean zzuK;
    private Set<zza> zzadF = new HashSet<zza>();
    private boolean zzadG;
    private boolean zzadH;
    private volatile boolean zzadI;
    private boolean zzadJ;

    public final void initialize() {
        GoogleAnalytics googleAnalytics = this;
        zzaqf zzaqf2 = googleAnalytics.zzjh().zzkw();
        zzaqf2.zzme();
        if (zzaqf2.zzmf()) {
            googleAnalytics.setDryRun(zzaqf2.zzmg());
        }
        zzaqf2.zzme();
        this.zzuK = true;
    }

    public final boolean isInitialized() {
        return this.zzuK;
    }

    public GoogleAnalytics(zzanv zzanv2) {
        super(zzanv2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzanv.zzaf(context).zzkF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzjn() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzadE != null) {
                Iterator<Runnable> iterator = zzadE.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzadE = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzadH = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzadH;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzadG) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(this));
            this.zzadG = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzadG) {
            this.zzj(activity);
        }
    }

    final void zzj(Activity activity) {
        Iterator<zza> iterator = this.zzadF.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzl(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzadG) {
            this.zzk(activity);
        }
    }

    final void zzk(Activity activity) {
        Iterator<zza> iterator = this.zzadF.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzm(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzjh(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzaqd zzaqd2;
            Tracker tracker = new Tracker(this.zzjh(), null, null);
            if (n > 0 && (zzaqd2 = (zzaqd)new zzaqb(this.zzjh()).zzP(n)) != null) {
                tracker.zza(zzaqd2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzadF.add(zza2);
        Context context = this.zzjh().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzadF.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzadI = bl;
        if (this.zzadI) {
            this.zzjh().zzku().zzkj();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzadI;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzapn.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzapn.setLogger(logger);
        if (!this.zzadJ) {
            String string = zzape.zzahi.get();
            Log.i((String)zzape.zzahi.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzadJ = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zzjh().zzku().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zzjh().zzku().zzkk();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        private /* synthetic */ GoogleAnalytics zzadK;

        zzb(GoogleAnalytics googleAnalytics) {
            this.zzadK = googleAnalytics;
        }

        public final void onActivityStarted(Activity activity) {
            this.zzadK.zzj(activity);
        }

        public final void onActivityStopped(Activity activity) {
            this.zzadK.zzk(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzl(Activity var1);

        public void zzm(Activity var1);
    }
}

