/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzanb;
import com.google.android.gms.internal.zzaqe;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzl {
    private static volatile zzl zzaef;
    private final Context mContext;
    private final List<Object> zzaeg;
    private final zzg zzaeh;
    private final zza zzaei;
    private volatile zzamw zzaej;
    private Thread.UncaughtExceptionHandler zzaek;

    private zzl(Context context) {
        Context context2 = context.getApplicationContext();
        zzbr.zzu((Object)context2);
        this.mContext = context2;
        this.zzaei = new zza();
        this.zzaeg = new CopyOnWriteArrayList<Object>();
        this.zzaeh = new zzg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzl zzae(Context context) {
        zzbr.zzu((Object)context);
        if (zzaef != null) return zzaef;
        Class<zzl> clazz = zzl.class;
        synchronized (zzl.class) {
            if (zzaef != null) return zzaef;
            zzaef = new zzl(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaef;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzamw zzjz() {
        if (this.zzaej == null) {
            zzl zzl2 = this;
            synchronized (zzl2) {
                if (this.zzaej == null) {
                    zzamw zzamw2 = new zzamw();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzamw2.setAppId(string);
                    zzamw2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzamw2.setAppName(string2);
                    zzamw2.setAppVersion(string3);
                    this.zzaej = zzamw2;
                }
            }
        }
        return this.zzaej;
    }

    public final zzanb zzjA() {
        int n;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzanb zzanb2 = new zzanb();
        zzanb2.setLanguage(zzaqe.zza(Locale.getDefault()));
        zzanb2.zzOa = n = displayMetrics.widthPixels;
        zzanb2.zzOb = n = displayMetrics.heightPixels;
        return zzanb2;
    }

    final void zze(zzi zzi2) {
        if (zzi2.zzjw()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzi2.zzjt()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzi zzi3 = zzi2.zzjo();
        zzi3.zzju();
        this.zzaei.execute(new zzm(this, zzi3));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public static void zzjB() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzaek = uncaughtExceptionHandler;
    }

    public final <V> Future<V> zzd(Callable<V> callable) {
        zzbr.zzu(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzaei.submit(callable);
    }

    public final void zzf(Runnable runnable) {
        zzbr.zzu((Object)runnable);
        this.zzaei.submit(runnable);
    }

    private static void zzb(zzi zzi2) {
        zzbr.zzcG((String)"deliver should be called from worker thread");
        zzbr.zzb((boolean)zzi2.zzjt(), (Object)"Measurement must be submitted");
        List<zzo> list = zzi2.zzjq();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzo zzo2 : list) {
            Uri uri = zzo2.zzjk();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzo2.zzb(zzi2);
        }
    }

    static /* synthetic */ List zza(zzl zzl2) {
        return zzl2.zzaeg;
    }

    static /* synthetic */ void zza(zzl zzl2, zzi zzi2) {
        zzl.zzb(zzi2);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler zzb(zzl zzl2) {
        return zzl2.zzaek;
    }

    static final class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaeo = new AtomicInteger();

        private zzb() {
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            int n = zzaeo.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }

        /* synthetic */ zzb(zzm zzm2) {
            this();
        }
    }

    static final class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    final class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb(null));
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new zzn(this, runnable, t);
        }
    }
}

