/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqe;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public final class zzanj
extends zzant {
    private static boolean zzafx;
    private AdvertisingIdClient.Info zzafy;
    private final zzaqa zzafz;
    private String zzafA;
    private boolean zzafB = false;
    private Object zzafC = new Object();

    zzanj(zzanv zzanv2) {
        super(zzanv2);
        this.zzafz = new zzaqa(zzanv2.zzkp());
    }

    @Override
    protected final void zzjC() {
    }

    public final boolean zzjY() {
        this.zzkC();
        AdvertisingIdClient.Info info = this.zzkg();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public final String zzkf() {
        this.zzkC();
        AdvertisingIdClient.Info info = this.zzkg();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private final synchronized AdvertisingIdClient.Info zzkg() {
        if (this.zzafz.zzu(1000L)) {
            this.zzafz.start();
            AdvertisingIdClient.Info info = this.zzkh();
            if (this.zza(this.zzafy, info)) {
                this.zzafy = info;
            } else {
                this.zzbs("Failed to reset client id on adid change. Not using adid");
                this.zzafy = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzafy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = this.zzky().zzlh();
        Object object = this.zzafC;
        synchronized (object) {
            String string3;
            if (!this.zzafB) {
                this.zzafA = this.zzki();
                this.zzafB = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzafA)) {
                string3 = info == null ? null : info.getId();
                if (string3 == null) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf(string2);
                    return this.zzbn(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
                String string6 = String.valueOf(string3);
                String string7 = String.valueOf(string2);
                this.zzafA = zzanj.zzbm(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            }
            String string8 = String.valueOf(string);
            String string9 = String.valueOf(string2);
            string3 = zzanj.zzbm(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            if (string3.equals(this.zzafA)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzafA)) {
                this.zzbo("Resetting the client id because Advertising Id changed.");
                string2 = this.zzky().zzli();
                this.zza("New client Id", string2);
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string2);
            return this.zzbn(string11.length() != 0 ? string10.concat(string11) : new String(string10));
        }
    }

    private final AdvertisingIdClient.Info zzkh() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbr("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzafx) break block3;
                zzafx = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzbm(String string) {
        MessageDigest messageDigest = zzaqe.zzbE("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private final boolean zzbn(String string) {
        try {
            String string2 = zzanj.zzbm(string);
            this.zzbo("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.getContext().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzafA = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    private final String zzki() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzbr("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzbo("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

