/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzaoo;
import com.google.android.gms.internal.zzaop;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzaon
extends zzant {
    private volatile String zzaff;
    private Future<String> zzagP;

    protected zzaon(zzanv zzanv2) {
        super(zzanv2);
    }

    @Override
    protected final void zzjC() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzlh() {
        this.zzkC();
        zzaon zzaon2 = this;
        synchronized (zzaon2) {
            if (this.zzaff == null) {
                this.zzagP = this.zzks().zzd(new zzaoo(this));
            }
            if (this.zzagP != null) {
                try {
                    this.zzaff = this.zzagP.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzaff = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzaff = "0";
                }
                if (this.zzaff == null) {
                    this.zzaff = "0";
                }
                this.zza("Loaded clientId", this.zzaff);
                this.zzagP = null;
            }
            return this.zzaff;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzli() {
        zzaon zzaon2 = this;
        synchronized (zzaon2) {
            this.zzaff = null;
            this.zzagP = this.zzks().zzd(new zzaop(this));
        }
        return this.zzlh();
    }

    final String zzlj() {
        String string = this.zzag(this.zzks().getContext());
        if (string == null) {
            string = this.zzlk();
        }
        return string;
    }

    private final String zzlk() {
        String string = UUID.randomUUID().toString().toLowerCase();
        try {
            if (!this.zzv(this.zzks().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzag(Context context) {
        zzbr.zzcG((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzbr("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzbr("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzv(Context context, String string) {
        zzbr.zzcF((String)string);
        zzbr.zzcG((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzaon zzaon2) {
        return zzaon2.zzlk();
    }
}

