/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzalw;
import com.google.android.gms.internal.zzalx;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaob;
import com.google.android.gms.internal.zzaoq;
import com.google.android.gms.internal.zzaor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzamg {
    private boolean zzaeo;
    private final Map<String, String> zzHc = new HashMap<String, String>();
    private final Map<String, String> zzaep = new HashMap<String, String>();
    private final zzanz zzaeq;
    private final zza zzaer;
    private ExceptionReporter zzaes;
    private zzaoq zzaet;

    Tracker(zzami zzami2, String string, zzanz zzanz2) {
        super(zzami2);
        if (string != null) {
            this.zzHc.put("&tid", string);
        }
        this.zzHc.put("useSecure", "1");
        this.zzHc.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzaeq = new zzanz("tracking", this.zzkq());
        this.zzaer = new zza(this, zzami2);
    }

    @Override
    protected final void zzjD() {
        String string;
        this.zzaer.initialize();
        String string2 = this.zzkx().zzjG();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzkx().zzjH()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzaoq zzaoq2) {
        String string;
        this.zzbo("Loading Tracker config values");
        this.zzaet = zzaoq2;
        if (this.zzaet.zzado != null) {
            string = this.zzaet.zzado;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzaet.zzaiI >= 0.0) {
            string = Double.toString(this.zzaet.zzaiI);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzaet.zzaiJ >= 0) {
            int n = this.zzaet.zzaiJ;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzaet.zzaiK != -1) {
            boolean bl = this.zzaet.zzaiK == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzaet.zzaiL != -1) {
            boolean bl = this.zzaet.zzaiL == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzaet.zzaiM == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzaes != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzaes = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzaes);
                this.zzbo("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzaes.zzjn());
                this.zzbo("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzaer.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzaer.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        Map.Entry<String, String> entry2 = entry;
        String string = entry2.getKey();
        entry2.getValue();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbo.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzbo.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzkq().currentTimeMillis();
        if (this.zzku().getAppOptOut()) {
            this.zzbp("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzku().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzHc, hashMap);
        Tracker.zzb(map, hashMap);
        boolean bl2 = zzaor.zzf(this.zzHc.get("useSecure"), true);
        Tracker.zzc(this.zzaep, hashMap);
        this.zzaep.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzkr().zze(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzkr().zze(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzaeo;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzHc.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzHc.put("&a", Integer.toString(n));
            }
        }
        this.zzkt().zzf(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzHc.containsKey(string)) {
            return this.zzHc.get(string);
        }
        if (string.equals("&ul")) {
            return zzaor.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzkz().zzli();
        }
        if (string.equals("&sr")) {
            return this.zzkC().zzlB();
        }
        if (string.equals("&aid")) {
            return this.zzkB().zzkW().zzhl();
        }
        if (string.equals("&an")) {
            return this.zzkB().zzkW().zzjG();
        }
        if (string.equals("&av")) {
            return this.zzkB().zzkW().zzjH();
        }
        if (string.equals("&aiid")) {
            return this.zzkB().zzkW().zzjI();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbo.zzb((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzHc.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzaor.zzI(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzbr("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzaor.zzI(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzaep.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzaep.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzaep.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzaep.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzaep.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzaep.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzaep.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzaep.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzaep.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzaep.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzaeo = bl;
    }

    static /* synthetic */ zzalw zzb(Tracker tracker) {
        return tracker.zzkA();
    }

    static /* synthetic */ zzamt zzc(Tracker tracker) {
        return tracker.zzkB();
    }

    static /* synthetic */ zzann zzd(Tracker tracker) {
        return tracker.zzkC();
    }

    static /* synthetic */ zzann zze(Tracker tracker) {
        return tracker.zzkC();
    }

    static /* synthetic */ zzanz zzf(Tracker tracker) {
        return tracker.zzaeq;
    }

    static /* synthetic */ zzaob zzg(Tracker tracker) {
        return tracker.zzkr();
    }

    static /* synthetic */ zzaob zzh(Tracker tracker) {
        return tracker.zzkr();
    }

    static /* synthetic */ zzalx zzi(Tracker tracker) {
        return tracker.zzkv();
    }

    static /* synthetic */ zzalx zzj(Tracker tracker) {
        return tracker.zzkv();
    }

    final class zza
    extends zzamg
    implements GoogleAnalytics.zza {
        private boolean zzaeC;
        private int zzaeD;
        private long zzaeE;
        private boolean zzaeF;
        private long zzaeG;
        private /* synthetic */ Tracker zzaeB;

        protected zza(Tracker tracker, zzami zzami2) {
            this.zzaeB = tracker;
            super(zzami2);
            this.zzaeE = -1L;
        }

        @Override
        protected final void zzjD() {
        }

        public final void setSessionTimeout(long l) {
            this.zzaeE = l;
            this.zzjF();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzaeC = bl;
            this.zzjF();
        }

        public final synchronized boolean zzjE() {
            boolean bl = this.zzaeF;
            this.zzaeF = false;
            return bl;
        }

        private final void zzjF() {
            if (this.zzaeE >= 0L || this.zzaeC) {
                this.zzku().zza(this.zzaeB.zzaer);
                return;
            }
            this.zzku().zzb(this.zzaeB.zzaer);
        }

        @Override
        public final void zzl(Activity activity) {
            zza zza2;
            if (this.zzaeD == 0 && (zza2 = this).zzkq().elapsedRealtime() >= zza2.zzaeG + Math.max(1000L, zza2.zzaeE)) {
                this.zzaeF = true;
            }
            ++this.zzaeD;
            if (this.zzaeC) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzaeB.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzaeB.set("&cd", this.zzaeB.zzaet != null ? ((string2 = ((Tracker)this.zzaeB).zzaet.zzaiN.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbo.zzu((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzaeB.send(hashMap);
            }
        }

        @Override
        public final void zzm(Activity activity) {
            --this.zzaeD;
            this.zzaeD = Math.max(0, this.zzaeD);
            if (this.zzaeD == 0) {
                this.zzaeG = this.zzkq().elapsedRealtime();
            }
        }
    }
}

