/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzalk;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.internal.zzals;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamk;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamm;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzanl;
import com.google.android.gms.internal.zzano;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.internal.zzanr;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzaoc;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzaoj;
import com.google.android.gms.internal.zzaon;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaos;
import com.google.android.gms.internal.zzbgz;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzamu
extends zzamg {
    private boolean mStarted;
    private final zzamr zzagv;
    private final zzaod zzagw;
    private final zzaoc zzagx;
    private final zzamm zzagy;
    private long zzagz;
    private final zzanl zzagA;
    private final zzanl zzagB;
    private final zzaon zzagC;
    private long zzagD;
    private boolean zzagE;

    protected zzamu(zzami zzami2, zzamk zzamk2) {
        super(zzami2);
        zzbo.zzu((Object)zzamk2);
        this.zzagz = Long.MIN_VALUE;
        zzami zzami3 = zzami2;
        this.zzagx = new zzaoc(zzami3);
        zzami3 = zzami2;
        this.zzagv = new zzamr(zzami3);
        zzami3 = zzami2;
        this.zzagw = new zzaod(zzami3);
        zzami3 = zzami2;
        this.zzagy = new zzamm(zzami3);
        this.zzagC = new zzaon(this.zzkq());
        this.zzagA = new zzamv(this, zzami2);
        this.zzagB = new zzamw(this, zzami2);
    }

    @Override
    protected final void zzjD() {
        this.zzagv.initialize();
        this.zzagw.initialize();
        this.zzagy.initialize();
    }

    final void start() {
        this.zzkD();
        zzbo.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzkt().zzf(new zzamx(this));
    }

    private final boolean zzbv(String string) {
        return zzbgz.zzaP((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzkX() {
        this.zzkD();
        zzamu zzamu2 = this;
        zzl.zzjC();
        Context context = zzamu2.zzkp().getContext();
        if (!zzaoi.zzac(context)) {
            zzamu2.zzbr("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzaoj.zzad(context)) {
            zzamu2.zzbs("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzac(context)) {
            zzamu2.zzbr("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!CampaignTrackingService.zzad(context)) {
            zzamu2.zzbr("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzky().zzlU();
        if (!this.zzbv("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbs("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzlh();
        }
        if (!this.zzbv("android.permission.INTERNET")) {
            this.zzbs("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzlh();
        }
        if (zzaoj.zzad(this.getContext())) {
            this.zzbo("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzbr("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzagE && !this.zzagv.isEmpty()) {
            this.zzla();
        }
        this.zzld();
    }

    private final void zzkY() {
        this.zzb(new zzamy(this));
    }

    final void zzko() {
        zzl.zzjC();
        this.zzagD = this.zzkq().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzl.zzjC();
        zzamu zzamu2 = this;
        zzl.zzjC();
        zzamu2.zzkD();
        if (!zzanj.zzlo()) {
            zzamu2.zzbr("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzamu2.zzagy.isConnected()) {
            zzamu2.zzbo("Service not connected");
            return;
        }
        if (!zzamu2.zzagv.isEmpty()) {
            zzamu2.zzbo("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzanw> list;
                try {
                    list = zzamu2.zzagv.zzo(zzanj.zzls());
                    if (list.isEmpty()) {
                        zzamu2.zzld();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzamu2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzamu2.zzlf();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzanw zzanw2 = list.get(0);
                    if (!zzamu2.zzagy.zzb(zzanw2)) {
                        zzamu2.zzld();
                        return;
                    }
                    list.remove(zzanw2);
                    try {
                        zzamu2.zzagv.zzp(zzanw2.zzlF());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzamu2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzamu2.zzlf();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzkZ() {
        try {
            this.zzagv.zzkS();
            this.zzld();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzagB.zzs(86400000L);
    }

    protected final void zzb(zzaml zzaml2) {
        zzl.zzjC();
        this.zzb("Sending first hit to property", zzaml2.zzkL());
        if (this.zzky().zzlV().zzu(zzanj.zzly())) {
            return;
        }
        String string = this.zzky().zzlY();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzalk zzalk2 = zzaor.zza(this.zzkr(), string);
        this.zzb("Found relevant installation campaign", zzalk2);
        this.zza(zzaml2, zzalk2);
    }

    public final void zzr(long l) {
        zzl.zzjC();
        this.zzkD();
        if (l < 0L) {
            l = 0L;
        }
        this.zzagz = l;
        this.zzld();
    }

    private final void zzla() {
        if (this.zzagE) {
            return;
        }
        if (!zzanj.zzlo()) {
            return;
        }
        if (this.zzagy.isConnected()) {
            return;
        }
        long l = zzanr.zzahS.get();
        if (this.zzagC.zzu(l)) {
            this.zzagC.start();
            this.zzbo("Connecting to service");
            if (this.zzagy.connect()) {
                this.zzbo("Connected to service");
                this.zzagC.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzaml zzaml2, boolean bl) {
        long l;
        zzbo.zzu((Object)zzaml2);
        this.zzkD();
        zzl.zzjC();
        try {
            this.zzagv.beginTransaction();
            String string = zzaml2.zzjX();
            long l2 = zzaml2.zzkK();
            zzamr zzamr2 = this.zzagv;
            zzbo.zzcF((String)string);
            zzamr2.zzkD();
            zzl.zzjC();
            int n = zzamr2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzamr2.zza("Deleted property records", n);
            }
            l = this.zzagv.zza(zzaml2.zzkK(), zzaml2.zzjX(), zzaml2.zzkL());
            zzaml2.zzm(l + 1L);
            zzaml zzaml3 = zzaml2;
            zzamr zzamr3 = this.zzagv;
            zzbo.zzu((Object)zzaml3);
            zzamr3.zzkD();
            zzl.zzjC();
            SQLiteDatabase sQLiteDatabase = zzamr3.getWritableDatabase();
            Map<String, String> map = zzaml3.zzdV();
            zzbo.zzu(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzaml3.zzkK()));
            contentValues.put("cid", zzaml3.zzjX());
            contentValues.put("tid", zzaml3.zzkL());
            contentValues.put("adid", Integer.valueOf(zzaml3.zzkM() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzaml3.zzkN()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzamr3.zzbs("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzamr3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzagv.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzagv.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzanw zzanw2) {
        zzanw zzanw3;
        zzbo.zzu((Object)zzanw2);
        zzl.zzjC();
        this.zzkD();
        if (this.zzagE) {
            this.zzbp("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzanw2);
        }
        zzanw zzanw4 = zzanw2;
        zzamu zzamu2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzanw4.zzlK())) {
            zzanw3 = zzanw4;
        } else {
            Pair<String, Long> pair = zzamu2.zzky().zzlZ().zzmb();
            if (pair == null) {
                zzanw3 = zzanw4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzanw4.zzdV());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzanw zzanw5 = zzanw4;
                zzamu zzamu3 = zzamu2;
                zzanw3 = new zzanw(zzamu3, (Map<String, String>)object2, zzanw5.zzlG(), zzanw5.zzlI(), zzanw5.zzlF(), zzanw5.zzlE(), zzanw5.zzlH());
            }
        }
        zzanw2 = zzanw3;
        this.zzla();
        if (this.zzagy.zzb(zzanw2)) {
            this.zzbp("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzagv.zzc(zzanw2);
            this.zzld();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzkr().zza(zzanw2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzkk() {
        zzl.zzjC();
        this.zzkD();
        this.zzbo("Delete all hits from local store");
        try {
            zzamr zzamr2 = this.zzagv;
            zzl.zzjC();
            zzamr2.zzkD();
            zzamr2.getWritableDatabase().delete("hits2", null, null);
            zzamr2 = this.zzagv;
            zzl.zzjC();
            zzamr2.zzkD();
            zzamr2.getWritableDatabase().delete("properties", null, null);
            this.zzld();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzla();
        if (this.zzagy.zzkO()) {
            this.zzbo("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzlb() {
        boolean bl;
        zzl.zzjC();
        this.zzkD();
        this.zzbo("Dispatching a batch of local hits");
        boolean bl2 = !this.zzagy.isConnected();
        boolean bl3 = bl = !this.zzagw.zzlQ();
        if (bl2 && bl) {
            this.zzbo("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzanj.zzls(), zzanj.zzlt());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzanw> list;
                block38: {
                    this.zzagv.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzagv.zzo(l);
                        if (!list.isEmpty()) break block38;
                        this.zzbo("Store is empty, nothing to dispatch");
                        this.zzlf();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzlf();
                        try {
                            this.zzagv.setTransactionSuccessful();
                            this.zzagv.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzlf();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzlF() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzlf();
                    return false;
                }
                if (this.zzagy.isConnected()) {
                    this.zzbo("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzagy.zzb((zzanw)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzanw)((Object)list2)).zzlF());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzagv.zzp(((zzanw)((Object)list2)).zzlF());
                            arrayList.add(((zzanw)((Object)list2)).zzlF());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzlf();
                            try {
                                this.zzagv.setTransactionSuccessful();
                                this.zzagv.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzlf();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzagw.zzlQ()) {
                    list2 = this.zzagw.zzu(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzagv.zzs(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzlf();
                        try {
                            this.zzagv.setTransactionSuccessful();
                            this.zzagv.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzlf();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzagv.setTransactionSuccessful();
                    this.zzagv.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzlf();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzanp zzanp2) {
        long l = this.zzagD;
        zzanp zzanp3 = zzanp2;
        zzamu zzamu2 = this;
        zzl.zzjC();
        zzamu2.zzkD();
        long l2 = -1L;
        long l3 = zzamu2.zzky().zzlW();
        if (l3 != 0L) {
            l2 = Math.abs(zzamu2.zzkq().currentTimeMillis() - l3);
        }
        zzamu2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzamu2.zzla();
        try {
            zzamu2.zzlb();
            zzamu2.zzky().zzlX();
            zzamu2.zzld();
            if (zzanp3 != null) {
                zzanp3.zzc(null);
            }
            if (zzamu2.zzagD != l) {
                zzamu2.zzagx.zzlP();
            }
            return;
        }
        catch (Throwable throwable) {
            zzamu2.zze("Local dispatch failed", throwable);
            zzamu2.zzky().zzlX();
            zzamu2.zzld();
            if (zzanp3 != null) {
                zzanp3.zzc(throwable);
            }
            return;
        }
    }

    public final void zzlc() {
        zzl.zzjC();
        this.zzkD();
        this.zzbp("Sync dispatching local hits");
        long l = this.zzagD;
        this.zzla();
        try {
            this.zzlb();
            this.zzky().zzlX();
            this.zzld();
            if (this.zzagD != l) {
                this.zzagx.zzlP();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzld();
            return;
        }
    }

    private final long zzkT() {
        zzl.zzjC();
        this.zzkD();
        try {
            return this.zzagv.zzkT();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzld() {
        boolean bl;
        zzl.zzjC();
        this.zzkD();
        zzamu zzamu2 = this;
        if (!(!zzamu2.zzagE && zzamu2.zzlg() > 0L)) {
            this.zzagx.unregister();
            this.zzlf();
            return;
        }
        if (this.zzagv.isEmpty()) {
            this.zzagx.unregister();
            this.zzlf();
            return;
        }
        if (!zzanr.zzahN.get().booleanValue()) {
            this.zzagx.zzlN();
            bl = this.zzagx.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzamu2 = this;
            zzamu2.zzle();
            long l3 = zzamu2.zzlg();
            long l4 = zzamu2.zzky().zzlW();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzamu2.zzkq().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzanj.zzlq(), l3)) : Math.min(zzanj.zzlq(), l3);
            zzamu2.zza("Dispatch scheduled (ms)", l5);
            if (zzamu2.zzagA.zzbo()) {
                l = Math.max(1L, l5 + zzamu2.zzagA.zzlz());
                zzamu2.zzagA.zzt(l);
                return;
            }
            zzamu2.zzagA.zzs(l5);
            return;
        }
        this.zzlf();
        this.zzle();
    }

    private final void zzle() {
        long l;
        zzano zzano2 = this.zzkw();
        if (!zzano2.zzlC()) {
            return;
        }
        if (!zzano2.zzbo() && (l = this.zzkT()) != 0L && Math.abs(this.zzkq().currentTimeMillis() - l) <= zzanr.zzahr.get()) {
            long l2 = zzanj.zzlr();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzano2.schedule();
        }
    }

    private final void zzlf() {
        zzamu zzamu2 = this;
        if (zzamu2.zzagA.zzbo()) {
            zzamu2.zzbo("All hits dispatched or no network/service. Going to power save mode");
        }
        zzamu2.zzagA.cancel();
        zzano zzano2 = this.zzkw();
        if (zzano2.zzbo()) {
            zzano2.cancel();
        }
    }

    private final long zzlg() {
        if (this.zzagz != Long.MIN_VALUE) {
            return this.zzagz;
        }
        long l = zzanr.zzahm.get();
        zzaos zzaos2 = this.zzkx();
        zzaos2.zzkD();
        if (zzaos2.zzaiP) {
            zzaos2 = this.zzkx();
            zzaos2.zzkD();
            l = (long)zzaos2.zzahZ * 1000L;
        }
        return l;
    }

    public final void zzbw(String string) {
        zzbo.zzcF((String)string);
        zzl.zzjC();
        zzalk zzalk2 = zzaor.zza(this.zzkr(), string);
        if (zzalk2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzky().zzlY();
        if (string.equals(string2)) {
            this.zzbr("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzky().zzbz(string);
        if (this.zzky().zzlV().zzu(zzanj.zzly())) {
            this.zzd("Campaign received too late, ignoring", zzalk2);
            return;
        }
        this.zzb("Received installation campaign", zzalk2);
        for (zzaml zzaml2 : this.zzagv.zzq(0L)) {
            this.zza(zzaml2, zzalk2);
        }
    }

    private final void zza(zzaml zzaml2, zzalk zzalk2) {
        zzbo.zzu((Object)zzaml2);
        zzbo.zzu((Object)zzalk2);
        zza zza2 = new zza(this.zzkp());
        zza2.zzaY(zzaml2.zzkL());
        zza2.enableAdvertisingIdCollection(zzaml2.zzkM());
        zzi zzi2 = zza2.zzjj();
        zzals zzals2 = zzi2.zzb(zzals.class);
        zzals2.zzbj("data");
        zzals2.zzH(true);
        zzi2.zza(zzalk2);
        zzaln zzaln2 = zzi2.zzb(zzaln.class);
        zzalj zzalj2 = zzi2.zzb(zzalj.class);
        for (Map.Entry<String, String> entry : zzaml2.zzdV().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzalj2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzalj2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzalj2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzalj2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzals2.setUserId(string2);
                continue;
            }
            zzaln2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzaml2.zzkL(), zzalk2);
        zzi2.zzl(this.zzky().zzlU());
        zzi2.zzjt();
    }

    private final void zzlh() {
        this.zzkD();
        zzl.zzjC();
        this.zzagE = true;
        this.zzagy.disconnect();
        this.zzld();
    }

    static /* synthetic */ void zza(zzamu zzamu2) {
        zzamu2.zzkY();
    }

    static /* synthetic */ void zzb(zzamu zzamu2) {
        zzamu2.zzkZ();
    }
}

