/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzalx;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzami;

class zzaoc
extends BroadcastReceiver {
    private static String zzaiq = zzaoc.class.getName();
    private final zzami zzafJ;
    private boolean mRegistered;
    private boolean zzair;

    zzaoc(zzami zzami2) {
        zzbo.zzu((Object)zzami2);
        this.zzafJ = zzami2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzlO();
        String string = intent.getAction();
        this.zzafJ.zzkr().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzlQ();
            if (this.zzair != bl) {
                this.zzair = bl;
                boolean bl2 = bl;
                zzalx zzalx2 = this.zzafJ.zzkv();
                zzalx2.zza("Network connectivity status changed", bl2);
                zzalx2.zzkt().zzf(new zzalz(zzalx2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzaiq)) {
                zzalx zzalx3 = this.zzafJ.zzkv();
                zzalx3.zzbo("Radio powered up");
                zzalx3.zzkl();
            }
            return;
        }
        this.zzafJ.zzkr().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzlN() {
        this.zzlO();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzafJ.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzair = this.zzlQ();
        this.zzafJ.zzkr().zza("Registering connectivity change receiver. Network connected", this.zzair);
        this.mRegistered = true;
    }

    private final void zzlO() {
        this.zzafJ.zzkr();
        this.zzafJ.zzkv();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzafJ.zzkr().zzbo("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzair = false;
        Context context = this.zzafJ.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzafJ.zzkr().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzlP() {
        Context context = this.zzafJ.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzaiq, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzafJ.zzkr().zzbr("Connectivity unknown. Receiver not registered");
        }
        return this.zzair;
    }

    private final boolean zzlQ() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzafJ.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

