/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzamg;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzami;
import com.google.android.gms.internal.zzamz;
import com.google.android.gms.internal.zzanf;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzanr;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzaoe;
import com.google.android.gms.internal.zzaon;
import com.google.android.gms.internal.zzaor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

final class zzaod
extends zzamg {
    private final String zzJR;
    private final zzaon zzais;
    private static final byte[] zzait = "\n".getBytes();

    zzaod(zzami zzami2) {
        super(zzami2);
        String string = Build.ID;
        String string2 = Build.MODEL;
        String string3 = zzaor.zza(Locale.getDefault());
        String string4 = Build.VERSION.RELEASE;
        String string5 = zzamh.VERSION;
        String string6 = "GoogleAnalytics";
        this.zzJR = String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string6, string5, string4, string3, string2, string);
        this.zzais = new zzaon(zzami2.zzkq());
    }

    @Override
    protected final void zzjD() {
        this.zza("Network initialized. User agent", this.zzJR);
    }

    public final boolean zzlQ() {
        zzl.zzjC();
        this.zzkD();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {}
        if (networkInfo == null || !networkInfo.isConnected()) {
            this.zzbo("No network connectivity");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final List<Long> zzu(List<zzanw> var1_1) {
        block9: {
            zzl.zzjC();
            this.zzkD();
            zzbo.zzu(var1_1);
            if (!this.zzks().zzlx().isEmpty() && this.zzais.zzu((long)zzanr.zzahG.get().intValue() * 1000L)) break block9;
            var2_2 = false;
            ** GOTO lbl-1000
        }
        v0 = var2_2 = zzamz.zzbx(zzanr.zzahz.get()) != zzamz.zzagG;
        if (zzanf.zzby(zzanr.zzahA.get()) == zzanf.zzagR) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = var3_3 = false;
        }
        if (var2_2) {
            var6_4 = var3_3;
            var5_5 = var1_1;
            var4_6 = this;
            zzbo.zzaf((boolean)(var5_5.isEmpty() == false));
            var4_6.zza("Uploading batched hits. compression, count", var6_4, var5_5.size());
            var7_7 = new zzaoe(var4_6);
            var8_8 = new ArrayList<Long>();
            for (zzanw var10_10 : var5_5) {
                if (!var7_7.zze(var10_10)) break;
                var8_8.add(var10_10.zzlF());
            }
            if (var7_7.zzlT() == 0) {
                return var8_8;
            }
            var9_9 = var4_6.zzlR();
            if (var9_9 == null) {
                var4_6.zzbs("Failed to build batching endpoint url");
            } else {
                var10_11 = var6_4 != false ? var4_6.zzb(var9_9, var7_7.getPayload()) : var4_6.zza(var9_9, var7_7.getPayload());
                if (200 == var10_11) {
                    var4_6.zza("Batched upload completed. Hits batched", var7_7.zzlT());
                    return var8_8;
                }
                var4_6.zza("Network error uploading hits. status code", var10_11);
                if (var4_6.zzks().zzlx().contains(var10_11)) {
                    var4_6.zzbr("Server instructed the client to stop batching");
                    var4_6.zzais.start();
                }
            }
            return Collections.emptyList();
        }
        return this.zzv(var1_1);
    }

    /*
     * Unable to fully structure code
     */
    private final List<Long> zzv(List<zzanw> var1_1) {
        var2_2 = new ArrayList<Long>(var1_1.size());
        var3_3 = var1_1.iterator();
        while (var3_3.hasNext()) {
            block4: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                block6: {
                                    block3: {
                                        var6_6 = var4_4 = var3_3.next();
                                        var5_5 = this;
                                        zzbo.zzu((Object)var6_6);
                                        var7_7 = var5_5.zza(var6_6, var6_6.zzlI() == false);
                                        if (var7_7 != null) break block3;
                                        var5_5.zzkr().zza(var6_6, "Error formatting hit for upload");
                                        v0 = true;
                                        break block4;
                                    }
                                    if (var7_7.length() > zzanr.zzahy.get()) break block5;
                                    var8_8 = var5_5.zzb(var6_6, var7_7);
                                    if (var8_8 != null) break block6;
                                    var5_5.zzbs("Failed to build collect GET endpoint url");
                                    ** GOTO lbl-1000
                                }
                                v0 = var5_5.zza((URL)var8_8) == 200;
                                break block4;
                            }
                            var7_7 = var5_5.zza(var6_6, false);
                            if (var7_7 != null) break block7;
                            var5_5.zzkr().zza(var6_6, "Error formatting hit for POST upload");
                            v0 = true;
                            break block4;
                        }
                        v1 = var7_7.getBytes();
                        var8_8 = v1;
                        if (v1.length <= zzanr.zzahD.get()) break block8;
                        var5_5.zzkr().zza(var6_6, "Hit payload exceeds size limit");
                        v0 = true;
                        break block4;
                    }
                    var9_9 = var5_5.zzd(var6_6);
                    if (var9_9 != null) break block9;
                    var5_5.zzbs("Failed to build collect POST endpoint url");
                    ** GOTO lbl-1000
                }
                if (var5_5.zza(var9_9, (byte[])var8_8) == 200) {
                    v0 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v0 = false;
                }
            }
            if (!v0) break;
            var2_2.add(var4_4.zzlF());
            if (var2_2.size() < zzanj.zzls()) continue;
        }
        return var2_2;
    }

    private final int zza(URL uRL) {
        zzbo.zzu((Object)uRL);
        this.zzb("GET request", uRL);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.connect();
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzkv().zzko();
            }
            this.zzb("GET status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network GET connection error", iOException);
            return 0;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private final int zza(URL uRL, byte[] byArray) {
        zzbo.zzu((Object)uRL);
        zzbo.zzu((Object)byArray);
        this.zzb("POST bytes, url", byArray.length, uRL);
        if (zzaod.zzhM()) {
            this.zza("Post payload\n", new String(byArray));
        }
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzkv().zzko();
            }
            this.zzb("POST status", n);
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private final int zzb(URL uRL, byte[] byArray) {
        zzbo.zzu((Object)uRL);
        zzbo.zzu((Object)byArray);
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            this.getContext().getPackageName();
            byte[] byArray2 = byArray;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray2);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            this.zza("POST compressed size, ratio %, url", byArray3.length, 100L * (long)byArray3.length / (long)byArray.length, uRL);
            if (byArray3.length > byArray.length) {
                this.zzc("Compressed payload is larger then uncompressed. compressed, uncompressed", byArray3.length, byArray.length);
            }
            if (zzaod.zzhM()) {
                String string = String.valueOf(new String(byArray));
                this.zza("Post payload", string.length() != 0 ? "\n".concat(string) : new String("\n"));
            }
            httpURLConnection = this.zzb(uRL);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
            httpURLConnection.setFixedLengthStreamingMode(byArray3.length);
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray3);
            outputStream.close();
            outputStream = null;
            this.zzb(httpURLConnection);
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                this.zzkv().zzko();
            }
            this.zzb("POST status", n);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return n;
        }
        catch (IOException iOException) {
            this.zzd("Network compressed POST connection error", iOException);
            return 0;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Error closing http compressed post connection output stream", iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zzb(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray) > 0) {
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                this.zze("Error closing http connection input stream", iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            this.zze("Error closing http connection input stream", iOException);
            return;
        }
    }

    private final HttpURLConnection zzb(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            throw new IOException("Failed to obtain http connection");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setConnectTimeout(zzanr.zzahI.get());
        httpURLConnection.setReadTimeout(zzanr.zzahJ.get());
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("User-Agent", this.zzJR);
        httpURLConnection.setDoInput(true);
        return httpURLConnection;
    }

    private final URL zzd(zzanw zzanw2) {
        String string;
        if (zzanw2.zzlI()) {
            String string2 = String.valueOf(zzanj.zzlu());
            String string3 = String.valueOf(zzanj.zzlw());
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            String string4 = String.valueOf(zzanj.zzlv());
            String string5 = String.valueOf(zzanj.zzlw());
            string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private final URL zzb(zzanw zzanw2, String string) {
        String string2;
        String string3;
        if (zzanw2.zzlI()) {
            string3 = String.valueOf(zzanj.zzlu());
            String string4 = String.valueOf(zzanj.zzlw());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string).length()).append(string3).append(string4).append("?").append(string).toString();
        } else {
            string3 = String.valueOf(zzanj.zzlv());
            String string5 = String.valueOf(zzanj.zzlw());
            string2 = new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string5).length() + String.valueOf(string).length()).append(string3).append(string5).append("?").append(string).toString();
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    private final URL zzlR() {
        String string = String.valueOf(zzanj.zzlu());
        String string2 = String.valueOf(zzanr.zzahx.get());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        try {
            return new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            this.zze("Error trying to parse the hardcoded host url", malformedURLException);
            return null;
        }
    }

    final String zza(zzanw zzanw2, boolean bl) {
        zzbo.zzu((Object)zzanw2);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : zzanw2.zzdV().entrySet()) {
                String string = entry.getKey();
                if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string) || "z".equals(string) || "_gmsv".equals(string)) continue;
                zzaod.zza(stringBuilder, string, entry.getValue());
            }
            zzaod.zza(stringBuilder, "ht", String.valueOf(zzanw2.zzlG()));
            long l = this.zzkq().currentTimeMillis() - zzanw2.zzlG();
            zzaod.zza(stringBuilder, "qt", String.valueOf(l));
            if (bl) {
                long l2 = zzanw2.zzlJ();
                String string = l2 != 0L ? String.valueOf(l2) : String.valueOf(zzanw2.zzlF());
                zzaod.zza(stringBuilder, "z", string);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.zze("Failed to encode name or value", unsupportedEncodingException);
            return null;
        }
    }

    private static void zza(StringBuilder stringBuilder, String string, String string2) throws UnsupportedEncodingException {
        if (stringBuilder.length() != 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(URLEncoder.encode(string, "UTF-8"));
        stringBuilder.append('=');
        stringBuilder.append(URLEncoder.encode(string2, "UTF-8"));
    }

    static /* synthetic */ byte[] zzlS() {
        return zzait;
    }
}

