/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzanc;
import com.google.android.gms.internal.zzand;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzanb
extends zzamh {
    private volatile String zzafd;
    private Future<String> zzagN;

    protected zzanb(zzamj zzamj2) {
        super(zzamj2);
    }

    @Override
    protected final void zzjD() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzli() {
        this.zzkD();
        zzanb zzanb2 = this;
        synchronized (zzanb2) {
            if (this.zzafd == null) {
                this.zzagN = this.zzkt().zzd(new zzanc(this));
            }
            if (this.zzagN != null) {
                try {
                    this.zzafd = this.zzagN.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzafd = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzafd = "0";
                }
                if (this.zzafd == null) {
                    this.zzafd = "0";
                }
                this.zza("Loaded clientId", this.zzafd);
                this.zzagN = null;
            }
            return this.zzafd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzlj() {
        zzanb zzanb2 = this;
        synchronized (zzanb2) {
            this.zzafd = null;
            this.zzagN = this.zzkt().zzd(new zzand(this));
        }
        return this.zzli();
    }

    final String zzlk() {
        String string = this.zzag(this.zzkt().getContext());
        if (string == null) {
            string = this.zzll();
        }
        return string;
    }

    private final String zzll() {
        String string = UUID.randomUUID().toString().toLowerCase();
        try {
            if (!this.zzv(this.zzkt().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzag(Context context) {
        zzbo.zzcG((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzbr("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzbr("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzv(Context context, String string) {
        zzbo.zzcF((String)string);
        zzbo.zzcG((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzanb zzanb2) {
        return zzanb2.zzll();
    }
}

