/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzalv;
import com.google.android.gms.internal.zzaly;
import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzanc;
import com.google.android.gms.internal.zzang;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzani;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzanu;
import com.google.android.gms.internal.zzanw;
import com.google.android.gms.internal.zzanz;
import com.google.android.gms.internal.zzaoa;
import com.google.android.gms.internal.zzaoc;
import com.google.android.gms.internal.zzaoh;
import com.google.android.gms.internal.zzaon;
import com.google.android.gms.internal.zzaoo;
import com.google.android.gms.internal.zzaot;
import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzaoy;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzapd;
import com.google.android.gms.internal.zzbdp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzanf
extends zzamr {
    private boolean mStarted;
    private final zzanc zzdpu;
    private final zzaoo zzdpv;
    private final zzaon zzdpw;
    private final zzamx zzdpx;
    private long zzdpy;
    private final zzanw zzdpz;
    private final zzanw zzdqa;
    private final zzaoy zzdqb;
    private long zzdqc;
    private boolean zzdqd;

    protected zzanf(zzamt zzamt2, zzamv zzamv2) {
        super(zzamt2);
        zzbp.zzu((Object)zzamv2);
        this.zzdpy = Long.MIN_VALUE;
        zzamt zzamt3 = zzamt2;
        this.zzdpw = new zzaon(zzamt3);
        zzamt3 = zzamt2;
        this.zzdpu = new zzanc(zzamt3);
        zzamt3 = zzamt2;
        this.zzdpv = new zzaoo(zzamt3);
        zzamt3 = zzamt2;
        this.zzdpx = new zzamx(zzamt3);
        this.zzdqb = new zzaoy(this.zzvu());
        this.zzdpz = new zzang(this, zzamt2);
        this.zzdqa = new zzanh(this, zzamt2);
    }

    @Override
    protected final void zzuh() {
        this.zzdpu.initialize();
        this.zzdpv.initialize();
        this.zzdpx.initialize();
    }

    final void start() {
        this.zzwh();
        zzbp.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzvx().zzc(new zzani(this));
    }

    private final boolean zzdu(String string) {
        return zzbdp.zzcs((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzxb() {
        this.zzwh();
        zzanf zzanf2 = this;
        zzl.zzug();
        Context context = zzanf2.zzvt().getContext();
        if (!zzaot.zzbf(context)) {
            zzanf2.zzdq("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzaou.zzbg(context)) {
            zzanf2.zzdr("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzbf(context)) {
            zzanf2.zzdq("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!CampaignTrackingService.zzbg(context)) {
            zzanf2.zzdq("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzwc().zzyy();
        if (!this.zzdu("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzdr("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzxl();
        }
        if (!this.zzdu("android.permission.INTERNET")) {
            this.zzdr("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzxl();
        }
        if (zzaou.zzbg(this.getContext())) {
            this.zzdn("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzdq("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzdqd && !this.zzdpu.isEmpty()) {
            this.zzxe();
        }
        this.zzxh();
    }

    private final void zzxc() {
        this.zzb(new zzanj(this));
    }

    final void zzvs() {
        zzl.zzug();
        this.zzdqc = this.zzvu().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzl.zzug();
        zzanf zzanf2 = this;
        zzl.zzug();
        zzanf2.zzwh();
        if (!zzanu.zzxs()) {
            zzanf2.zzdq("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzanf2.zzdpx.isConnected()) {
            zzanf2.zzdn("Service not connected");
            return;
        }
        if (!zzanf2.zzdpu.isEmpty()) {
            zzanf2.zzdn("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzaoh> list;
                try {
                    list = zzanf2.zzdpu.zzo(zzanu.zzxw());
                    if (list.isEmpty()) {
                        zzanf2.zzxh();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzanf2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzanf2.zzxj();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzaoh zzaoh2 = list.get(0);
                    if (!zzanf2.zzdpx.zzb(zzaoh2)) {
                        zzanf2.zzxh();
                        return;
                    }
                    list.remove(zzaoh2);
                    try {
                        zzanf2.zzdpu.zzp(zzaoh2.zzyj());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzanf2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzanf2.zzxj();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzxd() {
        try {
            this.zzdpu.zzww();
            this.zzxh();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzdqa.zzs(86400000L);
    }

    protected final void zzb(zzamw zzamw2) {
        zzl.zzug();
        this.zzb("Sending first hit to property", zzamw2.zzwp());
        if (this.zzwc().zzyz().zzu(zzanu.zzyc())) {
            return;
        }
        String string = this.zzwc().zzzc();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzalv zzalv2 = zzapc.zza(this.zzvv(), string);
        this.zzb("Found relevant installation campaign", zzalv2);
        this.zza(zzamw2, zzalv2);
    }

    public final void zzr(long l) {
        zzl.zzug();
        this.zzwh();
        if (l < 0L) {
            l = 0L;
        }
        this.zzdpy = l;
        this.zzxh();
    }

    private final void zzxe() {
        if (this.zzdqd) {
            return;
        }
        if (!zzanu.zzxs()) {
            return;
        }
        if (this.zzdpx.isConnected()) {
            return;
        }
        long l = zzaoc.zzdsr.get();
        if (this.zzdqb.zzu(l)) {
            this.zzdqb.start();
            this.zzdn("Connecting to service");
            if (this.zzdpx.connect()) {
                this.zzdn("Connected to service");
                this.zzdqb.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzamw zzamw2, boolean bl) {
        long l;
        zzbp.zzu((Object)zzamw2);
        this.zzwh();
        zzl.zzug();
        try {
            this.zzdpu.beginTransaction();
            String string = zzamw2.zzvb();
            long l2 = zzamw2.zzwo();
            zzanc zzanc2 = this.zzdpu;
            zzbp.zzgf((String)string);
            zzanc2.zzwh();
            zzl.zzug();
            int n = zzanc2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzanc2.zza("Deleted property records", n);
            }
            l = this.zzdpu.zza(zzamw2.zzwo(), zzamw2.zzvb(), zzamw2.zzwp());
            zzamw2.zzm(l + 1L);
            zzamw zzamw3 = zzamw2;
            zzanc zzanc3 = this.zzdpu;
            zzbp.zzu((Object)zzamw3);
            zzanc3.zzwh();
            zzl.zzug();
            SQLiteDatabase sQLiteDatabase = zzanc3.getWritableDatabase();
            Map<String, String> map = zzamw3.zzix();
            zzbp.zzu(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzamw3.zzwo()));
            contentValues.put("cid", zzamw3.zzvb());
            contentValues.put("tid", zzamw3.zzwp());
            contentValues.put("adid", Integer.valueOf(zzamw3.zzwq() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzamw3.zzwr()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzanc3.zzdr("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzanc3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzdpu.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzdpu.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzaoh zzaoh2) {
        zzaoh zzaoh3;
        zzbp.zzu((Object)zzaoh2);
        zzl.zzug();
        this.zzwh();
        if (this.zzdqd) {
            this.zzdo("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzaoh2);
        }
        zzaoh zzaoh4 = zzaoh2;
        zzanf zzanf2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzaoh4.zzyo())) {
            zzaoh3 = zzaoh4;
        } else {
            Pair<String, Long> pair = zzanf2.zzwc().zzzd().zzzf();
            if (pair == null) {
                zzaoh3 = zzaoh4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzaoh4.zzix());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzaoh zzaoh5 = zzaoh4;
                zzanf zzanf3 = zzanf2;
                zzaoh3 = new zzaoh(zzanf3, (Map<String, String>)object2, zzaoh5.zzyk(), zzaoh5.zzym(), zzaoh5.zzyj(), zzaoh5.zzyi(), zzaoh5.zzyl());
            }
        }
        zzaoh2 = zzaoh3;
        this.zzxe();
        if (this.zzdpx.zzb(zzaoh2)) {
            this.zzdo("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzdpu.zzc(zzaoh2);
            this.zzxh();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzvv().zza(zzaoh2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzvo() {
        zzl.zzug();
        this.zzwh();
        this.zzdn("Delete all hits from local store");
        try {
            zzanc zzanc2 = this.zzdpu;
            zzl.zzug();
            zzanc2.zzwh();
            zzanc2.getWritableDatabase().delete("hits2", null, null);
            zzanc2 = this.zzdpu;
            zzl.zzug();
            zzanc2.zzwh();
            zzanc2.getWritableDatabase().delete("properties", null, null);
            this.zzxh();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzxe();
        if (this.zzdpx.zzws()) {
            this.zzdn("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzxf() {
        boolean bl;
        zzl.zzug();
        this.zzwh();
        this.zzdn("Dispatching a batch of local hits");
        boolean bl2 = !this.zzdpx.isConnected();
        boolean bl3 = bl = !this.zzdpv.zzyu();
        if (bl2 && bl) {
            this.zzdn("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzanu.zzxw(), zzanu.zzxx());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzaoh> list;
                block38: {
                    this.zzdpu.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzdpu.zzo(l);
                        if (!list.isEmpty()) break block38;
                        this.zzdn("Store is empty, nothing to dispatch");
                        this.zzxj();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzxj();
                        try {
                            this.zzdpu.setTransactionSuccessful();
                            this.zzdpu.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzxj();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzyj() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzxj();
                    return false;
                }
                if (this.zzdpx.isConnected()) {
                    this.zzdn("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzdpx.zzb((zzaoh)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzaoh)((Object)list2)).zzyj());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzdpu.zzp(((zzaoh)((Object)list2)).zzyj());
                            arrayList.add(((zzaoh)((Object)list2)).zzyj());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzxj();
                            try {
                                this.zzdpu.setTransactionSuccessful();
                                this.zzdpu.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzxj();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzdpv.zzyu()) {
                    list2 = this.zzdpv.zzs(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzdpu.zzq(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzxj();
                        try {
                            this.zzdpu.setTransactionSuccessful();
                            this.zzdpu.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzxj();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzdpu.setTransactionSuccessful();
                    this.zzdpu.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzxj();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzaoa zzaoa2) {
        long l = this.zzdqc;
        zzaoa zzaoa3 = zzaoa2;
        zzanf zzanf2 = this;
        zzl.zzug();
        zzanf2.zzwh();
        long l2 = -1L;
        long l3 = zzanf2.zzwc().zzza();
        if (l3 != 0L) {
            l2 = Math.abs(zzanf2.zzvu().currentTimeMillis() - l3);
        }
        zzanf2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzanf2.zzxe();
        try {
            zzanf2.zzxf();
            zzanf2.zzwc().zzzb();
            zzanf2.zzxh();
            if (zzaoa3 != null) {
                zzaoa3.zzb(null);
            }
            if (zzanf2.zzdqc != l) {
                zzanf2.zzdpw.zzyt();
            }
            return;
        }
        catch (Throwable throwable) {
            zzanf2.zze("Local dispatch failed", throwable);
            zzanf2.zzwc().zzzb();
            zzanf2.zzxh();
            if (zzaoa3 != null) {
                zzaoa3.zzb(throwable);
            }
            return;
        }
    }

    public final void zzxg() {
        zzl.zzug();
        this.zzwh();
        this.zzdo("Sync dispatching local hits");
        long l = this.zzdqc;
        this.zzxe();
        try {
            this.zzxf();
            this.zzwc().zzzb();
            this.zzxh();
            if (this.zzdqc != l) {
                this.zzdpw.zzyt();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzxh();
            return;
        }
    }

    private final long zzwx() {
        zzl.zzug();
        this.zzwh();
        try {
            return this.zzdpu.zzwx();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzxh() {
        boolean bl;
        zzl.zzug();
        this.zzwh();
        zzanf zzanf2 = this;
        if (!(!zzanf2.zzdqd && zzanf2.zzxk() > 0L)) {
            this.zzdpw.unregister();
            this.zzxj();
            return;
        }
        if (this.zzdpu.isEmpty()) {
            this.zzdpw.unregister();
            this.zzxj();
            return;
        }
        if (!zzaoc.zzdsm.get().booleanValue()) {
            this.zzdpw.zzyr();
            bl = this.zzdpw.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzanf2 = this;
            zzanf2.zzxi();
            long l3 = zzanf2.zzxk();
            long l4 = zzanf2.zzwc().zzza();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzanf2.zzvu().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzanu.zzxu(), l3)) : Math.min(zzanu.zzxu(), l3);
            zzanf2.zza("Dispatch scheduled (ms)", l5);
            if (zzanf2.zzdpz.zzdp()) {
                l = Math.max(1L, l5 + zzanf2.zzdpz.zzyd());
                zzanf2.zzdpz.zzt(l);
                return;
            }
            zzanf2.zzdpz.zzs(l5);
            return;
        }
        this.zzxj();
        this.zzxi();
    }

    private final void zzxi() {
        long l;
        zzanz zzanz2 = this.zzwa();
        if (!zzanz2.zzyg()) {
            return;
        }
        if (!zzanz2.zzdp() && (l = this.zzwx()) != 0L && Math.abs(this.zzvu().currentTimeMillis() - l) <= zzaoc.zzdrq.get()) {
            long l2 = zzanu.zzxv();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzanz2.schedule();
        }
    }

    private final void zzxj() {
        zzanf zzanf2 = this;
        if (zzanf2.zzdpz.zzdp()) {
            zzanf2.zzdn("All hits dispatched or no network/service. Going to power save mode");
        }
        zzanf2.zzdpz.cancel();
        zzanz zzanz2 = this.zzwa();
        if (zzanz2.zzdp()) {
            zzanz2.cancel();
        }
    }

    private final long zzxk() {
        if (this.zzdpy != Long.MIN_VALUE) {
            return this.zzdpy;
        }
        long l = zzaoc.zzdrl.get();
        zzapd zzapd2 = this.zzwb();
        zzapd2.zzwh();
        if (zzapd2.zzduo) {
            zzapd2 = this.zzwb();
            zzapd2.zzwh();
            l = (long)zzapd2.zzdsy * 1000L;
        }
        return l;
    }

    public final void zzdv(String string) {
        zzbp.zzgf((String)string);
        zzl.zzug();
        zzalv zzalv2 = zzapc.zza(this.zzvv(), string);
        if (zzalv2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzwc().zzzc();
        if (string.equals(string2)) {
            this.zzdq("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzwc().zzdy(string);
        if (this.zzwc().zzyz().zzu(zzanu.zzyc())) {
            this.zzd("Campaign received too late, ignoring", zzalv2);
            return;
        }
        this.zzb("Received installation campaign", zzalv2);
        for (zzamw zzamw2 : this.zzdpu.zzq(0L)) {
            this.zza(zzamw2, zzalv2);
        }
    }

    private final void zza(zzamw zzamw2, zzalv zzalv2) {
        zzbp.zzu((Object)zzamw2);
        zzbp.zzu((Object)zzalv2);
        zza zza2 = new zza(this.zzvt());
        zza2.zzcx(zzamw2.zzwp());
        zza2.enableAdvertisingIdCollection(zzamw2.zzwq());
        zzi zzi2 = ((zzk)zza2).zzto();
        zzamd zzamd2 = zzi2.zzb(zzamd.class);
        zzamd2.zzdi("data");
        zzamd2.zzai(true);
        zzi2.zza(zzalv2);
        zzaly zzaly2 = zzi2.zzb(zzaly.class);
        zzalu zzalu2 = zzi2.zzb(zzalu.class);
        for (Map.Entry<String, String> entry : zzamw2.zzix().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzalu2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzalu2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzalu2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzalu2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzamd2.setUserId(string2);
                continue;
            }
            zzaly2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzamw2.zzwp(), zzalv2);
        zzi2.zzl(this.zzwc().zzyy());
        zzi2.zztx();
    }

    private final void zzxl() {
        this.zzwh();
        zzl.zzug();
        this.zzdqd = true;
        this.zzdpx.disconnect();
        this.zzxh();
    }

    static /* synthetic */ void zza(zzanf zzanf2) {
        zzanf2.zzxc();
    }

    static /* synthetic */ void zzb(zzanf zzanf2) {
        zzanf2.zzxd();
    }
}

