/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.internal.zzaom;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzdjr;
    private final Tracker zzdjs;
    private final Context mContext;
    private ExceptionParser zzdjt;
    private GoogleAnalytics zzdju;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzdjr = uncaughtExceptionHandler;
        this.zzdjs = tracker;
        this.zzdjt = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzaom.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzdjt;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzdjt = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzdjt != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzdjt.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzaom.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzdjs.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        ExceptionReporter exceptionReporter = this;
        if (exceptionReporter.zzdju == null) {
            exceptionReporter.zzdju = GoogleAnalytics.getInstance(exceptionReporter.mContext);
        }
        object = exceptionReporter.zzdju;
        ((GoogleAnalytics)object).dispatchLocalHits();
        Object object2 = object;
        ((zza)object2).zztr().zzwc().zzvt();
        if (this.zzdjr != null) {
            zzaom.v("Passing exception to the original handler");
            this.zzdjr.uncaughtException(thread, throwable);
        }
    }

    final Thread.UncaughtExceptionHandler zztv() {
        return this.zzdjr;
    }
}

