/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaom;
import com.google.android.gms.internal.zzapa;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzdjv = new ArrayList<Runnable>();
    private boolean zzaqe;
    private Set<zza> zzdjw = new HashSet<zza>();
    private boolean zzdjx;
    private boolean zzdjy;
    private volatile boolean zzdjz;
    private boolean zzdka;

    public final void initialize() {
        GoogleAnalytics googleAnalytics = this;
        zzape zzape2 = googleAnalytics.zztr().zzwe();
        zzape2.zzzn();
        if (zzape2.zzzo()) {
            googleAnalytics.setDryRun(zzape2.zzzp());
        }
        zzape2.zzzn();
        this.zzaqe = true;
    }

    public final boolean isInitialized() {
        return this.zzaqe;
    }

    public GoogleAnalytics(zzamu zzamu2) {
        super(zzamu2);
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public static GoogleAnalytics getInstance(Context context) {
        return zzamu.zzbg(context).zzwn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zztw() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzdjv != null) {
                Iterator<Runnable> iterator = zzdjv.iterator();
                while (iterator.hasNext()) {
                    iterator.next().run();
                }
                zzdjv = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public final void setDryRun(boolean bl) {
        this.zzdjy = bl;
    }

    public final boolean isDryRunEnabled() {
        return this.zzdjy;
    }

    @TargetApi(value=14)
    public final void enableAutoActivityReports(Application application) {
        if (!this.zzdjx) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb(this));
            this.zzdjx = true;
        }
    }

    public final void reportActivityStart(Activity activity) {
        if (!this.zzdjx) {
            this.zzj(activity);
        }
    }

    final void zzj(Activity activity) {
        Iterator<zza> iterator = this.zzdjw.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzl(activity);
        }
    }

    public final void reportActivityStop(Activity activity) {
        if (!this.zzdjx) {
            this.zzk(activity);
        }
    }

    final void zzk(Activity activity) {
        Iterator<zza> iterator = this.zzdjw.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzm(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(String string) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zztr(), string, null);
            tracker.initialize();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Tracker newTracker(int n) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzapc zzapc2;
            Tracker tracker = new Tracker(this.zztr(), null, null);
            if (n > 0 && (zzapc2 = (zzapc)new zzapa(this.zztr()).zzat(n)) != null) {
                tracker.zza(zzapc2);
            }
            tracker.initialize();
            return tracker;
        }
    }

    final void zza(zza zza2) {
        this.zzdjw.add(zza2);
        Context context = this.zztr().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    final void zzb(zza zza2) {
        this.zzdjw.remove(zza2);
    }

    public final void setAppOptOut(boolean bl) {
        this.zzdjz = bl;
        if (this.zzdjz) {
            this.zztr().zzwc().zzvr();
        }
    }

    public final boolean getAppOptOut() {
        return this.zzdjz;
    }

    @Deprecated
    public final Logger getLogger() {
        return zzaom.getLogger();
    }

    @Deprecated
    public final void setLogger(Logger logger) {
        zzaom.setLogger(logger);
        if (!this.zzdka) {
            String string = zzaod.zzdra.get();
            Log.i((String)zzaod.zzdra.get(), (String)new StringBuilder(112 + String.valueOf(string).length()).append("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag.").append(string).append(" DEBUG").toString());
            this.zzdka = true;
        }
    }

    public final void setLocalDispatchPeriod(int n) {
        this.zztr().zzwc().setLocalDispatchPeriod(n);
    }

    public final void dispatchLocalHits() {
        this.zztr().zzwc().zzvs();
    }

    @TargetApi(value=14)
    final class zzb
    implements Application.ActivityLifecycleCallbacks {
        private /* synthetic */ GoogleAnalytics zzdkb;

        zzb(GoogleAnalytics googleAnalytics) {
            this.zzdkb = googleAnalytics;
        }

        public final void onActivityStarted(Activity activity) {
            this.zzdkb.zzj(activity);
        }

        public final void onActivityStopped(Activity activity) {
            this.zzdkb.zzk(activity);
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
        }

        public final void onActivityResumed(Activity activity) {
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }
    }

    static interface zza {
        public void zzl(Activity var1);

        public void zzm(Activity var1);
    }
}

