/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzk;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzalv;
import com.google.android.gms.internal.zzama;
import com.google.android.gms.internal.zzapd;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzj {
    private static volatile zzj zzdkw;
    private final Context mContext;
    private final List<Object> zzdkx;
    private final zze zzdky;
    private final zza zzdkz;
    private volatile zzalv zzdla;
    private Thread.UncaughtExceptionHandler zzdlb;

    private zzj(Context context) {
        Context context2 = context.getApplicationContext();
        zzbp.zzu((Object)context2);
        this.mContext = context2;
        this.zzdkz = new zza();
        this.zzdkx = new CopyOnWriteArrayList<Object>();
        this.zzdky = new zze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzj zzbf(Context context) {
        zzbp.zzu((Object)context);
        if (zzdkw != null) return zzdkw;
        Class<zzj> clazz = zzj.class;
        synchronized (zzj.class) {
            if (zzdkw != null) return zzdkw;
            zzdkw = new zzj(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzdkw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzalv zzuh() {
        if (this.zzdla == null) {
            zzj zzj2 = this;
            synchronized (zzj2) {
                if (this.zzdla == null) {
                    zzalv zzalv2 = new zzalv();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzalv2.setAppId(string);
                    zzalv2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzalv2.setAppName(string2);
                    zzalv2.setAppVersion(string3);
                    this.zzdla = zzalv2;
                }
            }
        }
        return this.zzdla;
    }

    public final zzama zzui() {
        int n;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzama zzama2 = new zzama();
        zzama2.setLanguage(zzapd.zza(Locale.getDefault()));
        zzama2.zzcet = n = displayMetrics.widthPixels;
        zzama2.zzceu = n = displayMetrics.heightPixels;
        return zzama2;
    }

    final void zze(zzg zzg2) {
        if (zzg2.zzue()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzg2.zzub()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzg zzg3 = zzg2.zztx();
        zzg3.zzuc();
        this.zzdkz.execute(new zzk(this, zzg3));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public static void zzuj() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzdlb = uncaughtExceptionHandler;
    }

    public final <V> Future<V> zzc(Callable<V> callable) {
        zzbp.zzu(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzdkz.submit(callable);
    }

    public final void zzc(Runnable runnable) {
        zzbp.zzu((Object)runnable);
        this.zzdkz.submit(runnable);
    }

    private static void zzb(zzg zzg2) {
        zzbp.zzgh((String)"deliver should be called from worker thread");
        zzbp.zzb((boolean)zzg2.zzub(), (Object)"Measurement must be submitted");
        List<zzm> list = zzg2.getTransports();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzm zzm2 : list) {
            Uri uri = zzm2.zztu();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzm2.zzb(zzg2);
        }
    }

    static /* synthetic */ List zza(zzj zzj2) {
        return zzj2.zzdkx;
    }

    static /* synthetic */ void zza(zzj zzj2, zzg zzg2) {
        zzj.zzb(zzg2);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler zzb(zzj zzj2) {
        return zzj2.zzdlb;
    }

    static final class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzdlf = new AtomicInteger();

        private zzb() {
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            int n = zzdlf.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }

        /* synthetic */ zzb(zzk zzk2) {
            this();
        }
    }

    static final class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    final class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb(null));
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new zzl(this, runnable, t);
        }
    }
}

