/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzi;
import com.google.android.gms.analytics.zzj;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzalv;
import com.google.android.gms.internal.zzalw;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzand;
import com.google.android.gms.internal.zzanh;
import com.google.android.gms.internal.zzani;
import com.google.android.gms.internal.zzanj;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzanv;
import com.google.android.gms.internal.zzanx;
import com.google.android.gms.internal.zzaoa;
import com.google.android.gms.internal.zzaob;
import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzaoo;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaou;
import com.google.android.gms.internal.zzaov;
import com.google.android.gms.internal.zzaoz;
import com.google.android.gms.internal.zzapd;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzbed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class zzang
extends zzams {
    private boolean mStarted;
    private final zzand zzdpo;
    private final zzaop zzdpp;
    private final zzaoo zzdpq;
    private final zzamy zzdpr;
    private long zzdps;
    private final zzanx zzdpt;
    private final zzanx zzdpu;
    private final zzaoz zzdpv;
    private long zzdpw;
    private boolean zzdpx;

    protected zzang(zzamu zzamu2, zzamw zzamw2) {
        super(zzamu2);
        zzbp.zzu((Object)zzamw2);
        this.zzdps = Long.MIN_VALUE;
        zzamu zzamu3 = zzamu2;
        this.zzdpq = new zzaoo(zzamu3);
        zzamu3 = zzamu2;
        this.zzdpo = new zzand(zzamu3);
        zzamu3 = zzamu2;
        this.zzdpp = new zzaop(zzamu3);
        zzamu3 = zzamu2;
        this.zzdpr = new zzamy(zzamu3);
        this.zzdpv = new zzaoz(this.zzvx());
        this.zzdpt = new zzanh(this, zzamu2);
        this.zzdpu = new zzani(this, zzamu2);
    }

    @Override
    protected final void zzuk() {
        this.zzdpo.initialize();
        this.zzdpp.initialize();
        this.zzdpr.initialize();
    }

    final void start() {
        this.zzwk();
        zzbp.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        this.zzwa().zzc(new zzanj(this));
    }

    private final boolean zzdt(String string) {
        return zzbed.zzcr((Context)this.getContext()).checkCallingOrSelfPermission(string) == 0;
    }

    protected final void zzxe() {
        this.zzwk();
        zzang zzang2 = this;
        zzj.zzuj();
        Context context = zzang2.zzvw().getContext();
        if (!zzaou.zzbe(context)) {
            zzang2.zzdp("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else if (!zzaov.zzbi(context)) {
            zzang2.zzdq("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!CampaignTrackingReceiver.zzbe(context)) {
            zzang2.zzdp("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        }
        this.zzwf().zzzb();
        if (!this.zzdt("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzdq("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzxo();
        }
        if (!this.zzdt("android.permission.INTERNET")) {
            this.zzdq("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzxo();
        }
        if (zzaov.zzbi(this.getContext())) {
            this.zzdm("AnalyticsService registered in the app manifest and enabled");
        } else {
            this.zzdp("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!this.zzdpx && !this.zzdpo.isEmpty()) {
            this.zzxh();
        }
        this.zzxk();
    }

    private final void zzxf() {
        this.zzb(new zzank(this));
    }

    final void zzvv() {
        zzj.zzuj();
        this.zzdpw = this.zzvx().currentTimeMillis();
    }

    protected final void onServiceConnected() {
        zzj.zzuj();
        zzang zzang2 = this;
        zzj.zzuj();
        zzang2.zzwk();
        if (!zzanv.zzxv()) {
            zzang2.zzdp("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!zzang2.zzdpr.isConnected()) {
            zzang2.zzdm("Service not connected");
            return;
        }
        if (!zzang2.zzdpo.isEmpty()) {
            zzang2.zzdm("Dispatching local hits to device AnalyticsService");
            block4: while (true) {
                List<zzaoi> list;
                try {
                    list = zzang2.zzdpo.zzo(zzanv.zzxz());
                    if (list.isEmpty()) {
                        zzang2.zzxk();
                        return;
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzang2.zze("Failed to read hits from store", (Object)sQLiteException);
                    zzang2.zzxm();
                    return;
                }
                while (true) {
                    if (list.isEmpty()) continue block4;
                    zzaoi zzaoi2 = list.get(0);
                    if (!zzang2.zzdpr.zzb(zzaoi2)) {
                        zzang2.zzxk();
                        return;
                    }
                    list.remove(zzaoi2);
                    try {
                        zzang2.zzdpo.zzp(zzaoi2.zzym());
                    }
                    catch (SQLiteException sQLiteException) {
                        zzang2.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                        zzang2.zzxm();
                        return;
                    }
                }
                break;
            }
        }
    }

    private final void zzxg() {
        try {
            this.zzdpo.zzwz();
            this.zzxk();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzdpu.zzs(86400000L);
    }

    protected final void zzb(zzamx zzamx2) {
        zzj.zzuj();
        this.zzb("Sending first hit to property", zzamx2.zzws());
        if (this.zzwf().zzzc().zzu(zzanv.zzyf())) {
            return;
        }
        String string = this.zzwf().zzzf();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzalw zzalw2 = zzapd.zza(this.zzvy(), string);
        this.zzb("Found relevant installation campaign", zzalw2);
        this.zza(zzamx2, zzalw2);
    }

    public final void zzr(long l) {
        zzj.zzuj();
        this.zzwk();
        if (l < 0L) {
            l = 0L;
        }
        this.zzdps = l;
        this.zzxk();
    }

    private final void zzxh() {
        if (this.zzdpx) {
            return;
        }
        if (!zzanv.zzxv()) {
            return;
        }
        if (this.zzdpr.isConnected()) {
            return;
        }
        long l = zzaod.zzdsm.get();
        if (this.zzdpv.zzu(l)) {
            this.zzdpv.start();
            this.zzdm("Connecting to service");
            if (this.zzdpr.connect()) {
                this.zzdm("Connected to service");
                this.zzdpv.clear();
                this.onServiceConnected();
            }
        }
    }

    public final long zza(zzamx zzamx2, boolean bl) {
        long l;
        zzbp.zzu((Object)zzamx2);
        this.zzwk();
        zzj.zzuj();
        try {
            this.zzdpo.beginTransaction();
            String string = zzamx2.zzve();
            long l2 = zzamx2.zzwr();
            zzand zzand2 = this.zzdpo;
            zzbp.zzgg((String)string);
            zzand2.zzwk();
            zzj.zzuj();
            int n = zzand2.getWritableDatabase().delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l2), string});
            if (n > 0) {
                zzand2.zza("Deleted property records", n);
            }
            l = this.zzdpo.zza(zzamx2.zzwr(), zzamx2.zzve(), zzamx2.zzws());
            zzamx2.zzm(l + 1L);
            zzamx zzamx3 = zzamx2;
            zzand zzand3 = this.zzdpo;
            zzbp.zzu((Object)zzamx3);
            zzand3.zzwk();
            zzj.zzuj();
            SQLiteDatabase sQLiteDatabase = zzand3.getWritableDatabase();
            Map<String, String> map = zzamx3.zziy();
            zzbp.zzu(map);
            Uri.Builder builder = new Uri.Builder();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                String string2 = object2.getKey();
                builder.appendQueryParameter(string2, object2.getValue());
            }
            String string3 = builder.build().getEncodedQuery();
            String string4 = string3 == null ? "" : string3;
            ContentValues contentValues = new ContentValues();
            contentValues.put("app_uid", Long.valueOf(zzamx3.zzwr()));
            contentValues.put("cid", zzamx3.zzve());
            contentValues.put("tid", zzamx3.zzws());
            contentValues.put("adid", Integer.valueOf(zzamx3.zzwt() ? 1 : 0));
            contentValues.put("hits_count", Long.valueOf(zzamx3.zzwu()));
            contentValues.put("params", string4);
            try {
                if (sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5) == -1L) {
                    zzand3.zzdq("Failed to insert/update a property (got -1)");
                }
            }
            catch (SQLiteException sQLiteException) {
                zzand3.zze("Error storing a property", (Object)sQLiteException);
            }
            this.zzdpo.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            return -1L;
        }
        finally {
            try {
                this.zzdpo.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public final void zza(zzaoi zzaoi2) {
        zzaoi zzaoi3;
        zzbp.zzu((Object)zzaoi2);
        zzj.zzuj();
        this.zzwk();
        if (this.zzdpx) {
            this.zzdn("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzaoi2);
        }
        zzaoi zzaoi4 = zzaoi2;
        zzang zzang2 = this;
        if (!TextUtils.isEmpty((CharSequence)zzaoi4.zzyr())) {
            zzaoi3 = zzaoi4;
        } else {
            Pair<String, Long> pair = zzang2.zzwf().zzzg().zzzi();
            if (pair == null) {
                zzaoi3 = zzaoi4;
            } else {
                Long l = (Long)pair.second;
                String string = (String)pair.first;
                Object object = String.valueOf(l);
                String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(":").append(string).toString();
                object = new HashMap<String, String>(zzaoi4.zziy());
                object.put((String)"_m", (String)string2);
                Object object2 = object;
                zzaoi zzaoi5 = zzaoi4;
                zzang zzang3 = zzang2;
                zzaoi3 = new zzaoi(zzang3, (Map<String, String>)object2, zzaoi5.zzyn(), zzaoi5.zzyp(), zzaoi5.zzym(), zzaoi5.zzyl(), zzaoi5.zzyo());
            }
        }
        zzaoi2 = zzaoi3;
        this.zzxh();
        if (this.zzdpr.zzb(zzaoi2)) {
            this.zzdn("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        try {
            this.zzdpo.zzc(zzaoi2);
            this.zzxk();
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zzvy().zza(zzaoi2, "deliver: failed to insert hit to database");
            return;
        }
    }

    public final void zzvr() {
        zzj.zzuj();
        this.zzwk();
        this.zzdm("Delete all hits from local store");
        try {
            zzand zzand2 = this.zzdpo;
            zzj.zzuj();
            zzand2.zzwk();
            zzand2.getWritableDatabase().delete("hits2", null, null);
            zzand2 = this.zzdpo;
            zzj.zzuj();
            zzand2.zzwk();
            zzand2.getWritableDatabase().delete("properties", null, null);
            this.zzxk();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete hits from store", (Object)sQLiteException);
        }
        this.zzxh();
        if (this.zzdpr.zzwv()) {
            this.zzdm("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    private final boolean zzxi() {
        boolean bl;
        zzj.zzuj();
        this.zzwk();
        this.zzdm("Dispatching a batch of local hits");
        boolean bl2 = !this.zzdpr.isConnected();
        boolean bl3 = bl = !this.zzdpp.zzyx();
        if (bl2 && bl) {
            this.zzdm("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(zzanv.zzxz(), zzanv.zzya());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                List<zzaoi> list;
                block38: {
                    this.zzdpo.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzdpo.zzo(l);
                        if (!list.isEmpty()) break block38;
                        this.zzdm("Store is empty, nothing to dispatch");
                        this.zzxm();
                        return false;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzxm();
                        try {
                            this.zzdpo.setTransactionSuccessful();
                            this.zzdpo.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzxm();
                            return false;
                        }
                        return false;
                    }
                }
                this.zza("Hits loaded from store. count", list.size());
                List<Long> list2 = list.iterator();
                while (list2.hasNext()) {
                    if (list2.next().zzym() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzxm();
                    return false;
                }
                if (this.zzdpr.isConnected()) {
                    this.zzdm("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzdpr.zzb((zzaoi)((Object)(list2 = list.get(0))))) {
                        l2 = Math.max(l2, ((zzaoi)((Object)list2)).zzym());
                        list.remove(list2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", list2);
                        try {
                            this.zzdpo.zzp(((zzaoi)((Object)list2)).zzym());
                            arrayList.add(((zzaoi)((Object)list2)).zzym());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzxm();
                            try {
                                this.zzdpo.setTransactionSuccessful();
                                this.zzdpo.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzxm();
                                return false;
                            }
                            return false;
                        }
                    }
                }
                if (this.zzdpp.zzyx()) {
                    list2 = this.zzdpp.zzs(list);
                    for (Long l3 : list2) {
                        l2 = Math.max(l2, l3);
                    }
                    try {
                        this.zzdpo.zzq(list2);
                        arrayList.addAll(list2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzxm();
                        try {
                            this.zzdpo.setTransactionSuccessful();
                            this.zzdpo.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzxm();
                            return false;
                        }
                        return false;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                return false;
            }
            finally {
                try {
                    this.zzdpo.setTransactionSuccessful();
                    this.zzdpo.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzxm();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public final void zzb(zzaob zzaob2) {
        long l = this.zzdpw;
        zzaob zzaob3 = zzaob2;
        zzang zzang2 = this;
        zzj.zzuj();
        zzang2.zzwk();
        long l2 = -1L;
        long l3 = zzang2.zzwf().zzzd();
        if (l3 != 0L) {
            l2 = Math.abs(zzang2.zzvx().currentTimeMillis() - l3);
        }
        zzang2.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
        zzang2.zzxh();
        try {
            zzang2.zzxi();
            zzang2.zzwf().zzze();
            zzang2.zzxk();
            if (zzaob3 != null) {
                zzaob3.zzb(null);
            }
            if (zzang2.zzdpw != l) {
                zzang2.zzdpq.zzyw();
            }
            return;
        }
        catch (Throwable throwable) {
            zzang2.zze("Local dispatch failed", throwable);
            zzang2.zzwf().zzze();
            zzang2.zzxk();
            if (zzaob3 != null) {
                zzaob3.zzb(throwable);
            }
            return;
        }
    }

    public final void zzxj() {
        zzj.zzuj();
        this.zzwk();
        this.zzdn("Sync dispatching local hits");
        long l = this.zzdpw;
        this.zzxh();
        try {
            this.zzxi();
            this.zzwf().zzze();
            this.zzxk();
            if (this.zzdpw != l) {
                this.zzdpq.zzyw();
            }
            return;
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzxk();
            return;
        }
    }

    private final long zzxa() {
        zzj.zzuj();
        this.zzwk();
        try {
            return this.zzdpo.zzxa();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public final void zzxk() {
        boolean bl;
        zzj.zzuj();
        this.zzwk();
        zzang zzang2 = this;
        if (!(!zzang2.zzdpx && zzang2.zzxn() > 0L)) {
            this.zzdpq.unregister();
            this.zzxm();
            return;
        }
        if (this.zzdpo.isEmpty()) {
            this.zzdpq.unregister();
            this.zzxm();
            return;
        }
        if (!zzaod.zzdsh.get().booleanValue()) {
            this.zzdpq.zzyu();
            bl = this.zzdpq.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            long l;
            long l2;
            zzang2 = this;
            zzang2.zzxl();
            long l3 = zzang2.zzxn();
            long l4 = zzang2.zzwf().zzzd();
            long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(zzang2.zzvx().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(zzanv.zzxx(), l3)) : Math.min(zzanv.zzxx(), l3);
            zzang2.zza("Dispatch scheduled (ms)", l5);
            if (zzang2.zzdpt.zzdp()) {
                l = Math.max(1L, l5 + zzang2.zzdpt.zzyg());
                zzang2.zzdpt.zzt(l);
                return;
            }
            zzang2.zzdpt.zzs(l5);
            return;
        }
        this.zzxm();
        this.zzxl();
    }

    private final void zzxl() {
        long l;
        zzaoa zzaoa2 = this.zzwd();
        if (!zzaoa2.zzyj()) {
            return;
        }
        if (!zzaoa2.zzdp() && (l = this.zzxa()) != 0L && Math.abs(this.zzvx().currentTimeMillis() - l) <= zzaod.zzdrl.get()) {
            long l2 = zzanv.zzxy();
            this.zza("Dispatch alarm scheduled (ms)", l2);
            zzaoa2.schedule();
        }
    }

    private final void zzxm() {
        zzang zzang2 = this;
        if (zzang2.zzdpt.zzdp()) {
            zzang2.zzdm("All hits dispatched or no network/service. Going to power save mode");
        }
        zzang2.zzdpt.cancel();
        zzaoa zzaoa2 = this.zzwd();
        if (zzaoa2.zzdp()) {
            zzaoa2.cancel();
        }
    }

    private final long zzxn() {
        if (this.zzdps != Long.MIN_VALUE) {
            return this.zzdps;
        }
        long l = zzaod.zzdrg.get();
        zzape zzape2 = this.zzwe();
        zzape2.zzwk();
        if (zzape2.zzdum) {
            zzape2 = this.zzwe();
            zzape2.zzwk();
            l = (long)zzape2.zzdst * 1000L;
        }
        return l;
    }

    public final void zzdu(String string) {
        zzbp.zzgg((String)string);
        zzj.zzuj();
        zzalw zzalw2 = zzapd.zza(this.zzvy(), string);
        if (zzalw2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zzwf().zzzf();
        if (string.equals(string2)) {
            this.zzdp("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zzwf().zzdx(string);
        if (this.zzwf().zzzc().zzu(zzanv.zzyf())) {
            this.zzd("Campaign received too late, ignoring", zzalw2);
            return;
        }
        this.zzb("Received installation campaign", zzalw2);
        for (zzamx zzamx2 : this.zzdpo.zzq(0L)) {
            this.zza(zzamx2, zzalw2);
        }
    }

    private final void zza(zzamx zzamx2, zzalw zzalw2) {
        zzbp.zzu((Object)zzamx2);
        zzbp.zzu((Object)zzalw2);
        zza zza2 = new zza(this.zzvw());
        zza2.zzcw(zzamx2.zzws());
        zza2.enableAdvertisingIdCollection(zzamx2.zzwt());
        zzg zzg2 = ((zzi)zza2).zzts();
        zzame zzame2 = zzg2.zzb(zzame.class);
        zzame2.zzdh("data");
        zzame2.zzai(true);
        zzg2.zza(zzalw2);
        zzalz zzalz2 = zzg2.zzb(zzalz.class);
        zzalv zzalv2 = zzg2.zzb(zzalv.class);
        for (Map.Entry<String, String> entry : zzamx2.zziy().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzalv2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzalv2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzalv2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzalv2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzame2.setUserId(string2);
                continue;
            }
            zzalz2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzamx2.zzws(), zzalw2);
        zzg2.zzl(this.zzwf().zzzb());
        zzg2.zzua();
    }

    private final void zzxo() {
        this.zzwk();
        zzj.zzuj();
        this.zzdpx = true;
        this.zzdpr.disconnect();
        this.zzxk();
    }

    static /* synthetic */ void zza(zzang zzang2) {
        zzang2.zzxf();
    }

    static /* synthetic */ void zzb(zzang zzang2) {
        zzang2.zzxg();
    }
}

