/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzano;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzanm
extends zzams {
    private volatile String zzdmw;
    private Future<String> zzdqg;

    protected zzanm(zzamu zzamu2) {
        super(zzamu2);
    }

    @Override
    protected final void zzuk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzxp() {
        this.zzwk();
        zzanm zzanm2 = this;
        synchronized (zzanm2) {
            if (this.zzdmw == null) {
                this.zzdqg = this.zzwa().zzc(new zzann(this));
            }
            if (this.zzdqg != null) {
                try {
                    this.zzdmw = this.zzdqg.get();
                }
                catch (InterruptedException interruptedException) {
                    this.zzd("ClientId loading or generation was interrupted", interruptedException);
                    this.zzdmw = "0";
                }
                catch (ExecutionException executionException) {
                    this.zze("Failed to load or generate client id", executionException);
                    this.zzdmw = "0";
                }
                if (this.zzdmw == null) {
                    this.zzdmw = "0";
                }
                this.zza("Loaded clientId", this.zzdmw);
                this.zzdqg = null;
            }
            return this.zzdmw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzxq() {
        zzanm zzanm2 = this;
        synchronized (zzanm2) {
            this.zzdmw = null;
            this.zzdqg = this.zzwa().zzc(new zzano(this));
        }
        return this.zzxp();
    }

    final String zzxr() {
        String string = this.zzbh(this.zzwa().getContext());
        if (string == null) {
            string = this.zzxs();
        }
        return string;
    }

    private final String zzxs() {
        String string = UUID.randomUUID().toString().toLowerCase();
        try {
            if (!this.zzu(this.zzwa().getContext(), string)) {
                return "0";
            }
        }
        catch (Exception exception) {
            this.zze("Error saving clientId file", exception);
            return "0";
        }
        return string;
    }

    private final String zzbh(Context context) {
        zzbp.zzgh((String)"ClientId should be loaded from worker thread");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = context.openFileInput("gaClientId");
            byte[] byArray = new byte[36];
            int n = fileInputStream.read(byArray, 0, 36);
            if (fileInputStream.available() > 0) {
                this.zzdp("clientId file seems corrupted, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            if (n < 14) {
                this.zzdp("clientId file is empty, deleting it.");
                fileInputStream.close();
                context.deleteFile("gaClientId");
                return null;
            }
            fileInputStream.close();
            String string = new String(byArray, 0, n);
            this.zza("Read client id from disk", string);
            String string2 = string;
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            this.zze("Error reading client id file, deleting it", iOException);
            context.deleteFile("gaClientId");
            return null;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close client id reading stream", iOException);
                }
            }
        }
    }

    private final boolean zzu(Context context, String string) {
        zzbp.zzgg((String)string);
        zzbp.zzgh((String)"ClientId should be saved from worker thread");
        FileOutputStream fileOutputStream = null;
        try {
            this.zza("Storing clientId", string);
            fileOutputStream = context.openFileOutput("gaClientId", 0);
            fileOutputStream.write(string.getBytes());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zze("Error creating clientId file", fileNotFoundException);
            return false;
        }
        catch (IOException iOException) {
            this.zze("Error writing to clientId file", iOException);
            return false;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.zze("Failed to close clientId writing stream", iOException);
                }
            }
        }
    }

    static /* synthetic */ String zza(zzanm zzanm2) {
        return zzanm2.zzxs();
    }
}

