/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamu;

class zzaoo
extends BroadcastReceiver {
    private static String zzdti = zzaoo.class.getName();
    private final zzamu zzdoc;
    private boolean mRegistered;
    private boolean zzdtj;

    zzaoo(zzamu zzamu2) {
        zzbp.zzu((Object)zzamu2);
        this.zzdoc = zzamu2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzyv();
        String string = intent.getAction();
        this.zzdoc.zzvy().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzyx();
            if (this.zzdtj != bl) {
                this.zzdtj = bl;
                boolean bl2 = bl;
                zzamj zzamj2 = this.zzdoc.zzwc();
                zzamj2.zza("Network connectivity status changed", bl2);
                zzamj2.zzwa().zzc(new zzaml(zzamj2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzdti)) {
                zzamj zzamj3 = this.zzdoc.zzwc();
                zzamj3.zzdm("Radio powered up");
                zzamj3.zzvs();
            }
            return;
        }
        this.zzdoc.zzvy().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzyu() {
        this.zzyv();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzdoc.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzdtj = this.zzyx();
        this.zzdoc.zzvy().zza("Registering connectivity change receiver. Network connected", this.zzdtj);
        this.mRegistered = true;
    }

    private final void zzyv() {
        this.zzdoc.zzvy();
        this.zzdoc.zzwc();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzdoc.zzvy().zzdm("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzdtj = false;
        Context context = this.zzdoc.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzdoc.zzvy().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzyw() {
        Context context = this.zzdoc.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzdti, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzdoc.zzvy().zzdp("Connectivity unknown. Receiver not registered");
        }
        return this.zzdtj;
    }

    private final boolean zzyx() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzdoc.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

