/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzamu;
import com.google.android.gms.internal.zzanv;

public final class zzaoa
extends zzams {
    private boolean zzdqv;
    private boolean zzdqw;
    private final AlarmManager zzdqx = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzdqy;

    protected zzaoa(zzamu zzamu2) {
        super(zzamu2);
    }

    @Override
    protected final void zzuk() {
        try {
            ActivityInfo activityInfo;
            this.cancel();
            if (zzanv.zzxy() > 0L && (activityInfo = this.getContext().getPackageManager().getReceiverInfo(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"), 2)) != null && activityInfo.enabled) {
                this.zzdm("Receiver registered for local dispatch.");
                this.zzdqv = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzyj() {
        return this.zzdqv;
    }

    public final boolean zzdp() {
        return this.zzdqw;
    }

    public final void schedule() {
        this.zzwk();
        zzbp.zza((boolean)this.zzdqv, (Object)"Receiver not registered");
        long l = zzanv.zzxy();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzvx().elapsedRealtime() + l;
            this.zzdqw = true;
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzdm("Scheduling upload with JobScheduler");
                long l3 = l;
                zzaoa zzaoa2 = this;
                ComponentName componentName = new ComponentName(zzaoa2.getContext(), "com.google.android.gms.analytics.AnalyticsJobService");
                JobScheduler jobScheduler = (JobScheduler)zzaoa2.getContext().getSystemService("jobscheduler");
                JobInfo.Builder builder = new JobInfo.Builder(zzaoa2.getJobId(), componentName);
                builder.setMinimumLatency(l3);
                builder.setOverrideDeadline(l3 << 1);
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                builder.setExtras(persistableBundle);
                JobInfo jobInfo = builder.build();
                zzaoa2.zza("Scheduling job. JobID", zzaoa2.getJobId());
                jobScheduler.schedule(jobInfo);
                return;
            }
            this.zzdm("Scheduling upload with AlarmManager");
            this.zzdqx.setInexactRepeating(2, l2, l, this.zzyk());
        }
    }

    private final PendingIntent zzyk() {
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzdqw = false;
        this.zzdqx.cancel(this.zzyk());
        if (Build.VERSION.SDK_INT >= 24) {
            zzaoa zzaoa2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzaoa2.getContext().getSystemService("jobscheduler");
            zzaoa2.zza("Cancelling job. JobID", zzaoa2.getJobId());
            jobScheduler.cancel(zzaoa2.getJobId());
        }
    }

    private final int getJobId() {
        if (this.zzdqy == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzdqy = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzdqy;
    }
}

