/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamu;

class zzaoo
extends BroadcastReceiver {
    private static String zzdtj = zzaoo.class.getName();
    private final zzamu zzdod;
    private boolean mRegistered;
    private boolean zzdtk;

    zzaoo(zzamu zzamu2) {
        zzbp.zzu((Object)zzamu2);
        this.zzdod = zzamu2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzyv();
        String string = intent.getAction();
        this.zzdod.zzvy().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzyx();
            if (this.zzdtk != bl) {
                this.zzdtk = bl;
                boolean bl2 = bl;
                zzamj zzamj2 = this.zzdod.zzwc();
                zzamj2.zza("Network connectivity status changed", bl2);
                zzamj2.zzwa().zzc(new zzaml(zzamj2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzdtj)) {
                zzamj zzamj3 = this.zzdod.zzwc();
                zzamj3.zzdm("Radio powered up");
                zzamj3.zzvs();
            }
            return;
        }
        this.zzdod.zzvy().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzyu() {
        this.zzyv();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzdod.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzdtk = this.zzyx();
        this.zzdod.zzvy().zza("Registering connectivity change receiver. Network connected", this.zzdtk);
        this.mRegistered = true;
    }

    private final void zzyv() {
        this.zzdod.zzvy();
        this.zzdod.zzwc();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzdod.zzvy().zzdm("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzdtk = false;
        Context context = this.zzdod.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzdod.zzvy().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzyw() {
        Context context = this.zzdod.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzdtj, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzdod.zzvy().zzdp("Connectivity unknown. Receiver not registered");
        }
        return this.zzdtk;
    }

    private final boolean zzyx() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzdod.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

