/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaor;
import com.google.android.gms.internal.zzaqk;
import com.google.android.gms.internal.zzaqr;
import com.google.android.gms.internal.zzaqt;
import com.google.android.gms.internal.zzara;
import com.google.android.gms.internal.zzcwr;

public final class zzaqs<T extends Context> {
    private final Handler mHandler;
    private final T zzdvw;
    private static Boolean zzdvx;

    public zzaqs(T t) {
        zzbq.checkNotNull(t);
        this.zzdvw = t;
        this.mHandler = new Handler();
    }

    public static boolean zzbm(Context context) {
        zzbq.checkNotNull((Object)context);
        if (zzdvx != null) {
            return zzdvx;
        }
        boolean bl = zzara.zzt(context, "com.google.android.gms.analytics.AnalyticsService");
        zzdvx = bl;
        return bl;
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onCreate() {
        zzaor.zzbk(this.zzdvw).zzwi().zzdn("Local AnalyticsService is starting up");
    }

    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final void onDestroy() {
        zzaor.zzbk(this.zzdvw).zzwi().zzdn("Local AnalyticsService is shutting down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"})
    public final int onStartCommand(Intent intent, int n, int n2) {
        try {
            Object object = zzaqr.sLock;
            synchronized (object) {
                zzcwr zzcwr2 = zzaqr.zzdvv;
                if (zzcwr2 != null && zzcwr2.isHeld()) {
                    zzcwr2.release();
                }
            }
        }
        catch (SecurityException securityException) {}
        zzaqk zzaqk2 = zzaor.zzbk(this.zzdvw).zzwi();
        if (intent == null) {
            zzaqk2.zzdq("AnalyticsService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzaqk2.zza("Local AnalyticsService called. startId, action", n2, string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzaor zzaor2 = zzaor.zzbk(this.zzdvw);
        zzaqk zzaqk2 = zzaor2.zzwi();
        zzaor2.zzwm().zza(new zzaqt(this, n, zzaor2, zzaqk2, jobParameters));
    }

    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzaqk zzaqk2 = zzaor.zzbk(this.zzdvw).zzwi();
        String string = jobParameters.getExtras().getString("action");
        zzaqk2.zza("Local AnalyticsJobService called. action", (Object)string);
        if ("com.google.android.gms.analytics.ANALYTICS_DISPATCH".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    static /* synthetic */ Context zza(zzaqs zzaqs2) {
        return zzaqs2.zzdvw;
    }

    static /* synthetic */ Handler zzb(zzaqs zzaqs2) {
        return zzaqs2.mHandler;
    }
}

