/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzm;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.internal.zzaqk;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class zzara {
    private static final char[] zzdwl = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Map<String, String> zzea(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split("&");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split("=", 3);
            if (stringArray2.length > 1) {
                hashMap.put(stringArray2[0], TextUtils.isEmpty((CharSequence)stringArray2[1]) ? null : stringArray2[1]);
                if (stringArray2.length != 3 || TextUtils.isEmpty((CharSequence)stringArray2[1]) || hashMap.containsKey(stringArray2[1])) continue;
                hashMap.put(stringArray2[1], TextUtils.isEmpty((CharSequence)stringArray2[2]) ? null : stringArray2[2]);
                continue;
            }
            if (stringArray2.length != 1 || stringArray2[0].length() == 0) continue;
            hashMap.put(stringArray2[0], null);
        }
        return hashMap;
    }

    public static double zza(String string, double d) {
        if (string == null) {
            return 100.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 100.0;
        }
    }

    public static long zzeb(String string) {
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static boolean zzd(String string, boolean bl) {
        if (string != null) {
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1")) {
                return true;
            }
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("0")) {
                return false;
            }
        }
        return true;
    }

    public static String zzaj(boolean bl) {
        if (bl) {
            return "1";
        }
        return "0";
    }

    public static String zzec(String string) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        if (string.contains("?") && ((String[])(object = string.split("[\\?]"))).length > 1) {
            string2 = object[1];
        }
        if (string2.contains("%3D")) {
            try {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        } else if (!string2.contains("=")) {
            return null;
        }
        object = zzara.zzea(string2);
        String[] stringArray = new String[]{"dclid", "utm_source", "gclid", "aclid", "utm_campaign", "utm_medium", "utm_term", "utm_content", "utm_id", "anid", "gmob_t"};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 11; ++i) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)object.get(stringArray[i])))) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(stringArray[i]).append("=").append((String)object.get(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static zzant zza(zzaqk zzaqk2, String string) {
        Map map;
        zzbq.checkNotNull((Object)zzaqk2);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        new HashMap();
        try {
            String string2 = String.valueOf(string);
            map = zzm.zza((URI)new URI(string2.length() != 0 ? "?".concat(string2) : new String("?")), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            zzaqk2.zzd("No valid campaign data found", uRISyntaxException);
            return null;
        }
        zzant zzant2 = new zzant();
        zzant2.zzdc((String)map.get("utm_content"));
        zzant2.zzda((String)map.get("utm_medium"));
        zzant2.setName((String)map.get("utm_campaign"));
        zzant2.zzcz((String)map.get("utm_source"));
        zzant2.zzdb((String)map.get("utm_term"));
        zzant2.zzdd((String)map.get("utm_id"));
        zzant2.zzde((String)map.get("anid"));
        zzant2.zzdf((String)map.get("gclid"));
        zzant2.zzdg((String)map.get("dclid"));
        zzant2.zzdh((String)map.get("aclid"));
        return zzant2;
    }

    public static String zza(Locale locale) {
        if (locale == null) {
            return null;
        }
        String string = locale.getLanguage();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.toLowerCase());
        if (!TextUtils.isEmpty((CharSequence)locale.getCountry())) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    public static void zzb(Map<String, String> map, String string, String string2) {
        if (string2 != null && !map.containsKey(string)) {
            map.put(string, string2);
        }
    }

    public static void zzc(Map<String, String> map, String string, String string2) {
        if (string2 != null && TextUtils.isEmpty((CharSequence)map.get(string))) {
            map.put(string, string2);
        }
    }

    public static void zzb(Map<String, String> map, String string, boolean bl) {
        if (!map.containsKey(string)) {
            map.put(string, bl ? "1" : "0");
        }
    }

    public static void zza(Map<String, String> map, String string, Map<String, String> map2) {
        zzara.zzb(map, string, map2.get(string));
    }

    public static MessageDigest zzed(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    public static boolean zza(double d, String string) {
        if (d <= 0.0 || d >= 100.0) {
            return false;
        }
        String string2 = string;
        int n = 1;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            n = 0;
            for (int i = string2.length() - 1; i >= 0; --i) {
                char c = string2.charAt(i);
                int n2 = (n = (n << 6 & 0xFFFFFFF) + c + (c << 14)) & 0xFE00000;
                n = n2 != 0 ? n ^ n2 >> 21 : n;
            }
        }
        return (double)(n % 10000) >= d * 100.0;
    }

    public static boolean zzee(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        return !string.startsWith("http:");
    }

    public static boolean zzb(Context context, String string, boolean bl) {
        try {
            ActivityInfo activityInfo = context.getPackageManager().getReceiverInfo(new ComponentName(context, string), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    public static boolean zzt(Context context, String string) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, string), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }
}

