/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.internal.zzaru;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zzdoq;
    private final Tracker zzdor;
    private final Context mContext;
    private ExceptionParser zzdos;
    private GoogleAnalytics zzdot;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zzdoq = uncaughtExceptionHandler;
        this.zzdor = tracker;
        this.zzdos = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzaru.v(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzdos;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzdos = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzdos != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzdos.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzaru.v(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzdor.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        ExceptionReporter exceptionReporter = this;
        if (exceptionReporter.zzdot == null) {
            exceptionReporter.zzdot = GoogleAnalytics.getInstance(exceptionReporter.mContext);
        }
        object = exceptionReporter.zzdot;
        ((GoogleAnalytics)object).dispatchLocalHits();
        Object object2 = object;
        ((zza)object2).zzum().zzwx().zzwo();
        if (this.zzdoq != null) {
            zzaru.v("Passing exception to the original handler");
            this.zzdoq.uncaughtException(thread, throwable);
        }
    }

    final Thread.UncaughtExceptionHandler zzuq() {
        return this.zzdoq;
    }
}

