/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzapq;
import com.google.android.gms.internal.zzapr;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqc;
import com.google.android.gms.internal.zzaqn;
import com.google.android.gms.internal.zzarh;
import com.google.android.gms.internal.zzart;
import com.google.android.gms.internal.zzarv;
import com.google.android.gms.internal.zzask;
import com.google.android.gms.internal.zzasl;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzaqa {
    private boolean zzdqg;
    private final Map<String, String> zzbsr = new HashMap<String, String>();
    private final Map<String, String> zzdqh = new HashMap<String, String>();
    private final zzart zzdqi;
    private final zza zzdqj;
    private ExceptionReporter zzdqk;
    private zzask zzdql;

    Tracker(zzaqc zzaqc2, String string, zzart zzart2) {
        super(zzaqc2);
        if (string != null) {
            this.zzbsr.put("&tid", string);
        }
        this.zzbsr.put("useSecure", "1");
        this.zzbsr.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzdqi = new zzart("tracking", this.zzws());
        this.zzdqj = new zza(this, zzaqc2);
    }

    @Override
    protected final void zzvf() {
        String string;
        this.zzdqj.initialize();
        String string2 = this.zzwz().zzvi();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzwz().zzvj()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzask zzask2) {
        String string;
        this.zzdu("Loading Tracker config values");
        this.zzdql = zzask2;
        if (this.zzdql.zzdom != null) {
            string = this.zzdql.zzdom;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzdql.zzdzd >= 0.0) {
            string = Double.toString(this.zzdql.zzdzd);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzdql.zzdze >= 0) {
            int n = this.zzdql.zzdze;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzdql.zzdzf != -1) {
            boolean bl = this.zzdql.zzdzf == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzdql.zzdzg != -1) {
            boolean bl = this.zzdql.zzdzg == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzdql.zzdzh == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzdqk != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzdqk = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzdqk);
                this.zzdu("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzdqk.zzuq());
                this.zzdu("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zzdqj.setSessionTimeout(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zzdqj.enableAutoActivityTracking(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbq.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzbq.checkNotNull(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzws().currentTimeMillis();
        if (this.zzww().getAppOptOut()) {
            this.zzdv("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzww().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzbsr, hashMap);
        Tracker.zzb(map, hashMap);
        boolean bl2 = zzasl.zzd(this.zzbsr.get("useSecure"), true);
        Tracker.zzc(this.zzdqh, hashMap);
        this.zzdqh.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzwt().zzf(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzwt().zzf(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zzdqg;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzbsr.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzbsr.put("&a", Integer.toString(n));
            }
        }
        this.zzwv().zzc(new zzn(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzxf();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzbsr.containsKey(string)) {
            return this.zzbsr.get(string);
        }
        if (string.equals("&ul")) {
            return zzasl.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzxb().zzyk();
        }
        if (string.equals("&sr")) {
            return this.zzxe().zzzd();
        }
        if (string.equals("&aid")) {
            return this.zzxd().zzxy().getAppId();
        }
        if (string.equals("&an")) {
            return this.zzxd().zzxy().zzvi();
        }
        if (string.equals("&av")) {
            return this.zzxd().zzxy().zzvj();
        }
        if (string.equals("&aiid")) {
            return this.zzxd().zzxy().zzvk();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbq.checkNotNull((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzbsr.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzasl.zzak(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zzdx("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzasl.zzak(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzdqh.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzdqh.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzdqh.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzdqh.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzdqh.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzdqh.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzdqh.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzdqh.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzdqh.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzdqh.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zzdqg = bl;
    }

    static /* synthetic */ zzapq zzb(Tracker tracker) {
        return tracker.zzxc();
    }

    static /* synthetic */ zzaqn zzc(Tracker tracker) {
        return tracker.zzxd();
    }

    static /* synthetic */ zzarh zzd(Tracker tracker) {
        return tracker.zzxe();
    }

    static /* synthetic */ zzarh zze(Tracker tracker) {
        return tracker.zzxe();
    }

    static /* synthetic */ zzart zzf(Tracker tracker) {
        return tracker.zzdqi;
    }

    static /* synthetic */ zzarv zzg(Tracker tracker) {
        return tracker.zzwt();
    }

    static /* synthetic */ zzarv zzh(Tracker tracker) {
        return tracker.zzwt();
    }

    static /* synthetic */ zzapr zzi(Tracker tracker) {
        return tracker.zzwx();
    }

    static /* synthetic */ zzapr zzj(Tracker tracker) {
        return tracker.zzwx();
    }

    final class zza
    extends zzaqa
    implements GoogleAnalytics.zza {
        private boolean zzdqu;
        private int zzdqv;
        private long zzdqw;
        private boolean zzdqx;
        private long zzdqy;
        private /* synthetic */ Tracker zzdqt;

        protected zza(Tracker tracker, zzaqc zzaqc2) {
            this.zzdqt = tracker;
            super(zzaqc2);
            this.zzdqw = -1L;
        }

        @Override
        protected final void zzvf() {
        }

        public final void setSessionTimeout(long l) {
            this.zzdqw = l;
            this.zzvh();
        }

        public final void enableAutoActivityTracking(boolean bl) {
            this.zzdqu = bl;
            this.zzvh();
        }

        public final synchronized boolean zzvg() {
            boolean bl = this.zzdqx;
            this.zzdqx = false;
            return bl;
        }

        private final void zzvh() {
            if (this.zzdqw >= 0L || this.zzdqu) {
                this.zzww().zza(this.zzdqt.zzdqj);
                return;
            }
            this.zzww().zzb(this.zzdqt.zzdqj);
        }

        @Override
        public final void zzl(Activity activity) {
            zza zza2;
            if (this.zzdqv == 0 && (zza2 = this).zzws().elapsedRealtime() >= zza2.zzdqy + Math.max(1000L, zza2.zzdqw)) {
                this.zzdqx = true;
            }
            ++this.zzdqv;
            if (this.zzdqu) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzdqt.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzdqt.set("&cd", this.zzdqt.zzdql != null ? ((string2 = ((Tracker)this.zzdqt).zzdql.zzdzi.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbq.checkNotNull((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzdqt.send(hashMap);
            }
        }

        @Override
        public final void zzm(Activity activity) {
            --this.zzdqv;
            this.zzdqv = Math.max(0, this.zzdqv);
            if (this.zzdqv == 0) {
                this.zzdqy = this.zzws().elapsedRealtime();
            }
        }
    }
}

