/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzapd;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzapf;
import com.google.android.gms.internal.zzapg;
import com.google.android.gms.internal.zzaph;
import com.google.android.gms.internal.zzapi;
import com.google.android.gms.internal.zzapj;
import com.google.android.gms.internal.zzapk;
import com.google.android.gms.internal.zzapl;
import com.google.android.gms.internal.zzapm;
import com.google.android.gms.internal.zzapn;
import com.google.android.gms.internal.zzapo;
import com.google.android.gms.internal.zzapp;
import com.google.android.gms.internal.zzapz;
import com.google.android.gms.internal.zzaqb;
import com.google.android.gms.internal.zzaqc;
import com.google.android.gms.internal.zzaqf;
import com.google.android.gms.internal.zzarq;
import com.google.android.gms.internal.zzasl;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class zzb
extends zzapz
implements zzm {
    private static DecimalFormat zzdol;
    private final zzaqc zzdoh;
    private final String zzdom;
    private final Uri zzdon;

    public zzb(zzaqc zzaqc2, String string) {
        this(zzaqc2, string, true, false);
    }

    private zzb(zzaqc zzaqc2, String string, boolean bl, boolean bl2) {
        super(zzaqc2);
        zzbq.zzgm((String)string);
        this.zzdoh = zzaqc2;
        this.zzdom = string;
        this.zzdon = zzb.zzdf(this.zzdom);
    }

    static Uri zzdf(String string) {
        zzbq.zzgm((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzup() {
        return this.zzdon;
    }

    @Override
    public final void zzb(zzg zzg2) {
        zzbq.checkNotNull((Object)zzg2);
        zzbq.checkArgument((boolean)zzg2.zzuw(), (Object)"Can't deliver not submitted measurement");
        zzbq.zzgn((String)"deliver should be called on worker thread");
        zzg zzg3 = zzg2.zzus();
        zzapm zzapm2 = zzg3.zzb(zzapm.class);
        if (TextUtils.isEmpty((CharSequence)zzapm2.zzvy())) {
            this.zzwt().zzf(zzb.zzc(zzg3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzapm2.zzvz())) {
            this.zzwt().zzf(zzb.zzc(zzg3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzdoh.zzxi().getAppOptOut()) {
            return;
        }
        double d = zzapm2.zzwe();
        if (zzasl.zza(d, zzapm2.zzvz())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzg3);
        map.put("v", "1");
        map.put("_v", zzaqb.zzdtc);
        map.put("tid", this.zzdom);
        if (this.zzdoh.zzxi().isDryRunEnabled()) {
            Map<String, String> map2 = map;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
            String string = stringBuilder.toString();
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzasl.zzb(hashMap, "uid", zzapm2.getUserId());
        zzapd zzapd2 = zzg2.zza(zzapd.class);
        if (zzapd2 != null) {
            zzasl.zzb(hashMap, "an", zzapd2.zzvi());
            zzasl.zzb(hashMap, "aid", zzapd2.getAppId());
            zzasl.zzb(hashMap, "av", zzapd2.zzvj());
            zzasl.zzb(hashMap, "aiid", zzapd2.zzvk());
        }
        zzaqf zzaqf2 = new zzaqf(0L, zzapm2.zzvz(), this.zzdom, !TextUtils.isEmpty((CharSequence)zzapm2.zzwa()), 0L, hashMap);
        long l = this.zzwx().zza(zzaqf2);
        map.put("_s", String.valueOf(l));
        zzarq zzarq2 = new zzarq(this.zzwt(), map, zzg2.zzuu(), true);
        this.zzwx().zza(zzarq2);
    }

    private static Map<String, String> zzc(zzg zzg2) {
        zzapd zzapd2;
        zzapg zzapg2;
        Object object;
        Object object2;
        Object object3;
        zzapf zzapf2;
        zzapp zzapp2;
        zzapo zzapo2;
        zzapl zzapl2;
        zzape zzape2;
        zzapk zzapk2;
        Object object4;
        Object object5;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzaph zzaph2 = zzg2.zza(zzaph.class);
        if (zzaph2 != null) {
            object5 = zzaph2.zzvt().entrySet().iterator();
            while (object5.hasNext()) {
                Object object6;
                object4 = (Map.Entry)object5.next();
                Object v = object4.getValue();
                if ((v == null ? null : (v instanceof String ? (!TextUtils.isEmpty((CharSequence)(object6 = (String)v)) ? object6 : null) : (v instanceof Double ? ((Double)(object6 = (Double)v) != 0.0 ? zzb.zzb((Double)object6) : null) : (v instanceof Boolean ? (v != Boolean.FALSE ? "1" : null) : (zzapk2 = String.valueOf(v)))))) == null) continue;
                hashMap.put((String)object4.getKey(), (String)((Object)zzapk2));
            }
        }
        if ((object5 = zzg2.zza(zzapm.class)) != null) {
            zzb.zza(hashMap, "t", ((zzapm)object5).zzvy());
            zzb.zza(hashMap, "cid", ((zzapm)object5).zzvz());
            zzb.zza(hashMap, "uid", ((zzapm)object5).getUserId());
            zzb.zza(hashMap, "sc", ((zzapm)object5).zzwc());
            zzb.zza(hashMap, "sf", ((zzapm)object5).zzwe());
            zzb.zza(hashMap, "ni", ((zzapm)object5).zzwd());
            zzb.zza(hashMap, "adid", ((zzapm)object5).zzwa());
            zzb.zza(hashMap, "ate", ((zzapm)object5).zzwb());
        }
        if ((object4 = zzg2.zza(zzapn.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzapn)object4).zzwf());
            zzb.zza(hashMap, "a", ((zzapn)object4).zzwg());
            zzb.zza(hashMap, "dr", ((zzapn)object4).zzwh());
        }
        if ((zzapk2 = zzg2.zza(zzapk.class)) != null) {
            zzb.zza(hashMap, "ec", zzapk2.getCategory());
            zzb.zza(hashMap, "ea", zzapk2.getAction());
            zzb.zza(hashMap, "el", zzapk2.getLabel());
            zzb.zza(hashMap, "ev", zzapk2.getValue());
        }
        if ((zzape2 = zzg2.zza(zzape.class)) != null) {
            zzb.zza(hashMap, "cn", zzape2.getName());
            zzb.zza(hashMap, "cs", zzape2.getSource());
            zzb.zza(hashMap, "cm", zzape2.zzvl());
            zzb.zza(hashMap, "ck", zzape2.zzvm());
            zzb.zza(hashMap, "cc", zzape2.getContent());
            zzb.zza(hashMap, "ci", zzape2.getId());
            zzb.zza(hashMap, "anid", zzape2.zzvn());
            zzb.zza(hashMap, "gclid", zzape2.zzvo());
            zzb.zza(hashMap, "dclid", zzape2.zzvp());
            zzb.zza(hashMap, "aclid", zzape2.zzvq());
        }
        if ((zzapl2 = zzg2.zza(zzapl.class)) != null) {
            zzb.zza(hashMap, "exd", zzapl2.zzdrs);
            zzb.zza(hashMap, "exf", zzapl2.zzdrt);
        }
        if ((zzapo2 = zzg2.zza(zzapo.class)) != null) {
            zzb.zza(hashMap, "sn", zzapo2.zzdsh);
            zzb.zza(hashMap, "sa", zzapo2.zzdrp);
            zzb.zza(hashMap, "st", zzapo2.zzdsi);
        }
        if ((zzapp2 = zzg2.zza(zzapp.class)) != null) {
            zzb.zza(hashMap, "utv", zzapp2.zzdsj);
            zzb.zza(hashMap, "utt", zzapp2.zzdsk);
            zzb.zza(hashMap, "utc", zzapp2.mCategory);
            zzb.zza(hashMap, "utl", zzapp2.zzdrq);
        }
        if ((zzapf2 = zzg2.zza(zzapf.class)) != null) {
            object3 = zzapf2.zzvr().entrySet().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = zzd.zzaj(object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((zzapg2 = zzg2.zza(zzapg.class)) != null) {
            object2 = zzapg2.zzvs().entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = zzd.zzal((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzg2.zza(zzapj.class)) != null) {
            object2 = ((zzapj)object3).zzvu();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzapj)object3).zzvx()) {
                hashMap.putAll(promotion.zzdr(zzd.zzap(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzapj)object3).zzvv()) {
                hashMap.putAll(product.zzdr(zzd.zzan(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzapj)object3).zzvw().entrySet()) {
                List<Product> list = entry.getValue();
                String string = zzd.zzas(n);
                int n2 = 1;
                for (Product product : list) {
                    String string2 = String.valueOf(string);
                    String string3 = String.valueOf(zzd.zzaq(n2));
                    hashMap.putAll(product.zzdr(string3.length() != 0 ? string2.concat(string3) : new String(string2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf("nm");
                    hashMap.put(string5.length() != 0 ? string4.concat(string5) : new String(string4), entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzg2.zza(zzapi.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzapi)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzapi)object2).zzdrm);
            zzb.zza(hashMap, "sr", ((zzapi)object2).zzchl, ((zzapi)object2).zzchm);
            zzb.zza(hashMap, "vp", ((zzapi)object2).zzdrn, ((zzapi)object2).zzdro);
        }
        if ((zzapd2 = zzg2.zza(zzapd.class)) != null) {
            zzb.zza(hashMap, "an", zzapd2.zzvi());
            zzb.zza(hashMap, "aid", zzapd2.getAppId());
            zzb.zza(hashMap, "aiid", zzapd2.zzvk());
            zzb.zza(hashMap, "av", zzapd2.zzvj());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    private static String zzb(double d) {
        if (zzdol == null) {
            zzdol = new DecimalFormat("0.######");
        }
        return zzdol.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, new StringBuilder(23).append(n).append("x").append(n2).toString());
        }
    }
}

