/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqc;
import com.google.android.gms.internal.zzash;
import com.google.android.gms.internal.zzasl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public final class zzapq
extends zzaqa {
    private static boolean zzdsm;
    private AdvertisingIdClient.Info zzdsn;
    private final zzash zzdso;
    private String zzdsp;
    private boolean zzdsq = false;
    private final Object zzdsr = new Object();

    zzapq(zzaqc zzaqc2) {
        super(zzaqc2);
        this.zzdso = new zzash(zzaqc2.zzws());
    }

    @Override
    protected final void zzvf() {
    }

    public final boolean zzwb() {
        this.zzxf();
        AdvertisingIdClient.Info info = this.zzwj();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public final String zzwi() {
        this.zzxf();
        AdvertisingIdClient.Info info = this.zzwj();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private final synchronized AdvertisingIdClient.Info zzwj() {
        if (this.zzdso.zzu(1000L)) {
            this.zzdso.start();
            AdvertisingIdClient.Info info = this.zzwk();
            if (this.zza(this.zzdsn, info)) {
                this.zzdsn = info;
            } else {
                this.zzdy("Failed to reset client id on adid change. Not using adid");
                this.zzdsn = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzdsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string2 = this.zzxb().zzyk();
        Object object = this.zzdsr;
        synchronized (object) {
            String string3;
            if (!this.zzdsq) {
                this.zzdsp = this.zzwl();
                this.zzdsq = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzdsp)) {
                string3 = info == null ? null : info.getId();
                if (string3 == null) {
                    String string4 = String.valueOf(string);
                    String string5 = String.valueOf(string2);
                    return this.zzdt(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                }
                String string6 = String.valueOf(string3);
                String string7 = String.valueOf(string2);
                this.zzdsp = zzapq.zzds(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            }
            String string8 = String.valueOf(string);
            String string9 = String.valueOf(string2);
            string3 = zzapq.zzds(string9.length() != 0 ? string8.concat(string9) : new String(string8));
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return false;
            }
            if (string3.equals(this.zzdsp)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzdsp)) {
                this.zzdu("Resetting the client id because Advertising Id changed.");
                string2 = this.zzxb().zzyl();
                this.zza("New client Id", string2);
            }
            String string10 = String.valueOf(string);
            String string11 = String.valueOf(string2);
            return this.zzdt(string11.length() != 0 ? string10.concat(string11) : new String(string10));
        }
    }

    private final AdvertisingIdClient.Info zzwk() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzdx("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzdsm) break block3;
                zzdsm = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzds(String string) {
        MessageDigest messageDigest = zzasl.zzek("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private final boolean zzdt(String string) {
        try {
            String string2 = zzapq.zzds(string);
            this.zzdu("Storing hashed adid.");
            FileOutputStream fileOutputStream = this.getContext().openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzdsp = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    private final String zzwl() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzdx("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzdu("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

