/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaqa;
import com.google.android.gms.internal.zzaqc;
import com.google.android.gms.internal.zzard;

public final class zzari
extends zzaqa {
    private boolean zzdvs;
    private boolean zzdvt;
    private final AlarmManager zzdvu = (AlarmManager)this.getContext().getSystemService("alarm");
    private Integer zzdvv;

    protected zzari(zzaqc zzaqc2) {
        super(zzaqc2);
    }

    @Override
    protected final void zzvf() {
        try {
            ActivityInfo activityInfo;
            this.cancel();
            if (zzard.zzyt() > 0L && (activityInfo = this.getContext().getPackageManager().getReceiverInfo(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"), 2)) != null && activityInfo.enabled) {
                this.zzdu("Receiver registered for local dispatch.");
                this.zzdvs = true;
            }
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
    }

    public final boolean zzze() {
        return this.zzdvs;
    }

    public final boolean zzdx() {
        return this.zzdvt;
    }

    public final void schedule() {
        this.zzxf();
        zzbq.zza((boolean)this.zzdvs, (Object)"Receiver not registered");
        long l = zzard.zzyt();
        if (l > 0L) {
            this.cancel();
            long l2 = this.zzws().elapsedRealtime() + l;
            this.zzdvt = true;
            if (Build.VERSION.SDK_INT >= 24) {
                this.zzdu("Scheduling upload with JobScheduler");
                long l3 = l;
                zzari zzari2 = this;
                ComponentName componentName = new ComponentName(zzari2.getContext(), "com.google.android.gms.analytics.AnalyticsJobService");
                JobScheduler jobScheduler = (JobScheduler)zzari2.getContext().getSystemService("jobscheduler");
                JobInfo.Builder builder = new JobInfo.Builder(zzari2.getJobId(), componentName);
                builder.setMinimumLatency(l3);
                builder.setOverrideDeadline(l3 << 1);
                PersistableBundle persistableBundle = new PersistableBundle();
                persistableBundle.putString("action", "com.google.android.gms.analytics.ANALYTICS_DISPATCH");
                builder.setExtras(persistableBundle);
                JobInfo jobInfo = builder.build();
                zzari2.zza("Scheduling job. JobID", zzari2.getJobId());
                jobScheduler.schedule(jobInfo);
                return;
            }
            this.zzdu("Scheduling upload with AlarmManager");
            this.zzdvu.setInexactRepeating(2, l2, l, this.zzzf());
        }
    }

    private final PendingIntent zzzf() {
        Intent intent = new Intent("com.google.android.gms.analytics.ANALYTICS_DISPATCH");
        intent.setComponent(new ComponentName(this.getContext(), "com.google.android.gms.analytics.AnalyticsReceiver"));
        return PendingIntent.getBroadcast((Context)this.getContext(), (int)0, (Intent)intent, (int)0);
    }

    public final void cancel() {
        this.zzdvt = false;
        this.zzdvu.cancel(this.zzzf());
        if (Build.VERSION.SDK_INT >= 24) {
            zzari zzari2 = this;
            JobScheduler jobScheduler = (JobScheduler)zzari2.getContext().getSystemService("jobscheduler");
            zzari2.zza("Cancelling job. JobID", zzari2.getJobId());
            jobScheduler.cancel(zzari2.getJobId());
        }
    }

    private final int getJobId() {
        if (this.zzdvv == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzdvv = (string.length() != 0 ? "analytics".concat(string) : new String("analytics")).hashCode();
        }
        return this.zzdvv;
    }
}

