/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzapr;
import com.google.android.gms.internal.zzapt;
import com.google.android.gms.internal.zzaqc;

class zzarw
extends BroadcastReceiver {
    private static String zzdyg = zzarw.class.getName();
    private final zzaqc zzdta;
    private boolean mRegistered;
    private boolean zzdyh;

    zzarw(zzaqc zzaqc2) {
        zzbq.checkNotNull((Object)zzaqc2);
        this.zzdta = zzaqc2;
    }

    public void onReceive(Context context, Intent intent) {
        this.zzzq();
        String string = intent.getAction();
        this.zzdta.zzwt().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzzs();
            if (this.zzdyh != bl) {
                this.zzdyh = bl;
                boolean bl2 = bl;
                zzapr zzapr2 = this.zzdta.zzwx();
                zzapr2.zza("Network connectivity status changed", bl2);
                zzapr2.zzwv().zzc(new zzapt(zzapr2, bl2));
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzdyg)) {
                zzapr zzapr3 = this.zzdta.zzwx();
                zzapr3.zzdu("Radio powered up");
                zzapr3.zzwn();
            }
            return;
        }
        this.zzdta.zzwt().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public final void zzzp() {
        this.zzzq();
        if (this.mRegistered) {
            return;
        }
        Context context = this.zzdta.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzdyh = this.zzzs();
        this.zzdta.zzwt().zza("Registering connectivity change receiver. Network connected", this.zzdyh);
        this.mRegistered = true;
    }

    private final void zzzq() {
        this.zzdta.zzwt();
        this.zzdta.zzwx();
    }

    public final void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.zzdta.zzwt().zzdu("Unregistering connectivity change receiver");
        this.mRegistered = false;
        this.zzdyh = false;
        Context context = this.zzdta.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzdta.zzwt().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final void zzzr() {
        Context context = this.zzdta.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzdyg, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public final boolean isConnected() {
        if (!this.mRegistered) {
            this.zzdta.zzwt().zzdx("Connectivity unknown. Receiver not registered");
        }
        return this.zzdyh;
    }

    private final boolean zzzs() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzdta.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

