/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.internal.zzatc;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler zza;
    private final Tracker zzb;
    private final Context zzc;
    private ExceptionParser zzd;
    private GoogleAnalytics zze;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.zza = uncaughtExceptionHandler;
        this.zzb = tracker;
        this.zzd = new StandardExceptionParser(context, new ArrayList<String>());
        this.zzc = context.getApplicationContext();
        String string = String.valueOf(uncaughtExceptionHandler == null ? "null" : uncaughtExceptionHandler.getClass().getName());
        zzatc.zza(string.length() != 0 ? "ExceptionReporter created, original handler is ".concat(string) : new String("ExceptionReporter created, original handler is "));
    }

    public ExceptionParser getExceptionParser() {
        return this.zzd;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.zzd = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Object object;
        String string = "UncaughtException";
        if (this.zzd != null) {
            object = thread != null ? thread.getName() : null;
            string = this.zzd.getDescription((String)object, throwable);
        }
        String string2 = String.valueOf(string);
        zzatc.zza(string2.length() != 0 ? "Reporting uncaught exception: ".concat(string2) : new String("Reporting uncaught exception: "));
        this.zzb.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        ExceptionReporter exceptionReporter = this;
        if (exceptionReporter.zze == null) {
            exceptionReporter.zze = GoogleAnalytics.getInstance(exceptionReporter.zzc);
        }
        object = exceptionReporter.zze;
        ((GoogleAnalytics)object).dispatchLocalHits();
        Object object2 = object;
        ((zza)object2).zza().zzh().zze();
        if (this.zza != null) {
            zzatc.zza("Passing exception to the original handler");
            this.zza.uncaughtException(thread, throwable);
        }
    }

    final Thread.UncaughtExceptionHandler zza() {
        return this.zza;
    }
}

