/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.zzp;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaqy;
import com.google.android.gms.internal.zzaqz;
import com.google.android.gms.internal.zzari;
import com.google.android.gms.internal.zzark;
import com.google.android.gms.internal.zzarv;
import com.google.android.gms.internal.zzasp;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzatt;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzari {
    private boolean zza;
    private final Map<String, String> zzb = new HashMap<String, String>();
    private final Map<String, String> zzc = new HashMap<String, String>();
    private final zzatb zzd;
    private final zza zze;
    private ExceptionReporter zzf;
    private zzats zzg;

    Tracker(zzark zzark2, String string, zzatb zzatb2) {
        super(zzark2);
        if (string != null) {
            this.zzb.put("&tid", string);
        }
        this.zzb.put("useSecure", "1");
        this.zzb.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzd = new zzatb("tracking", this.zzj());
        this.zze = new zza(this, zzark2);
    }

    @Override
    @Hide
    protected final void zza() {
        String string;
        this.zze.zzaa();
        String string2 = this.zzr().zzc();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzr().zzb()) != null) {
            this.set("&av", string);
        }
    }

    final void zza(zzats zzats2) {
        String string;
        this.zzb("Loading Tracker config values");
        this.zzg = zzats2;
        if (this.zzg.zza != null) {
            string = this.zzg.zza;
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzg.zzb >= 0.0) {
            string = Double.toString(this.zzg.zzb);
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzg.zzc >= 0) {
            int n = this.zzg.zzc;
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzg.zzd != -1) {
            boolean bl = this.zzg.zzd == 1;
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzg.zze != -1) {
            boolean bl = this.zzg.zze == 1;
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzg.zzf == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean bl) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzf != null == bl) {
                return;
            }
            if (bl) {
                Context context = this.zzk();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzf = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzf);
                this.zzb("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.setDefaultUncaughtExceptionHandler(this.zzf.zza());
                this.zzb("Uncaught exceptions will not be reported to Google Analytics");
            }
            return;
        }
    }

    public void setSessionTimeout(long l) {
        this.zze.zza(l * 1000L);
    }

    public void enableAutoActivityTracking(boolean bl) {
        this.zze.zza(bl);
    }

    private static String zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        if (!(string.startsWith("&") && string.length() >= 2)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zza(Map<String, String> map, Map<String, String> map2) {
        zzbq.zza(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzbq.zza(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zza(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> map) {
        long l = this.zzj().zza();
        if (this.zzo().getAppOptOut()) {
            this.zzc("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        boolean bl = this.zzo().isDryRunEnabled();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zza(this.zzb, hashMap);
        Tracker.zza(map, hashMap);
        boolean bl2 = zzatt.zza(this.zzb.get("useSecure"), true);
        Tracker.zzb(this.zzc, hashMap);
        this.zzc.clear();
        String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzl().zza(hashMap, "Missing hit type parameter");
            return;
        }
        String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzl().zza(hashMap, "Missing tracking id parameter");
            return;
        }
        boolean bl3 = this.zza;
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzb.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzb.put("&a", Integer.toString(n));
            }
        }
        this.zzn().zza(new zzp(this, hashMap, bl3, string, l, bl, bl2, string2));
    }

    public String get(String string) {
        this.zzz();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzb.containsKey(string)) {
            return this.zzb.get(string);
        }
        if (string.equals("&ul")) {
            return zzatt.zza(Locale.getDefault());
        }
        if (string.equals("&cid")) {
            return this.zzt().zzb();
        }
        if (string.equals("&sr")) {
            return this.zzw().zzc();
        }
        if (string.equals("&aid")) {
            return this.zzv().zzb().zzc();
        }
        if (string.equals("&an")) {
            return this.zzv().zzb().zza();
        }
        if (string.equals("&av")) {
            return this.zzv().zzb().zzb();
        }
        if (string.equals("&aiid")) {
            return this.zzv().zzb().zzd();
        }
        return null;
    }

    public void set(String string, String string2) {
        zzbq.zza((Object)string, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        this.zzb.put(string, string2);
    }

    public void setSampleRate(double d) {
        this.set("&sf", Double.toString(d));
    }

    public void setUseSecure(boolean bl) {
        this.set("useSecure", zzatt.zza(bl));
    }

    public void setScreenName(String string) {
        this.set("&cd", string);
    }

    public void setLocation(String string) {
        this.set("&dl", string);
    }

    public void setReferrer(String string) {
        this.set("&dr", string);
    }

    public void setPage(String string) {
        this.set("&dp", string);
    }

    public void setHostname(String string) {
        this.set("&dh", string);
    }

    public void setTitle(String string) {
        this.set("&dt", string);
    }

    public void setLanguage(String string) {
        this.set("&ul", string);
    }

    public void setEncoding(String string) {
        this.set("&de", string);
    }

    public void setScreenColors(String string) {
        this.set("&sd", string);
    }

    public void setScreenResolution(int n, int n2) {
        if (n < 0 && n2 < 0) {
            this.zze("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", new StringBuilder(23).append(n).append("x").append(n2).toString());
    }

    public void setViewportSize(String string) {
        this.set("&vp", string);
    }

    public void setClientId(String string) {
        this.set("&cid", string);
    }

    public void setAppName(String string) {
        this.set("&an", string);
    }

    public void setAppId(String string) {
        this.set("&aid", string);
    }

    public void setAppInstallerId(String string) {
        this.set("&aiid", string);
    }

    public void setAppVersion(String string) {
        this.set("&av", string);
    }

    public void setAnonymizeIp(boolean bl) {
        this.set("&aip", zzatt.zza(bl));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string2 = String.valueOf(string);
        Uri uri2 = Uri.parse((String)(string2.length() != 0 ? "http://hostname/?".concat(string2) : new String("http://hostname/?")));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzc.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzc.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzc.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzc.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzc.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzc.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzc.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzc.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzc.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzc.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean bl) {
        this.zza = bl;
    }

    static /* synthetic */ zzaqy zzb(Tracker tracker) {
        return tracker.zzu();
    }

    static /* synthetic */ zzarv zzc(Tracker tracker) {
        return tracker.zzv();
    }

    static /* synthetic */ zzasp zzd(Tracker tracker) {
        return tracker.zzw();
    }

    static /* synthetic */ zzasp zze(Tracker tracker) {
        return tracker.zzw();
    }

    static /* synthetic */ zzatb zzf(Tracker tracker) {
        return tracker.zzd;
    }

    static /* synthetic */ zzatd zzg(Tracker tracker) {
        return tracker.zzl();
    }

    static /* synthetic */ zzatd zzh(Tracker tracker) {
        return tracker.zzl();
    }

    static /* synthetic */ zzaqz zzi(Tracker tracker) {
        return tracker.zzp();
    }

    static /* synthetic */ zzaqz zzj(Tracker tracker) {
        return tracker.zzp();
    }

    final class zza
    extends zzari
    implements GoogleAnalytics.zza {
        private boolean zza;
        private int zzb;
        private long zzc;
        private boolean zzd;
        private long zze;
        private /* synthetic */ Tracker zzf;

        protected zza(Tracker tracker, zzark zzark2) {
            this.zzf = tracker;
            super(zzark2);
            this.zzc = -1L;
        }

        @Override
        protected final void zza() {
        }

        public final void zza(long l) {
            this.zzc = l;
            this.zzc();
        }

        public final void zza(boolean bl) {
            this.zza = bl;
            this.zzc();
        }

        public final synchronized boolean zzb() {
            boolean bl = this.zzd;
            this.zzd = false;
            return bl;
        }

        private final void zzc() {
            if (this.zzc >= 0L || this.zza) {
                this.zzo().zza(this.zzf.zze);
                return;
            }
            this.zzo().zzb(this.zzf.zze);
        }

        @Override
        public final void zza(Activity activity) {
            zza zza2;
            if (this.zzb == 0 && (zza2 = this).zzj().zzb() >= zza2.zze + Math.max(1000L, zza2.zzc)) {
                this.zzd = true;
            }
            ++this.zzb;
            if (this.zza) {
                Activity activity2;
                String string;
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    this.zzf.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                this.zzf.set("&cd", this.zzf.zzg != null ? ((string2 = ((Tracker)this.zzf).zzg.zzg.get(string = (activity2 = activity).getClass().getCanonicalName())) != null ? string2 : string) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr")))) {
                    String string3;
                    String string4;
                    zza2 = activity;
                    zzbq.zza((Object)zza2);
                    activity2 = zza2.getIntent();
                    if (!TextUtils.isEmpty(activity2 == null ? null : (string4 = TextUtils.isEmpty((CharSequence)(string3 = activity2.getStringExtra("android.intent.extra.REFERRER_NAME"))) ? null : string3))) {
                        hashMap.put("&dr", string4);
                    }
                }
                this.zzf.send(hashMap);
            }
        }

        @Override
        public final void zzb(Activity activity) {
            --this.zzb;
            this.zzb = Math.max(0, this.zzb);
            if (this.zzb == 0) {
                this.zze = this.zzj().zzb();
            }
        }
    }
}

