/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.zze;
import com.google.android.gms.analytics.zzg;
import com.google.android.gms.analytics.zzl;
import com.google.android.gms.analytics.zzm;
import com.google.android.gms.analytics.zzn;
import com.google.android.gms.analytics.zzo;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzaql;
import com.google.android.gms.internal.zzaqq;
import com.google.android.gms.internal.zzatt;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Hide
public final class zzk {
    private static volatile zzk zza;
    private final Context zzb;
    private final List<zzn> zzc;
    private final zze zzd;
    private final zza zze;
    private volatile zzaql zzf;
    private Thread.UncaughtExceptionHandler zzg;

    private zzk(Context context) {
        Context context2 = context.getApplicationContext();
        zzbq.zza((Object)context2);
        this.zzb = context2;
        this.zze = new zza();
        this.zzc = new CopyOnWriteArrayList<zzn>();
        this.zzd = new zze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzk zza(Context context) {
        zzbq.zza((Object)context);
        if (zza != null) return zza;
        Class<zzk> clazz = zzk.class;
        synchronized (zzk.class) {
            if (zza != null) return zza;
            zza = new zzk(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zza;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzaql zza() {
        if (this.zzf == null) {
            zzk zzk2 = this;
            synchronized (zzk2) {
                if (this.zzf == null) {
                    zzaql zzaql2 = new zzaql();
                    PackageManager packageManager = this.zzb.getPackageManager();
                    String string = this.zzb.getPackageName();
                    zzaql2.zzc(string);
                    zzaql2.zzd(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.zzb.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string4 = String.valueOf(string2);
                        Log.e((String)"GAv4", (String)(string4.length() != 0 ? "Error retrieving package info: appName set to ".concat(string4) : new String("Error retrieving package info: appName set to ")));
                    }
                    zzaql2.zza(string2);
                    zzaql2.zzb(string3);
                    this.zzf = zzaql2;
                }
            }
        }
        return this.zzf;
    }

    public final zzaqq zzb() {
        int n;
        DisplayMetrics displayMetrics = this.zzb.getResources().getDisplayMetrics();
        zzaqq zzaqq2 = new zzaqq();
        zzaqq2.zza(zzatt.zza(Locale.getDefault()));
        zzaqq2.zzb = n = displayMetrics.widthPixels;
        zzaqq2.zzc = n = displayMetrics.heightPixels;
        return zzaqq2;
    }

    final void zza(zzg zzg2) {
        if (zzg2.zzi()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzg2.zzf()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        zzg zzg3 = zzg2.zza();
        zzg3.zzg();
        this.zze.execute(new zzl(this, zzg3));
    }

    @Hide
    public final Context zzc() {
        return this.zzb;
    }

    @Hide
    public static void zzd() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public final void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzg = uncaughtExceptionHandler;
    }

    @Hide
    public final <V> Future<V> zza(Callable<V> callable) {
        zzbq.zza(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zze.submit(callable);
    }

    @Hide
    public final void zza(Runnable runnable) {
        zzbq.zza((Object)runnable);
        this.zze.submit(runnable);
    }

    private static void zzb(zzg zzg2) {
        zzbq.zzc((String)"deliver should be called from worker thread");
        zzbq.zzb((boolean)zzg2.zzf(), (Object)"Measurement must be submitted");
        List<zzo> list = zzg2.zzc();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzo zzo2 : list) {
            Uri uri = zzo2.zza();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzo2.zza(zzg2);
        }
    }

    static /* synthetic */ List zza(zzk zzk2) {
        return zzk2.zzc;
    }

    static /* synthetic */ void zza(zzk zzk2, zzg zzg2) {
        zzk.zzb(zzg2);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler zzb(zzk zzk2) {
        return zzk2.zzg;
    }

    static final class zzb
    implements ThreadFactory {
        private static final AtomicInteger zza = new AtomicInteger();

        private zzb() {
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            int n = zza.incrementAndGet();
            String string = new StringBuilder(23).append("measurement-").append(n).toString();
            return new zzc(runnable, string);
        }

        /* synthetic */ zzb(zzl zzl2) {
            this();
        }
    }

    static final class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    final class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb(null));
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
            return new zzm(this, runnable, t);
        }
    }
}

